/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.discovery.k8s;

import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.transport.TransportService;

public class K8sUnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    private Kubernetes kubernetes;
    private final TransportService transportService;
    private final NetworkService networkService;
    private final String serviceId;
    private final String serviceDns;
    private final String namespace;
    private final TimeValue refreshInterval;
    private long lastRefresh;
    private List<DiscoveryNode> cachedDiscoNodes;

    @Inject
    public K8sUnicastHostsProvider(Settings settings, TransportService transportService, NetworkService networkService) {
        super(settings);
        this.transportService = transportService;
        this.networkService = networkService;
        this.refreshInterval = this.componentSettings.getAsTime("refresh_interval", settings.getAsTime("cloud.k8s.refresh_interval", TimeValue.timeValueSeconds((long)0L)));
        this.serviceId = this.componentSettings.get("service", settings.get("cloud.k8s.service"));
        this.serviceDns = this.componentSettings.get("service", settings.get("cloud.k8s.servicedns"));
        this.namespace = this.componentSettings.get("service", settings.get("cloud.k8s.namespace"));
        if (!(Strings.hasText((String)this.serviceId) && Strings.hasText((String)this.namespace) || Strings.hasText((String)this.serviceDns))) {
            this.logger.warn("Neither cloud.k8s.{} and cloud.k8s.{}, or cloud.k8s.{} are set.", new Object[]{"service", "namespace", "servicedns"});
        }
    }

    public List<DiscoveryNode> buildDynamicNodes() {
        if (this.refreshInterval.millis() != 0L) {
            if (this.cachedDiscoNodes != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("using cache to retrieve node list", new Object[0]);
                }
                return this.cachedDiscoNodes;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        this.logger.debug("start building nodes list using Kubernetes API", new Object[0]);
        this.cachedDiscoNodes = Lists.newArrayList();
        String currentIpAddress = null;
        try {
            InetAddress inetAddress = this.networkService.resolvePublishHostAddress(null);
            if (inetAddress != null) {
                currentIpAddress = inetAddress.getHostAddress();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (Strings.hasText((String)this.serviceId)) {
                return this.getNodesFromKubernetesSelector(currentIpAddress);
            }
            if (Strings.hasText((String)this.serviceDns)) {
                return this.getNodesFromKubernetesServiceDns(currentIpAddress);
            }
        }
        catch (Throwable e) {
            this.logger.warn("Exception caught during discovery {} : {}", e, new Object[]{e.getClass().getName(), e.getMessage()});
            this.logger.trace("Exception caught during discovery", e, new Object[0]);
        }
        this.logger.debug("{} node(s) added", new Object[]{this.cachedDiscoNodes.size()});
        this.logger.debug("using dynamic discovery nodes {}", new Object[]{this.cachedDiscoNodes});
        return this.cachedDiscoNodes;
    }

    private List<DiscoveryNode> getNodesFromKubernetesSelector(String currentIpAddress) {
        Endpoints endpoints = this.getKubernetes().endpointsForService(this.serviceId, this.namespace);
        int podsCount = 0;
        for (EndpointSubset es : endpoints.getSubsets()) {
            for (EndpointAddress address : es.getAddresses()) {
                ++podsCount;
                String endpointIp = address.getIp();
                if (endpointIp.equals(currentIpAddress)) {
                    this.logger.trace("Current node found. Ignoring {}", new Object[]{endpointIp});
                    continue;
                }
                try {
                    TransportAddress[] addresses = this.transportService.addressesFromString(endpointIp.concat(":9300"));
                    this.logger.trace("Adding address {}", new Object[]{addresses[0]});
                    this.cachedDiscoNodes.add(new DiscoveryNode(endpointIp, addresses[0], Version.CURRENT));
                }
                catch (Exception ex) {
                    this.logger.error("Couldn't add address", (Throwable)ex, new Object[0]);
                }
            }
        }
        this.logger.trace("Found {} for serviceId [{}].", new Object[]{podsCount, this.serviceId});
        return this.cachedDiscoNodes;
    }

    private List<DiscoveryNode> getNodesFromKubernetesServiceDns(String currentIpAddress) throws Exception {
        Set serviceEndpointIps = KubernetesHelper.lookupServiceInDns((String)this.serviceDns);
        if (serviceEndpointIps == null) {
            this.logger.trace("no service endpoints found for service name [{}].", new Object[]{this.serviceDns});
            return this.cachedDiscoNodes;
        }
        for (String endpointIp : serviceEndpointIps) {
            if (endpointIp.equals(currentIpAddress)) {
                this.logger.trace("current node found. Ignoring {} - {}", new Object[]{endpointIp});
                continue;
            }
            String address = endpointIp.concat(":9300");
            TransportAddress[] addresses = this.transportService.addressesFromString(address);
            this.logger.trace("adding address {}, transport_address {}", new Object[]{endpointIp, addresses[0]});
            this.cachedDiscoNodes.add(new DiscoveryNode("#cloud-".concat(this.serviceDns).concat("-").concat(endpointIp) + "-" + 0, addresses[0], Version.CURRENT));
        }
        return this.cachedDiscoNodes;
    }

    private Kubernetes getKubernetes() {
        if (this.kubernetes == null) {
            this.kubernetes = new KubernetesFactory().createKubernetes();
        }
        return this.kubernetes;
    }

    public static final class Fields {
        public static final String REFRESH = "refresh_interval";
        public static final String VERSION = "Elasticsearch/K8sCloud/1.0";
        public static final String SERVICE = "service";
        public static final String NAMESPACE = "namespace";
        public static final String SERVICE_DNS = "servicedns";
    }
}

