/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jgroups;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Port;
import io.fabric8.utils.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.stack.IpAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MBean(description="Kubernetes discovery protocol")
public class KubernetesDiscovery
extends Discovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesDiscovery.class);
    @Property
    private String address;
    private KubernetesClient client;

    public void start() throws Exception {
        this.client = new KubernetesClient(new KubernetesFactory(this.address));
    }

    public Collection<PhysicalAddress> fetchClusterMembers(String cluster_name) {
        ArrayList<PhysicalAddress> result = new ArrayList<PhysicalAddress>();
        Map<String, String> labels = Collections.singletonMap("cluster", cluster_name);
        Filter podFilter = KubernetesHelper.createPodFilter(labels);
        List<Pod> podList = KubernetesDiscovery.filterPods(this.client.getPods().getItems(), (Filter<Pod>)podFilter);
        for (Pod pod : podList) {
            if (!podFilter.matches((Object)pod)) continue;
            List containers = KubernetesHelper.getContainers((Pod)pod);
            for (Container container : containers) {
                for (Port port : container.getPorts()) {
                    if (!"jgroups-tcp-port".equals(port.getName())) continue;
                    try {
                        IpAddress address = new IpAddress(pod.getCurrentState().getPodIP(), port.getContainerPort().intValue());
                        result.add((PhysicalAddress)address);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Failed to create Address {}.", (Object)pod.getCurrentState().getPodIP());
                    }
                }
            }
        }
        return result;
    }

    public boolean sendDiscoveryRequestsInParallel() {
        return false;
    }

    public boolean isDynamic() {
        return true;
    }

    private static List<Pod> filterPods(List<Pod> pods, Filter<Pod> podFilter) {
        ArrayList<Pod> result = new ArrayList<Pod>();
        for (Pod pod : pods) {
            if (!podFilter.matches((Object)pod)) continue;
            result.add(pod);
        }
        return result;
    }
}

