/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricAuthenticationException;
import io.fabric8.api.FabricService;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.boot.commands.support.AbstractContainerCreateAction;
import io.fabric8.utils.FabricValidations;
import io.fabric8.utils.shell.ShellUtils;
import java.io.IOException;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="container-create-child", scope="fabric", description="Creates one or more child containers", detailedDescription="classpath:containerCreateChild.txt")
public class ContainerCreateChildAction
extends AbstractContainerCreateAction {
    @Option(name="--jmx-user", multiValued=false, required=false, description="The jmx user name of the parent container.")
    protected String username;
    @Option(name="--jmx-password", multiValued=false, required=false, description="The jmx password of the parent container.")
    protected String password;
    @Argument(index=0, required=true, description="Parent (root) container ID")
    protected String parent;
    @Argument(index=1, required=true, description="The name of the containers to be created. When creating multiple containers it serves as a prefix")
    protected String name;
    @Argument(index=2, required=false, description="The number of containers that should be created")
    protected int number = 0;

    ContainerCreateChildAction(FabricService fabricService, ZooKeeperClusterService clusterService) {
        super(fabricService, clusterService);
    }

    protected Object doExecute() throws Exception {
        CreateContainerMetadata[] metadata = null;
        FabricValidations.validateProfileNames(this.profiles);
        this.preCreateContainer(this.name);
        this.validateParentContainer(this.parent);
        String jmxUser = this.username != null ? this.username : ShellUtils.retrieveFabricUser(this.session);
        String jmxPassword = this.password != null ? this.password : ShellUtils.retrieveFabricUserPassword(this.session);
        CreateChildContainerOptions.Builder builder = (CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)CreateChildContainerOptions.builder().name(this.name)).parent(this.parent)).bindAddress(this.bindAddress)).resolver(this.resolver)).manualIp(this.manualIp)).ensembleServer(this.isEnsembleServer.booleanValue())).number(this.number)).zookeeperUrl(this.fabricService.getZookeeperUrl())).zookeeperPassword(this.fabricService.getZookeeperPassword())).jvmOpts(this.jvmOpts != null ? this.jvmOpts : this.fabricService.getDefaultJvmOptions())).jmxUser(jmxUser).jmxPassword(jmxPassword).version(this.version)).profiles(this.getProfileNames())).dataStoreProperties(this.getDataStoreProperties());
        try {
            metadata = this.fabricService.createContainers((CreateContainerOptions)builder.build());
            this.rethrowAuthenticationErrors(metadata);
            ShellUtils.storeFabricCredentials(this.session, jmxUser, jmxPassword);
        }
        catch (FabricAuthenticationException ex) {
            this.username = null;
            this.password = null;
            this.promptForJmxCredentialsIfNeeded();
            metadata = this.fabricService.createContainers((CreateContainerOptions)builder.jmxUser(this.username).jmxPassword(this.password).build());
            ShellUtils.storeFabricCredentials(this.session, this.username, this.password);
        }
        this.displayContainers(metadata);
        return null;
    }

    protected void validateParentContainer(String parent) {
        Container container = this.fabricService.getContainer(parent);
        if (container == null) {
            throw new IllegalArgumentException("Parent container " + parent + " does not exists!");
        }
        if (!container.isRoot()) {
            throw new IllegalArgumentException("Parent container " + parent + " must be a root container!");
        }
    }

    protected void preCreateContainer(String name) {
        super.preCreateContainer(name);
        if (this.number < 0 || this.number > 99) {
            throw new IllegalArgumentException("The number of containers must be between 1 and 99.");
        }
        if (this.isEnsembleServer.booleanValue() && this.number > 1) {
            throw new IllegalArgumentException("Can not create a new ZooKeeper ensemble on multiple containers. Create the containers first and then use the fabric:create command instead.");
        }
    }

    private void promptForJmxCredentialsIfNeeded() throws IOException {
        if (this.username == null) {
            this.log.debug("Prompting user for jmx login");
            this.username = ShellUtils.readLine(this.session, "Jmx Login for " + this.parent + ": ", false);
        }
        if (this.password == null) {
            this.password = ShellUtils.readLine(this.session, "Jmx Password for " + this.parent + ": ", true);
        }
    }
}

