/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.api.gravia.IllegalStateAssertion;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="version-delete", scope="fabric", description="Delete the specified version, together with all of its associated profile data")
public class VersionDeleteAction
extends AbstractAction {
    @Argument(index=0, name="version", description="The version to delete", required=true, multiValued=false)
    private String versionId;
    private final ProfileService profileService;
    private final FabricService fabricService;

    VersionDeleteAction(FabricService fabricService) {
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        Version version = this.profileService.getRequiredVersion(this.versionId);
        StringBuilder sb = new StringBuilder();
        for (Container container : this.fabricService.getContainers()) {
            if (!version.equals(container.getVersion())) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(container.getId());
        }
        IllegalStateAssertion.assertTrue((Boolean)(sb.length() == 0 ? 1 : 0), (String)("Version " + this.versionId + " is still used by the following containers: " + sb.toString()));
        Version currentDefault = this.fabricService.getDefaultVersion();
        if (version.compareTo((Object)currentDefault) == 0) {
            System.out.println("Default Version " + version + " can't get deleted.");
        } else {
            this.profileService.deleteVersion(this.versionId);
        }
        return null;
    }
}

