/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.await;

import java.util.concurrent.Callable;

public class WaitStrategy {
    private final Callable<Boolean> condition;
    private final long timeout;
    private final long pollInterval;

    public WaitStrategy(Callable<Boolean> condition, long timeout, long pollInterval) {
        this.condition = condition;
        this.timeout = timeout;
        this.pollInterval = pollInterval;
    }

    public boolean await() throws Exception {
        long start = System.currentTimeMillis();
        while (!Thread.interrupted() && System.currentTimeMillis() - start <= this.timeout) {
            try {
                if (this.condition.call().booleanValue()) {
                    return true;
                }
                Thread.sleep(this.pollInterval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }
}

