/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.arquillian.kubernetes.Configuration;
import io.fabric8.arquillian.kubernetes.DependencyResolver;
import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.kubernetes.ShutdownHook;
import io.fabric8.arquillian.kubernetes.await.CompositeCondition;
import io.fabric8.arquillian.kubernetes.await.SessionPodsAreReady;
import io.fabric8.arquillian.kubernetes.await.SessionServicesAreReady;
import io.fabric8.arquillian.kubernetes.await.WaitStrategy;
import io.fabric8.arquillian.kubernetes.event.Start;
import io.fabric8.arquillian.kubernetes.event.Stop;
import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.arquillian.utils.Commands;
import io.fabric8.arquillian.utils.ConfigMaps;
import io.fabric8.arquillian.utils.Namespaces;
import io.fabric8.arquillian.utils.Routes;
import io.fabric8.arquillian.utils.SecretKeys;
import io.fabric8.arquillian.utils.Secrets;
import io.fabric8.arquillian.utils.URLs;
import io.fabric8.arquillian.utils.Util;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.internal.HasMetadataComparator;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DoneableSecurityContextConstraints;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.SecurityContextConstraints;
import io.fabric8.openshift.api.model.SecurityContextConstraintsFluent;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.Files;
import io.fabric8.utils.MultiException;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import org.jboss.arquillian.core.api.annotation.Observes;

public class SessionListener {
    private ShutdownHook shutdownHook;
    private DependencyResolver resolver = new DependencyResolver();

    public void start(@Observes Start event, KubernetesClient client, Controller controller, Configuration configuration) throws Exception {
        Objects.requireNonNull(client, "KubernetesClient most not be null!");
        Session session = event.getSession();
        Logger log = session.getLogger();
        String namespace = session.getNamespace();
        System.setProperty("kubernetes.namespace", namespace);
        log.status("Using Kubernetes at: " + client.getMasterUrl());
        log.status("Creating kubernetes resources inside namespace: " + namespace);
        log.info("if you use OpenShift then type this switch namespaces:     oc project " + namespace);
        log.info("if you use kubernetes then type this to switch namespaces: kubectl namespace " + namespace);
        this.clearTestResultDirectories(session);
        controller.setNamespace(namespace);
        controller.setThrowExceptionOnError(true);
        controller.setRecreateMode(true);
        controller.setIgnoreRunningOAuthClients(true);
        if (configuration.isCreateNamespaceForTest()) {
            Namespaces.createNamespace(client, controller, session);
        } else {
            String namespaceToUse = configuration.getNamespace();
            Namespaces.checkNamespace(client, controller, session, configuration);
            ConfigMaps.updateConfigMapStatus(client, session, "RUNNING");
            namespace = namespaceToUse;
            controller.setNamespace(namespace);
        }
        LinkedList<KubernetesList> kubeConfigs = new LinkedList<KubernetesList>();
        this.shutdownHook = new ShutdownHook(client, controller, configuration, session, kubeConfigs);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        try {
            List<String> dependencies;
            URL configUrl = configuration.getEnvironmentConfigUrl();
            List<String> list = dependencies = !configuration.getEnvironmentDependencies().isEmpty() ? configuration.getEnvironmentDependencies() : this.resolver.resolve(session);
            if (configuration.isEnvironmentInitEnabled()) {
                File[] files;
                File targetDir;
                for (String dependency : dependencies) {
                    log.info("Found dependency: " + dependency);
                    this.loadDependency(log, kubeConfigs, dependency, controller, configuration, namespace);
                }
                OpenShiftClient openShiftClient = controller.getOpenShiftClientOrNull();
                if (configUrl == null) {
                    String resourceName = "kubernetes.yml";
                    if (openShiftClient != null && openShiftClient.supportsOpenShiftAPIGroup("image.openshift.io") && openShiftClient.supportsOpenShiftAPIGroup("route.openshift.io")) {
                        resourceName = "openshift.yml";
                    }
                    configUrl = Configuration.findConfigResource("/META-INF/fabric8/" + resourceName);
                }
                if (configUrl != null) {
                    log.status("Applying kubernetes configuration from: " + configUrl);
                    String configText = Util.readAsString(configUrl);
                    Object dto = null;
                    String configPath = configUrl.getPath();
                    dto = configPath.endsWith(".yml") || configPath.endsWith(".yaml") ? KubernetesHelper.loadYaml((String)configText, KubernetesResource.class) : KubernetesHelper.loadJson((String)configText);
                    dto = this.expandTemplate(controller, configuration, log, namespace, configUrl.toString(), dto);
                    KubernetesList kubeList = KubernetesHelper.asKubernetesList((Object)dto);
                    List items = kubeList.getItems();
                    kubeConfigs.add(kubeList);
                }
                if (openShiftClient != null && openShiftClient.supportsOpenShiftAPIGroup("image.openshift.io") && (targetDir = new File(System.getProperty("basedir", ".") + "/target")).exists() && targetDir.isDirectory() && (files = targetDir.listFiles()) != null) {
                    for (File file : files) {
                        if (!file.getName().endsWith("-is.yml")) continue;
                        this.loadDependency(log, kubeConfigs, file.toURI().toURL().toString(), controller, configuration, namespace);
                    }
                }
            }
            if (configuration.isEnvironmentInitEnabled() && !this.applyConfiguration(client, controller, configuration, session, kubeConfigs)) {
                throw new IllegalStateException("Failed to apply kubernetes configuration.");
            }
            Util.displaySessionStatus(client, session);
        }
        catch (Exception e) {
            try {
                Util.cleanupSession(client, controller, configuration, session, kubeConfigs, "ERROR");
            }
            catch (MultiException me) {
                throw e;
            }
            finally {
                if (this.shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
            }
            throw new RuntimeException(e);
        }
    }

    private void clearTestResultDirectories(Session session) {
        Files.recursiveDelete((File)new File(session.getBaseDir(), "target/test-pod-status"));
        Files.recursiveDelete((File)new File(session.getBaseDir(), "target/test-pod-logs"));
    }

    protected Object expandTemplate(Controller controller, Configuration configuration, Logger log, String namespace, String sourceName, Object dto) {
        if (dto instanceof Template) {
            Template template = (Template)dto;
            KubernetesHelper.setNamespace((HasMetadata)template, (String)namespace);
            String parameterNamePrefix = "";
            Templates.overrideTemplateParameters((Template)template, configuration.getProperties(), (String)parameterNamePrefix);
            log.status("Applying template in namespace " + namespace);
            controller.installTemplate(template, sourceName);
            dto = controller.processTemplate(template, sourceName);
            if (dto == null) {
                throw new IllegalArgumentException("Failed to process Template!");
            }
        }
        return dto;
    }

    protected void addConfig(List<KubernetesList> kubeConfigs, Object dto, Controller controller, Configuration configuration, Logger log, String namespace, String sourceName) {
        if ((dto = this.expandTemplate(controller, configuration, log, namespace, sourceName, dto)) instanceof KubernetesList) {
            kubeConfigs.add((KubernetesList)dto);
        } else if (dto instanceof HasMetadata) {
            KubernetesList wrappedItem = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(new HasMetadata[]{(HasMetadata)dto})).build();
            kubeConfigs.add(wrappedItem);
        } else {
            throw new IllegalArgumentException("Unsupported object type in " + sourceName + ". Class: " + (dto != null ? dto.getClass().getName() : "null object"));
        }
    }

    public void loadDependency(Logger log, List<KubernetesList> kubeConfigs, String dependency, Controller controller, Configuration configuration, String namespace) throws Exception {
        String baseDir = System.getProperty("basedir", ".");
        String path = baseDir + "/" + dependency;
        File file = new File(path);
        if (file.exists()) {
            this.loadDependency(log, kubeConfigs, file, controller, configuration, log, namespace);
        } else {
            String text = Util.readAsString(this.createURL(dependency));
            Object resources = text.trim().startsWith("---") || dependency.endsWith(".yml") || dependency.endsWith(".yaml") ? KubernetesHelper.loadYaml((String)text) : KubernetesHelper.loadJson((String)text);
            this.addConfig(kubeConfigs, resources, controller, configuration, log, namespace, dependency);
        }
    }

    protected URL createURL(final String dependency) throws Exception {
        return URLs.doWithMavenURLHandlerFactory(new Callable<URL>(){

            @Override
            public URL call() throws Exception {
                return new URL(dependency);
            }
        });
    }

    protected void loadDependency(Logger log, List<KubernetesList> kubeConfigs, File file, Controller controller, Configuration configuration, Logger logger, String namespace) throws IOException {
        if (file.isFile()) {
            log.info("Loading file " + file);
            Object content = file.getName().endsWith(".yaml") || file.getName().endsWith(".yml") ? KubernetesHelper.loadYaml((File)file) : KubernetesHelper.loadJson((File)file);
            this.addConfig(kubeConfigs, content, controller, configuration, log, namespace, file.getPath());
        } else {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    String name = child.getName().toLowerCase();
                    if (!name.endsWith(".json") && !name.endsWith(".yaml") && !name.endsWith(".yml")) continue;
                    this.loadDependency(log, kubeConfigs, child, controller, configuration, log, namespace);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@Observes Stop event, KubernetesClient client, Controller controller, Configuration configuration, List<KubernetesList> kubeConfigs) throws Exception {
        try {
            Session session = event.getSession();
            Util.cleanupSession(client, controller, configuration, session, kubeConfigs, Util.getSessionStatus(session));
        }
        finally {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
    }

    private boolean applyConfiguration(KubernetesClient client, Controller controller, Configuration configuration, Session session, List<KubernetesList> kubeConfigs) throws Exception {
        Logger log = session.getLogger();
        TreeMap<Integer, Callable<Boolean>> conditions = new TreeMap<Integer, Callable<Boolean>>();
        SessionPodsAreReady sessionPodsReady = new SessionPodsAreReady(client, session);
        SessionServicesAreReady servicesReady = new SessionServicesAreReady(client, session, configuration);
        TreeSet<HasMetadata> entities = new TreeSet<HasMetadata>((Comparator<HasMetadata>)new HasMetadataComparator());
        for (KubernetesList c : kubeConfigs) {
            entities.addAll(this.enhance(session, configuration, c).getItems());
        }
        if (!this.containsImageStreamResources(entities)) {
            String registry = this.getLocalDockerRegistry();
            if (Strings.isNotBlank((String)registry)) {
                log.status("Adapting resources to pull images from registry: " + registry);
                this.addRegistryToImageNameIfNotPresent(entities, registry);
            } else {
                log.status("No local fabric8 docker registry found");
            }
        }
        ArrayList<HasMetadata> items = new ArrayList<HasMetadata>();
        items.addAll(entities);
        Collections.sort(items, new Comparator<Object>(){

            @Override
            public int compare(Object left, Object right) {
                if (left instanceof Service) {
                    return -1;
                }
                if (right instanceof Service) {
                    return 1;
                }
                return 0;
            }
        });
        boolean isOpenshift = client.isAdaptable(OpenShiftClient.class);
        String namespace = session.getNamespace();
        String routeDomain = null;
        if (Strings.isNotBlank((String)configuration.getKubernetesDomain())) {
            routeDomain = configuration.getKubernetesDomain();
        }
        this.preprocessEnvironment(client, controller, configuration, session);
        TreeSet<Route> extraEntities = new TreeSet<Route>((Comparator<Route>)new HasMetadataComparator());
        for (Object e : items) {
            String serviceAccountName;
            Set<Secret> secrets;
            if (e instanceof Pod) {
                Pod pod = (Pod)e;
                log.status("Applying pod:" + KubernetesHelper.getName((HasMetadata)pod));
                secrets = this.generateSecrets(client, session, pod.getMetadata());
                serviceAccountName = pod.getSpec().getServiceAccountName();
                if (Strings.isNotBlank((String)serviceAccountName)) {
                    this.generateServiceAccount(client, session, secrets, serviceAccountName);
                }
                controller.applyPod(pod, session.getId());
                conditions.put(1, sessionPodsReady);
                continue;
            }
            if (e instanceof Service) {
                Route route;
                Service service = (Service)e;
                String serviceName = KubernetesHelper.getName((HasMetadata)service);
                log.status("Applying service:" + serviceName);
                controller.applyService(service, session.getId());
                conditions.put(2, servicesReady);
                if (!isOpenshift || (route = Routes.createRouteForService(routeDomain, namespace, service, log)) == null) continue;
                log.status("Applying route for:" + serviceName);
                controller.applyRoute(route, "route for " + serviceName);
                extraEntities.add(route);
                continue;
            }
            if (e instanceof ReplicationController) {
                ReplicationController replicationController = (ReplicationController)e;
                log.status("Applying replication controller:" + KubernetesHelper.getName((HasMetadata)replicationController));
                secrets = this.generateSecrets(client, session, replicationController.getSpec().getTemplate().getMetadata());
                serviceAccountName = replicationController.getSpec().getTemplate().getSpec().getServiceAccountName();
                if (Strings.isNotBlank((String)serviceAccountName)) {
                    this.generateServiceAccount(client, session, secrets, serviceAccountName);
                }
                controller.applyReplicationController(replicationController, session.getId());
                conditions.put(1, sessionPodsReady);
                continue;
            }
            if (e instanceof ReplicaSet || e instanceof Deployment || e instanceof DeploymentConfig) {
                log.status("Applying " + e.getClass().getSimpleName() + ".");
                controller.apply(e, session.getId());
                conditions.put(1, sessionPodsReady);
                continue;
            }
            if (e instanceof OAuthClient) {
                OAuthClient oc = (OAuthClient)e;
                ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)oc);
                String name = metadata.getName();
                if (!isOpenshift) continue;
                OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
                OAuthClient current = (OAuthClient)((Resource)openShiftClient.oAuthClients().withName(name)).get();
                boolean create = false;
                if (current == null) {
                    current = oc;
                    create = true;
                }
                boolean updated = false;
                List redirectURIs = current.getRedirectURIs();
                String namespaceSuffix = "-" + namespace;
                String redirectUri = "http://" + name + namespaceSuffix;
                if (Strings.isNotBlank((String)routeDomain)) {
                    redirectUri = redirectUri + "." + Strings.stripPrefix((String)routeDomain, (String)".");
                }
                if (!redirectURIs.contains(redirectUri)) {
                    redirectURIs.add(redirectUri);
                    updated = true;
                }
                current.setRedirectURIs(redirectURIs);
                log.status("Applying OAuthClient:" + name);
                controller.setSupportOAuthClients(true);
                if (create) {
                    openShiftClient.oAuthClients().create((Object[])new OAuthClient[]{current});
                    continue;
                }
                if (!updated) continue;
                ((Resource)openShiftClient.oAuthClients().withName(name)).delete();
                current.getMetadata().setResourceVersion(null);
                openShiftClient.oAuthClients().create((Object[])new OAuthClient[]{current});
                continue;
            }
            if (e instanceof HasMetadata) {
                log.status("Applying " + e.getClass().getSimpleName() + ":" + KubernetesHelper.getName((HasMetadata)((HasMetadata)e)));
                controller.apply(e, session.getId());
                continue;
            }
            if (e == null) continue;
            log.status("Applying " + e.getClass().getSimpleName() + ".");
            controller.apply(e, session.getId());
        }
        entities.addAll(extraEntities);
        if (!conditions.isEmpty()) {
            CompositeCondition compositeCondition = new CompositeCondition(conditions.values());
            WaitStrategy waitStrategy = new WaitStrategy(compositeCondition, configuration.getWaitTimeout(), configuration.getWaitPollInterval());
            if (!waitStrategy.await()) {
                log.error("Timed out waiting for pods/services!");
                return false;
            }
            log.status("All pods/services are currently 'running'!");
        } else {
            log.warn("No pods/services/replication controllers defined in the configuration!");
        }
        return true;
    }

    private boolean containsImageStreamResources(Iterable<HasMetadata> entities) {
        if (entities != null) {
            for (HasMetadata entity : entities) {
                if (!(entity instanceof ImageStream)) continue;
                return true;
            }
        }
        return false;
    }

    protected void preprocessEnvironment(KubernetesClient client, Controller controller, Configuration configuration, Session session) {
        if (configuration.isUseGoFabric8()) {
            Logger logger = session.getLogger();
            Commands.assertCommand(logger, "oc", "project", session.getNamespace());
            Commands.assertCommand(logger, "gofabric8", "deploy", "-y", "--console=false", "--templates=false");
            Commands.assertCommand(logger, "gofabric8", "secrets", "-y");
        }
    }

    private void generateServiceAccount(KubernetesClient client, Session session, Set<Secret> secrets, String serviceAccountName) {
        ServiceAccount serviceAccount;
        ArrayList<ObjectReference> secretRefs = new ArrayList<ObjectReference>();
        for (Secret secret : secrets) {
            secretRefs.add(((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withNamespace(session.getNamespace())).withName(KubernetesHelper.getName((HasMetadata)secret))).build());
        }
        SecurityContextConstraints securityContextConstraints = (SecurityContextConstraints)((Resource)client.securityContextConstraints().withName(session.getNamespace())).get();
        if (securityContextConstraints == null) {
            ((DoneableSecurityContextConstraints)((DoneableSecurityContextConstraints)((SecurityContextConstraintsFluent.SeLinuxContextNested)((DoneableSecurityContextConstraints)((SecurityContextConstraintsFluent.RunAsUserNested)((DoneableSecurityContextConstraints)((DoneableSecurityContextConstraints)((DoneableSecurityContextConstraints)((SecurityContextConstraintsFluent.MetadataNested)((DoneableSecurityContextConstraints)client.securityContextConstraints().createNew()).withNewMetadata().withName(session.getNamespace())).endMetadata()).withAllowHostDirVolumePlugin(Boolean.valueOf(true))).withAllowPrivilegedContainer(Boolean.valueOf(true))).withNewRunAsUser().withType("RunAsAny")).endRunAsUser()).withNewSeLinuxContext().withType("RunAsAny")).endSeLinuxContext()).withUsers(new String[]{"system:serviceaccount:" + session.getNamespace() + ":" + serviceAccountName})).done();
        }
        if ((serviceAccount = (ServiceAccount)((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(session.getNamespace())).withName(serviceAccountName)).get()) == null) {
            ((DoneableServiceAccount)((DoneableServiceAccount)((ServiceAccountFluent.MetadataNested)((DoneableServiceAccount)((NonNamespaceOperation)client.serviceAccounts().inNamespace(session.getNamespace())).createNew()).withNewMetadata().withName(serviceAccountName)).endMetadata()).withSecrets(secretRefs)).done();
        } else {
            ((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(session.getNamespace())).withName(serviceAccountName)).replace((Object)((ServiceAccountBuilder)((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder(serviceAccount).withNewMetadata().withName(serviceAccountName)).endMetadata()).addToSecrets(secretRefs.toArray(new ObjectReference[secretRefs.size()]))).build());
        }
    }

    private Set<Secret> generateSecrets(KubernetesClient client, Session session, ObjectMeta meta) {
        HashSet<Secret> secrets = new HashSet<Secret>();
        Map annotations = meta.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            for (Map.Entry entry : annotations.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!SecretKeys.isSecretKey(key)) continue;
                SecretKeys keyType = SecretKeys.fromValue(key);
                for (String name : Secrets.getNames(value)) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    Secret secret = null;
                    try {
                        secret = (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(session.getNamespace())).withName(name)).get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (secret != null) continue;
                    for (String c : Secrets.getContents(value, name)) {
                        data.put(c, keyType.generate());
                    }
                    secret = ((DoneableSecret)((DoneableSecret)((SecretFluent.MetadataNested)((DoneableSecret)((NonNamespaceOperation)client.secrets().inNamespace(session.getNamespace())).createNew()).withNewMetadata().withName(name)).endMetadata()).withData(data)).done();
                    secrets.add(secret);
                }
            }
        }
        return secrets;
    }

    private KubernetesList enhance(final Session session, Configuration configuration, KubernetesList kubernetesList) {
        if (configuration == null || configuration.getProperties() == null || !configuration.getProperties().containsKey("kubernetes.model.processor.class.name")) {
            return kubernetesList;
        }
        String processorClassName = configuration.getProperties().get("kubernetes.model.processor.class.name");
        try {
            final Object instance = SessionListener.class.getClassLoader().loadClass(processorClassName).newInstance();
            KubernetesListBuilder builder = new KubernetesListBuilder(kubernetesList);
            builder.accept(new Visitor(){

                public void visit(Object o) {
                    for (Method m : SessionListener.findMethods(instance, o.getClass())) {
                        Named named = m.getAnnotation(Named.class);
                        if (named != null && !Strings.isNullOrBlank((String)named.value())) {
                            String objectName;
                            String string = objectName = o instanceof ObjectMeta ? KubernetesHelper.getName((ObjectMeta)((ObjectMeta)o)) : KubernetesHelper.getName((HasMetadata)((HasMetadata)o));
                            if (!named.value().equals(objectName)) {
                                session.getLogger().warn("Named method:" + m.getName() + " with name:" + named.value() + " doesn't match: " + objectName + ", ignoring");
                                return;
                            }
                        }
                        try {
                            m.invoke(instance, o);
                        }
                        catch (IllegalAccessException objectName) {
                        }
                        catch (InvocationTargetException e) {
                            session.getLogger().error("Error invoking visitor method:" + m.getName() + " on:" + instance + "with argument:" + o);
                        }
                    }
                }
            });
            return builder.build();
        }
        catch (Exception e) {
            session.getLogger().warn("Failed to load processor class:" + processorClassName + ". Ignoring");
            return kubernetesList;
        }
    }

    private static Set<Method> findMethods(Object instance, Class argumentType) {
        LinkedHashSet<Method> result = new LinkedHashSet<Method>();
        for (Method m : instance.getClass().getDeclaredMethods()) {
            if (m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(argumentType)) continue;
            result.add(m);
        }
        return result;
    }

    private String getLocalDockerRegistry() {
        if (Strings.isNotBlank((String)System.getenv("FABRIC8_DOCKER_REGISTRY_SERVICE_HOST"))) {
            return System.getenv("FABRIC8_DOCKER_REGISTRY_SERVICE_HOST") + ":" + System.getenv("FABRIC8_DOCKER_REGISTRY_SERVICE_PORT");
        }
        return null;
    }

    public void addRegistryToImageNameIfNotPresent(Iterable<HasMetadata> items, String registry) throws Exception {
        if (items != null) {
            for (HasMetadata item : items) {
                List containers;
                if (item instanceof KubernetesList) {
                    KubernetesList list = (KubernetesList)item;
                    this.addRegistryToImageNameIfNotPresent(list.getItems(), registry);
                    continue;
                }
                if (item instanceof Template) {
                    Template template = (Template)item;
                    this.addRegistryToImageNameIfNotPresent(template.getObjects(), registry);
                    continue;
                }
                if (item instanceof Pod) {
                    containers = ((Pod)item).getSpec().getContainers();
                    this.prefixRegistryIfNotPresent(containers, registry);
                    continue;
                }
                if (item instanceof ReplicationController) {
                    containers = ((ReplicationController)item).getSpec().getTemplate().getSpec().getContainers();
                    this.prefixRegistryIfNotPresent(containers, registry);
                    continue;
                }
                if (item instanceof ReplicaSet) {
                    containers = ((ReplicaSet)item).getSpec().getTemplate().getSpec().getContainers();
                    this.prefixRegistryIfNotPresent(containers, registry);
                    continue;
                }
                if (item instanceof DeploymentConfig) {
                    containers = ((DeploymentConfig)item).getSpec().getTemplate().getSpec().getContainers();
                    this.prefixRegistryIfNotPresent(containers, registry);
                    continue;
                }
                if (!(item instanceof Deployment)) continue;
                containers = ((Deployment)item).getSpec().getTemplate().getSpec().getContainers();
                this.prefixRegistryIfNotPresent(containers, registry);
            }
        }
    }

    private void prefixRegistryIfNotPresent(List<Container> containers, String registry) {
        for (Container container : containers) {
            if (SessionListener.hasRegistry(container.getImage())) continue;
            container.setImage(registry + "/" + container.getImage());
        }
    }

    public static boolean hasRegistry(String imageName) {
        if (imageName == null) {
            throw new NullPointerException("Image name must not be null");
        }
        Pattern tagPattern = Pattern.compile("^(.+?)(?::([^:/]+))?$");
        Matcher matcher = tagPattern.matcher(imageName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(imageName + " is not a proper image name ([registry/][repo][:port]");
        }
        String rest = matcher.group(1);
        String[] parts = rest.split("\\s*/\\s*");
        String part = parts[0];
        return part.contains(".") || part.contains(":");
    }
}

