/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.utils.Closeables;
import io.fabric8.utils.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import org.junit.Assert;

public class Commands {
    public static void assertCommand(Logger logger, String ... commandArray) {
        String commandText = Strings.join(Arrays.asList(commandArray), (String)" ");
        logger.info("Invoking command: " + commandText);
        try {
            Process process = Runtime.getRuntime().exec(commandArray);
            Commands.processOutput(logger, process.getInputStream(), true);
            Commands.processOutput(logger, process.getErrorStream(), false);
            int status = process.waitFor();
            Assert.assertEquals((String)("status code of: " + commandText), (long)0L, (long)status);
        }
        catch (Exception e) {
            throw new AssertionError("Failed to invoke: " + commandText + "\n" + e, e);
        }
    }

    protected static void processOutput(Logger logger, InputStream inputStream, boolean error) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (error) {
                    logger.error(line);
                    continue;
                }
                logger.info(line);
            }
        }
        catch (Exception e) {
            logger.error("Failed to process " + (error ? "stderr" : "stdout") + ": " + e);
            throw e;
        }
        finally {
            Closeables.closeQuietly((Reader)reader);
        }
    }
}

