/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteTargetReference;
import io.fabric8.openshift.api.model.RouteTargetReferenceBuilder;
import io.fabric8.utils.Strings;
import java.util.Set;

public class Routes {
    public static Route createRouteForService(String routeDomainPostfix, String namespace, Service service, Logger log) {
        Route route = null;
        String id = KubernetesHelper.getName((HasMetadata)service);
        if (Strings.isNotBlank((String)id) && Routes.shouldCreateRouteForService(log, service, id)) {
            route = new Route();
            String routeId = id;
            KubernetesHelper.setName((HasMetadata)route, (String)namespace, (String)routeId);
            RouteSpec routeSpec = new RouteSpec();
            RouteTargetReference objectRef = ((RouteTargetReferenceBuilder)new RouteTargetReferenceBuilder().withName(id)).build();
            routeSpec.setTo(objectRef);
            if (Strings.isNotBlank((String)routeDomainPostfix)) {
                String host = Strings.stripSuffix((String)Strings.stripSuffix((String)id, (String)"-service"), (String)".");
                String namespaceSuffix = "-" + namespace;
                routeSpec.setHost(host + namespaceSuffix + "." + Strings.stripPrefix((String)routeDomainPostfix, (String)"."));
            }
            route.setSpec(routeSpec);
            String json = null;
            try {
                json = KubernetesHelper.toJson((Object)route);
            }
            catch (JsonProcessingException e) {
                json = e.getMessage() + ". object: " + route;
            }
        }
        return route;
    }

    protected static boolean shouldCreateRouteForService(Logger log, Service service, String id) {
        if ("kubernetes".equals(id) || "kubernetes-ro".equals(id)) {
            return false;
        }
        Set ports = KubernetesHelper.getPorts((Service)service);
        if (ports.size() == 1) {
            return true;
        }
        log.info("Not generating route for service " + id + " as only single port services are supported. Has ports: " + ports);
        return false;
    }
}

