/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.utils.Util;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.DoneableConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMaps {
    public static final String FABRIC8_ARQUILLIAN = "fabric8-arquillian";
    private static final transient Logger LOG = LoggerFactory.getLogger(ConfigMaps.class);

    public static synchronized ConfigMap updateConfigMapStatus(KubernetesClient client, Session session, String status) {
        try {
            ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(FABRIC8_ARQUILLIAN)).addToAnnotations(ConfigMaps.createConfigMapAnnotations(session, status))).endMetadata()).build();
            return (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(session.getNamespace())).withName(FABRIC8_ARQUILLIAN)).createOrReplace((Object[])new ConfigMap[]{configMap});
        }
        catch (Exception e) {
            LOG.warn("failed to update ConfigMap fabric8-arquillian. " + e, (Throwable)e);
            return null;
        }
    }

    public static synchronized ConfigMap updateConfigMapTestStatus(KubernetesClient client, Session session, String test, String status) {
        try {
            return ((DoneableConfigMap)((DoneableConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(session.getNamespace())).withName(FABRIC8_ARQUILLIAN)).edit()).addToData(test, status)).done();
        }
        catch (Exception e) {
            LOG.warn("failed to update ConfigMap fabric8-arquillian. " + e, (Throwable)e);
            return null;
        }
    }

    private static Map<String, String> createConfigMapAnnotations(Session session, String status) {
        File pomProperties;
        HashMap<String, String> annotations = new HashMap<String, String>();
        File dir = Util.getProjectBaseDir(session);
        String gitUrl = Util.findGitUrl(session, dir);
        annotations.put("fabric8.io/test-session-id", session.getId());
        annotations.put("fabric8.io/test-session-status", status);
        if (Strings.isNotBlank((String)gitUrl)) {
            annotations.put("fabric8.io/git-url", gitUrl);
        }
        if ((pomProperties = new File(dir, "target/maven-archiver/pom.properties")).isFile()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(pomProperties));
                Map map = PropertiesHelper.toMap((Properties)properties);
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (!Strings.isNotBlank((String)key) || !Strings.isNotBlank((String)value)) continue;
                    annotations.put("fabric8.io/project-" + key, value);
                }
            }
            catch (IOException e) {
                session.getLogger().warn("Failed to load " + pomProperties + " file to annotate the namespace: " + e);
            }
        }
        return annotations;
    }
}

