/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecBuilder;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.PodTemplateHandler;
import io.fabric8.maven.docker.config.ImageConfiguration;
import java.util.List;

public class DeploymentHandler {
    private final PodTemplateHandler podTemplateHandler;

    DeploymentHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public Deployment getDeployment(ResourceConfig config, List<ImageConfiguration> images) {
        Deployment deployment = ((DeploymentBuilder)((DeploymentBuilder)new DeploymentBuilder().withMetadata(this.createDeploymentMetaData(config))).withSpec(this.createDeploymentSpec(config, images))).build();
        return deployment;
    }

    private ObjectMeta createDeploymentMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"controller name"))).build();
    }

    private DeploymentSpec createDeploymentSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((DeploymentSpecBuilder)((DeploymentSpecBuilder)new DeploymentSpecBuilder().withReplicas(Integer.valueOf(config.getReplicas()))).withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

