/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContextBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.config.VolumeConfig;
import io.fabric8.maven.core.handler.EnvVarHandler;
import io.fabric8.maven.core.handler.ProbeHandler;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.docker.access.PortMapping;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.project.MavenProject;
import org.json.JSONArray;
import org.json.JSONObject;

class ContainerHandler {
    private final EnvVarHandler envVarHandler;
    private final ProbeHandler probeHandler;
    private final MavenProject project;

    public ContainerHandler(MavenProject project, EnvVarHandler envVarHandler, ProbeHandler probeHandler) {
        this.envVarHandler = envVarHandler;
        this.probeHandler = probeHandler;
        this.project = project;
    }

    List<Container> getContainers(ResourceConfig config, List<ImageConfiguration> images) {
        ArrayList<Container> ret = new ArrayList<Container>();
        for (ImageConfiguration imageConfig : images) {
            if (imageConfig.getBuildConfiguration() == null) continue;
            Probe livenessProbe = this.probeHandler.getProbe(config.getLiveness());
            Probe readinessProbe = this.probeHandler.getProbe(config.getReadiness());
            Container container = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(KubernetesResourceUtil.extractContainerName(this.project, imageConfig))).withImage(this.getImageName(imageConfig))).withImagePullPolicy(this.getImagePullPolicy(config))).withEnv(this.envVarHandler.getEnvironmentVariables(config.getEnv()))).withSecurityContext(this.createSecurityContext(config))).withPorts(this.getContainerPorts(imageConfig))).withVolumeMounts(this.getVolumeMounts(config))).withLivenessProbe(livenessProbe)).withReadinessProbe(readinessProbe)).build();
            ret.add(container);
        }
        return ret;
    }

    private String getImagePullPolicy(ResourceConfig config) {
        String pullPolicy = config.getImagePullPolicy();
        String version = this.project.getVersion();
        if (Strings.isNullOrBlank((String)pullPolicy) && version != null && version.endsWith("SNAPSHOT")) {
            return "PullAlways";
        }
        return pullPolicy;
    }

    private String getImageName(ImageConfiguration imageConfiguration) {
        if (Strings.isNullOrBlank((String)imageConfiguration.getName())) {
            return null;
        }
        String configuredRegistry = EnvUtil.findRegistry((String[])new String[]{imageConfiguration.getRegistry(), this.project.getProperties().getProperty("docker.pull.registry"), this.project.getProperties().getProperty("docker.registry")});
        String name = imageConfiguration.getName();
        ImageName imageName = new ImageName(name);
        Matcher matcher = Pattern.compile("^(.+?)(?::([^:/]+))?$").matcher(name);
        boolean hasTag = matcher.matches() && matcher.group(2) != null;
        return hasTag ? imageName.getFullName(configuredRegistry) : imageName.getNameWithoutTag(configuredRegistry);
    }

    private SecurityContext createSecurityContext(ResourceConfig config) {
        return ((SecurityContextBuilder)new SecurityContextBuilder().withPrivileged(Boolean.valueOf(config.isContainerPrivileged()))).build();
    }

    private List<VolumeMount> getVolumeMounts(ResourceConfig config) {
        List<VolumeConfig> volumeConfigs = config.getVolumes();
        ArrayList<VolumeMount> ret = new ArrayList<VolumeMount>();
        if (volumeConfigs != null) {
            for (VolumeConfig volumeConfig : volumeConfigs) {
                List<String> mounts = volumeConfig.getMounts();
                if (mounts == null) continue;
                for (String mount : mounts) {
                    ret.add(((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(volumeConfig.getName())).withMountPath(mount)).withReadOnly(Boolean.valueOf(false))).build());
                }
            }
        }
        return ret;
    }

    private List<ContainerPort> getContainerPorts(ImageConfiguration imageConfig) {
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        List ports = buildConfig.getPorts();
        if (!ports.isEmpty()) {
            ArrayList<ContainerPort> ret = new ArrayList<ContainerPort>();
            PortMapping portMapping = new PortMapping(ports, this.project.getProperties());
            JSONArray portSpecs = portMapping.toJson();
            for (int i = 0; i < portSpecs.length(); ++i) {
                JSONObject portSpec = portSpecs.getJSONObject(i);
                ret.add(this.extractContainerPort(portSpec));
            }
            return ret;
        }
        return null;
    }

    private ContainerPort extractContainerPort(JSONObject portSpec) {
        ContainerPortBuilder portBuilder = (ContainerPortBuilder)new ContainerPortBuilder().withContainerPort(Integer.valueOf(portSpec.getInt("containerPort")));
        if (portSpec.has("hostPort")) {
            portBuilder.withHostPort(Integer.valueOf(portSpec.getInt("hostPort")));
        }
        if (portSpec.has("protocol")) {
            portBuilder.withProtocol(portSpec.getString("protocol").toUpperCase());
        }
        if (portSpec.has("hostIP")) {
            portBuilder.withHostIP(portSpec.getString("hostIP"));
        }
        return portBuilder.build();
    }
}

