/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.maven.core.extenvvar.ExternalEnvVarHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;

class EnvVarHandler {
    private MavenProject project;

    EnvVarHandler(MavenProject project) {
        this.project = project;
    }

    List<EnvVar> getEnvironmentVariables(Map<String, String> envVars) {
        ArrayList<EnvVar> ret = new ArrayList<EnvVar>();
        Map<String, String> envs = ExternalEnvVarHandler.getExportedEnvironmentVariables(this.project, envVars);
        Map<String, EnvVar> envMap = this.convertToEnvVarMap(envs);
        ret.addAll(envMap.values());
        ret.add(((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.FieldRefNested)((EnvVarBuilder)new EnvVarBuilder().withName("KUBERNETES_NAMESPACE")).withNewValueFrom().withNewFieldRef().withFieldPath("metadata.namespace")).endFieldRef()).endValueFrom()).build());
        return ret;
    }

    private Map<String, EnvVar> convertToEnvVarMap(Map<String, String> envs) {
        HashMap<String, EnvVar> envMap = new HashMap<String, EnvVar>();
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (name == null) continue;
            EnvVar env = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(name)).withValue(value)).build();
            envMap.put(name, env);
        }
        return envMap;
    }
}

