/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.utils.Strings;
import java.util.HashMap;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.json.JSONObject;

public class DockerServerUtil {
    public static Server getServer(Settings settings, String serverId) {
        if (settings == null || Strings.isNullOrBlank((String)serverId)) {
            return null;
        }
        return settings.getServer(serverId);
    }

    public static String getDockerJsonConfigString(Settings settings, String serverId) {
        Server server = DockerServerUtil.getServer(settings, serverId);
        if (server == null) {
            return new String();
        }
        HashMap<String, String> auth = new HashMap<String, String>();
        auth.put("username", server.getUsername());
        auth.put("password", server.getPassword());
        String mail = DockerServerUtil.getConfigurationValue(server, "email");
        if (Strings.isNullOrBlank((String)mail)) {
            mail = "foo@foo.com";
        }
        auth.put("email", mail);
        JSONObject json = new JSONObject().put(serverId, auth);
        return json.toString();
    }

    private static String getConfigurationValue(Server server, String key) {
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        if (configuration == null) {
            return null;
        }
        Xpp3Dom node = configuration.getChild(key);
        if (node == null) {
            return null;
        }
        return node.getValue();
    }
}

