/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.maven.core.util.ProcessUtil;
import io.fabric8.maven.docker.access.DockerConnectionDetector;
import io.fabric8.maven.docker.access.util.EnvCommand;
import io.fabric8.maven.docker.util.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Gofabric8Util {
    public static List<DockerConnectionDetector.DockerHostProvider> extractDockerHostProvider(Logger log) {
        if (Gofabric8Util.findGofabric8(log) != null) {
            return Collections.singletonList(new Gofabric8DockerHostProvider(log));
        }
        return null;
    }

    public static File findGofabric8(Logger log) {
        return ProcessUtil.findExecutable(log, "gofabric8");
    }

    private static class Gofabric8EnvCommand
    extends EnvCommand {
        public Gofabric8EnvCommand(Logger log) {
            super(log, "export ");
        }

        protected String[] getArgs() {
            return new String[]{"gofabric8", "docker-env"};
        }
    }

    private static class Gofabric8DockerHostProvider
    implements DockerConnectionDetector.DockerHostProvider {
        private final Gofabric8EnvCommand command;
        private final Logger log;
        private Map<String, String> envMap;

        public Gofabric8DockerHostProvider(Logger log) {
            this.command = new Gofabric8EnvCommand(log);
            this.log = log;
        }

        public synchronized DockerConnectionDetector.ConnectionParameter getConnectionParameter(String certPath) throws IOException {
            String dockerHost;
            if (this.envMap == null) {
                this.envMap = this.command.getEnvironment();
            }
            if ((dockerHost = this.envMap.get("DOCKER_HOST")) == null) {
                return null;
            }
            this.log.info("DOCKER_HOST from gofabric8 : %s", new Object[]{dockerHost});
            return new DockerConnectionDetector.ConnectionParameter(dockerHost, certPath != null ? certPath : this.envMap.get("DOCKER_CERT_PATH"));
        }

        public int getPriority() {
            return -1;
        }
    }
}

