/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.maven.core.util.MavenUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class SpringBootUtil {
    private static final transient Logger LOG = LoggerFactory.getLogger(SpringBootUtil.class);

    public static Properties getSpringBootApplicationProperties(MavenProject project) {
        URLClassLoader compileClassLoader = MavenUtil.getCompileClassLoader(project);
        URL ymlResource = compileClassLoader.findResource("application.yml");
        URL propertiesResource = compileClassLoader.findResource("application.properties");
        Properties props = SpringBootUtil.getPropertiesFromYamlResource(ymlResource);
        props.putAll((Map<?, ?>)SpringBootUtil.getPropertiesResource(propertiesResource));
        return props;
    }

    public static Properties getPropertiesFile(MavenProject project, String propertiesFileName) {
        URLClassLoader compileClassLoader = MavenUtil.getCompileClassLoader(project);
        URL resource = compileClassLoader.findResource(propertiesFileName);
        return SpringBootUtil.getPropertiesResource(resource);
    }

    protected static Properties getPropertiesResource(URL resource) {
        Properties answer = new Properties();
        if (resource != null) {
            try (InputStream stream = resource.openStream();){
                answer.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading resource from URL " + resource, e);
            }
        }
        return answer;
    }

    public static Properties getPropertiesFromYamlFile(MavenProject project, String yamlFileName) {
        URLClassLoader compileClassLoader = MavenUtil.getCompileClassLoader(project);
        URL resource = compileClassLoader.findResource(yamlFileName);
        return SpringBootUtil.getPropertiesFromYamlResource(resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Properties getPropertiesFromYamlResource(URL resource) {
        if (resource == null) return new Properties();
        try (InputStream yamlStream = resource.openStream();){
            Yaml yaml = new Yaml();
            SortedMap source = (SortedMap)yaml.loadAs(yamlStream, SortedMap.class);
            Properties properties = new Properties();
            if (source != null) {
                properties.putAll(SpringBootUtil.getFlattenedMap(source));
            }
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while reading Yaml resource from URL " + resource, e);
        }
    }

    public static String getSpringBootDevToolsVersion(MavenProject mavenProject) {
        return SpringBootUtil.getSpringBootVersion(mavenProject);
    }

    public static String getSpringBootVersion(MavenProject mavenProject) {
        return MavenUtil.getDependencyVersion(mavenProject, "org.springframework.boot", "spring-boot");
    }

    private static Map<String, Object> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        SpringBootUtil.buildFlattenedMap(result, source, null);
        return result;
    }

    private static void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (path != null && path.trim().length() > 0) {
                key = key.startsWith("[") ? path + key : path + "." + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                SpringBootUtil.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    SpringBootUtil.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value != null ? value : "");
        }
    }
}

