/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.maven.enricher.api.AbstractLiveEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Site;
import org.apache.maven.project.MavenProject;

public class DocLinkEnricher
extends AbstractLiveEnricher {
    public DocLinkEnricher(EnricherContext buildContext) {
        super(buildContext, "f8-cd-doc-link");
    }

    public Map<String, String> getAnnotations(Kind kind) {
        if (kind.isDeployOrReplicaKind()) {
            String url = this.findDocumentationUrl();
            return url != null ? Collections.singletonMap("fabric8.io/docs-url", url) : null;
        }
        return null;
    }

    protected String findDocumentationUrl() {
        String url;
        Site site;
        DistributionManagement distributionManagement = this.findProjectDistributionManagement();
        if (distributionManagement != null && (site = distributionManagement.getSite()) != null && Strings.isNotBlank((String)(url = site.getUrl()))) {
            MavenProject project = this.getProject();
            if (project != null) {
                url = DocLinkEnricher.replaceProperties(url, project.getProperties());
            }
            try {
                String publicUrl;
                int idx2;
                String urlToParse = url;
                int idx = url.indexOf("://");
                if (idx > 0 && (idx2 = url.substring(0, idx).lastIndexOf(58)) >= 0 && idx2 < idx) {
                    urlToParse = url.substring(idx2 + 1);
                }
                URL u = new URL(urlToParse);
                String serviceName = u.getHost();
                String protocol = u.getProtocol();
                if (this.isOnline() && Strings.isNotBlank((String)(publicUrl = this.getExternalServiceURL(serviceName, protocol)))) {
                    return URLUtils.pathJoin((String[])new String[]{publicUrl, u.getPath()});
                }
            }
            catch (MalformedURLException e) {
                this.getLog().error("Failed to parse URL: %s. %s", new Object[]{url, e});
            }
            return url;
        }
        return null;
    }

    protected DistributionManagement findProjectDistributionManagement() {
        for (MavenProject project = this.getProject(); project != null; project = project.getParent()) {
            DistributionManagement distributionManagement = project.getDistributionManagement();
            if (distributionManagement == null) continue;
            return distributionManagement;
        }
        return null;
    }

    protected static String replaceProperties(String text, Properties properties) {
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            String pattern = "${" + key + "}";
            text = Strings.replaceAllWithoutRegex((String)text, (String)pattern, (String)value.toString());
        }
        return text;
    }
}

