/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public class GrafanaLinkEnricher
extends BaseEnricher {
    public GrafanaLinkEnricher(EnricherContext buildContext) {
        super(buildContext, "f8-cd-grafana-link");
    }

    public Map<String, String> getAnnotations(Kind kind) {
        if (kind.isDeployOrReplicaKind()) {
            String url = this.findGrafanaLink();
            return url != null ? Collections.singletonMap("fabric8.io/metrics-path", url) : null;
        }
        return null;
    }

    private String findGrafanaLink() {
        MavenProject project = this.getProject();
        String defaultDashboard = this.detectDefaultDashboard(project);
        String query = "";
        String projectName = null;
        String version = null;
        if (Strings.isNullOrBlank(projectName)) {
            projectName = project.getArtifactId();
        }
        if (Strings.isNullOrBlank(version)) {
            version = project.getVersion();
        }
        if (Strings.isNotBlank((String)projectName)) {
            query = query + "&var-project=" + projectName;
        }
        if (Strings.isNotBlank((String)version)) {
            query = query + "&var-version=" + version;
        }
        if (query.startsWith("&")) {
            query = "?" + query.substring(1);
        }
        return URLUtils.pathJoin((String[])new String[]{"dashboard/file", defaultDashboard, query});
    }

    protected String detectDefaultDashboard(MavenProject project) {
        String dashboard = this.getConfig(Config.metricsDashboard);
        if (Strings.isNotBlank((String)dashboard)) {
            return dashboard;
        }
        if (MavenUtil.hasClass((MavenProject)project, (String[])new String[]{"org.apache.camel.CamelContext"})) {
            return "camel-routes.json";
        }
        return "kubernetes-pods.json";
    }

    private static enum Config implements Configs.Key
    {
        metricsDashboard;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

