/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.AbstractHealthCheckEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import org.apache.maven.project.MavenProject;

public class VertxHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    private static final String VERTX_MAVEN_PLUGIN_GA = "io.fabric8:vertx-maven-plugin";
    private static final String VERTX_GROUPID = "io.vertx";
    private static final int DEFAULT_MANAGEMENT_PORT = 8080;
    private static final String SCHEME_HTTP = "HTTP";
    private static final int READINESS_INITIAL_DELAY = 10;
    private static final int LIVENESS_INITIAL_DELAY = 180;
    public static final String VERTX_HEALTH_SCHEME = "vertx.health.scheme";
    public static final String VERTX_HEALTH_PATH = "vertx.health.path";
    public static final String VERTX_READINESS_HEALTH_PATH = "vertx.health.readiness.path";
    public static final String VERTX_HEALTH_PORT = "vertx.health.port";

    public VertxHealthCheckEnricher(EnricherContext buildContext) {
        super(buildContext, "vertx-health-check");
    }

    protected Probe getReadinessProbe() {
        return this.discoverVertxHealthCheck(10, true);
    }

    protected Probe getLivenessProbe() {
        return this.discoverVertxHealthCheck(180, false);
    }

    private boolean isApplicable() {
        return MavenUtil.hasPlugin((MavenProject)this.getProject(), (String)VERTX_MAVEN_PLUGIN_GA) || MavenUtil.hasDependency((MavenProject)this.getProject(), (String)VERTX_GROUPID);
    }

    private Probe discoverVertxHealthCheck(int initialDelay, boolean readiness) {
        if (!this.isApplicable()) {
            return null;
        }
        int port = this.getPort();
        String path = null;
        if (readiness && (path = this.getReadinessPath()) != null && path.isEmpty()) {
            return null;
        }
        if (path == null) {
            path = this.getPath();
        }
        if (port <= 0 || path == null || path.isEmpty()) {
            return null;
        }
        String scheme = this.getScheme();
        return ((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withScheme(scheme)).withNewPort(Integer.valueOf(port))).withPath(path)).endHttpGet()).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
    }

    private String getScheme() {
        String scheme = this.getContext().getProject().getProperties().getProperty(VERTX_HEALTH_SCHEME);
        if (scheme != null && !scheme.trim().isEmpty()) {
            return scheme.trim();
        }
        return Configs.asString((String)this.getConfig(Config.scheme));
    }

    private int getPort() {
        String portAsString = this.getContext().getProject().getProperties().getProperty(VERTX_HEALTH_PORT);
        if (portAsString != null && !portAsString.trim().isEmpty()) {
            try {
                int port = Integer.valueOf(portAsString.trim());
                if (port <= 0) {
                    return -1;
                }
                return port;
            }
            catch (NumberFormatException e) {
                this.log.warn("Invalid value for `vertx.health.port` - integer expected, disabling health checks", new Object[0]);
                return -1;
            }
        }
        return Configs.asInt((String)this.getConfig(Config.port));
    }

    private String processPath(String path) {
        if (path != null) {
            if ((path = path.trim()).isEmpty()) {
                return "";
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return path;
        }
        return null;
    }

    private String getPath() {
        String path = this.getContext().getProject().getProperties().getProperty(VERTX_HEALTH_PATH);
        if ((path = this.processPath(path)) != null) {
            return path;
        }
        path = Configs.asString((String)this.getConfig(Config.path));
        return this.processPath(path);
    }

    private String getReadinessPath() {
        String path = this.getContext().getProject().getProperties().getProperty(VERTX_READINESS_HEALTH_PATH);
        if ((path = this.processPath(path)) != null) {
            return path;
        }
        path = Configs.asString((String)this.getConfig(Config.readiness));
        return this.processPath(path);
    }

    protected static enum Config implements Configs.Key
    {
        scheme{
            {
                this.d = VertxHealthCheckEnricher.SCHEME_HTTP;
            }
        }
        ,
        port{
            {
                this.d = Integer.toString(8080);
            }
        }
        ,
        path{
            {
                this.d = null;
            }
        }
        ,
        readiness{
            {
                this.d = null;
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

