/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.utils.Base64Encoder;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;

public class IconEnricher
extends BaseEnricher {
    private static String[] ICON_EXTENSIONS = new String[]{".svg", ".png", ".gif", ".jpg", ".jpeg"};
    private File templateTempDir;
    private File appConfigDir;
    private String iconBranch;

    public IconEnricher(EnricherContext buildContext) {
        super(buildContext, "f8-icon");
        String baseDir = this.getProject().getBasedir().getAbsolutePath();
        this.templateTempDir = new File(this.getConfig(Config.templateTempDir, baseDir + "/target/fabric8/template-workdir"));
        this.appConfigDir = new File(this.getConfig(Config.sourceDir, baseDir + "/src/main/fabric8"));
    }

    public Map<String, String> getAnnotations(Kind kind) {
        if (kind.isController() || kind == Kind.SERVICE) {
            String iconUrl = this.getIconUrl(this.extractIconRef());
            if (iconUrl != null) {
                this.log.info("Adding icon for %s", new Object[]{kind.toString().toLowerCase()});
                this.log.verbose("Icon URL: %s", new Object[]{iconUrl});
                return Collections.singletonMap("fabric8.io/iconUrl", iconUrl);
            }
            this.log.debug("No icon file found for resources of type " + kind, new Object[0]);
        }
        return null;
    }

    private String extractIconRef() {
        String iconRef = this.getConfig(Config.ref);
        if (Strings.isNullOrBlank((String)iconRef)) {
            iconRef = this.getDefaultIconRef();
        }
        return iconRef;
    }

    protected String getIconUrl(String iconRef) {
        String answer = this.getConfig(Config.url);
        if (Strings.isNullOrBlank((String)answer)) {
            try {
                if (this.templateTempDir != null) {
                    this.templateTempDir.mkdirs();
                    File iconFile = this.copyIconToFolder(iconRef, this.templateTempDir);
                    if (iconFile == null) {
                        this.copyAppConfigFiles(this.templateTempDir, this.appConfigDir);
                        for (String ext : ICON_EXTENSIONS) {
                            File file = new File(this.templateTempDir, "icon" + ext);
                            if (!file.exists() || !file.isFile()) continue;
                            iconFile = file;
                            break;
                        }
                    }
                    if (iconFile != null) {
                        answer = this.convertIconFileToURL(iconFile, iconRef);
                    }
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to load icon file: %s", new Object[]{e});
            }
        }
        if (Strings.isNullOrBlank((String)answer) && Strings.isNotBlank((String)iconRef)) {
            String embeddedIcon = this.embeddedIconsInConsole(iconRef, "img/icons/");
            if (embeddedIcon != null) {
                return embeddedIcon;
            }
            this.log.warn("Could not resolve iconRef: %s", new Object[]{iconRef});
        }
        return answer;
    }

    private String getDefaultIconRef() {
        MavenProject project = this.getProject();
        EnricherContext context = this.getContext();
        if (MavenUtil.hasClass((MavenProject)project, (String[])new String[]{"io.fabric8.funktion.runtime.Main"}) || MavenUtil.hasDependencyOnAnyArtifactOfGroup((MavenProject)project, (String)"io.fabric8.funktion")) {
            return "funktion";
        }
        if (MavenUtil.hasClass((MavenProject)project, (String[])new String[]{"org.apache.camel.CamelContext"})) {
            return "camel";
        }
        if (MavenUtil.hasPlugin((MavenProject)project, (String)"org.springframework.boot:spring-boot-maven-plugin") || MavenUtil.hasClass((MavenProject)project, (String[])new String[]{"org.springframework.boot.SpringApplication"})) {
            return "spring-boot";
        }
        if (MavenUtil.hasClass((MavenProject)project, (String[])new String[]{"org.springframework.core.Constants"})) {
            return "spring";
        }
        if (MavenUtil.hasClass((MavenProject)project, (String[])new String[]{"org.vertx.java.core.Handler", "io.vertx.core.Handler"})) {
            return "vertx";
        }
        if (MavenUtil.hasPlugin((MavenProject)project, (String)"org.wildfly.swarm:wildfly-swarm-plugin") || MavenUtil.hasDependencyOnAnyArtifactOfGroup((MavenProject)project, (String)"org.wildfly.swarm")) {
            return "wildfly-swarm";
        }
        return null;
    }

    private File copyIconToFolder(String iconRef, File appBuildDir) throws IOException {
        File[] icons;
        if (Strings.isNotBlank((String)iconRef) && ((icons = appBuildDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name == null) {
                    return false;
                }
                String lower = name.toLowerCase();
                if (lower.startsWith("icon.")) {
                    for (String ext : ICON_EXTENSIONS) {
                        if (!lower.endsWith(ext)) continue;
                        return true;
                    }
                }
                return false;
            }
        })) == null || icons.length == 0)) {
            InputStream in = this.loadPluginResource(iconRef);
            if (in == null) {
                for (String ext : ICON_EXTENSIONS) {
                    String name = iconRef + ext;
                    in = this.loadPluginResource(name);
                    if (in == null) continue;
                    iconRef = name;
                    break;
                }
            }
            if (in != null) {
                String fileName = "icon." + Files.getFileExtension((String)iconRef);
                File outFile = new File(appBuildDir, fileName);
                Files.copy((InputStream)in, (OutputStream)new FileOutputStream(outFile));
                this.log.info("Generated icon file " + outFile + " from icon reference: " + iconRef, new Object[0]);
                return outFile;
            }
        }
        return null;
    }

    private InputStream loadPluginResource(String iconRef) {
        InputStream answer = Thread.currentThread().getContextClassLoader().getResourceAsStream(iconRef);
        if (answer == null) {
            answer = MavenUtil.getTestClassLoader((MavenProject)this.getProject()).getResourceAsStream(iconRef);
        }
        if (answer == null) {
            answer = ((Object)((Object)this)).getClass().getResourceAsStream(iconRef);
        }
        return answer;
    }

    private void copyAppConfigFiles(File appBuildDir, File appConfigDir) throws IOException {
        File[] files = appConfigDir.listFiles();
        if (files != null) {
            appBuildDir.mkdirs();
            for (File file : files) {
                File outFile = new File(appBuildDir, file.getName());
                if (file.isDirectory()) {
                    this.copyAppConfigFiles(outFile, file);
                    continue;
                }
                Files.copy((File)file, (File)outFile);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertIconFileToURL(File iconFile, String iconRef) throws IOException {
        long length = iconFile.length();
        int sizeK = Math.round(length / 1024L);
        byte[] bytes = Files.readBytes((File)iconFile);
        byte[] encoded = Base64Encoder.encode((byte[])bytes);
        int base64SizeK = Math.round(encoded.length / 1024);
        if (base64SizeK < Configs.asInt((String)this.getConfig(Config.maximumDataUrlSizeK))) {
            String mimeType = Files.guessMediaType((File)iconFile);
            return "data:" + mimeType + ";charset=UTF-8;base64," + new String(encoded);
        }
        File iconSourceFile = new File(this.appConfigDir, iconFile.getName());
        if (iconSourceFile.exists()) {
            String url;
            Scm scm;
            File rootProjectFolder = this.getRootProjectFolder();
            if (rootProjectFolder == null) return null;
            String relativePath = Files.getRelativePath((File)rootProjectFolder, (File)iconSourceFile);
            String relativeParentPath = Files.getRelativePath((File)rootProjectFolder, (File)this.getProject().getBasedir());
            String urlPrefix = this.getConfig(Config.urlPrefix);
            if (Strings.isNullOrBlank((String)urlPrefix) && (scm = this.getProject().getScm()) != null && (url = scm.getUrl()) != null) {
                String[] prefixes;
                for (String prefix : prefixes = new String[]{"http://github.com/", "https://github.com/"}) {
                    if (!url.startsWith(prefix)) continue;
                    url = URLUtils.pathJoin((String[])new String[]{"https://cdn.rawgit.com/", url.substring(prefix.length())});
                    break;
                }
                if (url.endsWith(relativeParentPath)) {
                    url = url.substring(0, url.length() - relativeParentPath.length());
                }
                urlPrefix = url;
            }
            if (!Strings.isNullOrBlank((String)urlPrefix)) return URLUtils.pathJoin((String[])new String[]{urlPrefix, this.getConfig(Config.branch), relativePath});
            this.log.warn("No iconUrlPrefix defined or could be found via SCM in the pom.xml so cannot add an icon URL!", new Object[0]);
            return null;
        } else {
            String embeddedIcon = this.embeddedIconsInConsole(iconRef, "img/icons/");
            if (embeddedIcon != null) {
                return embeddedIcon;
            }
            this.log.warn("Cannot find url for icon to use %s", new Object[]{iconRef});
        }
        return null;
    }

    protected File getRootProjectFolder() {
        File answer = null;
        for (MavenProject project = this.getProject(); project != null; project = project.getParent()) {
            File basedir = project.getBasedir();
            if (basedir == null) continue;
            answer = basedir;
        }
        return answer;
    }

    protected String embeddedIconsInConsole(String iconRef, String prefix) {
        if (iconRef == null) {
            return null;
        }
        if (iconRef.startsWith("icons/")) {
            iconRef = iconRef.substring(6);
        }
        if (iconRef.contains("fabric8")) {
            return "img/fabric8_icon.svg";
        }
        if (iconRef.contains("activemq")) {
            return prefix + "activemq.svg";
        }
        if (iconRef.contains("apiman")) {
            return prefix + "apiman.png";
        }
        if (iconRef.contains("api-registry")) {
            return prefix + "api-registry.svg";
        }
        if (iconRef.contains("brackets")) {
            return prefix + "brackets.svg";
        }
        if (iconRef.contains("camel")) {
            return prefix + "camel.svg";
        }
        if (iconRef.contains("chaos-monkey")) {
            return prefix + "chaos-monkey.png";
        }
        if (iconRef.contains("docker-registry")) {
            return prefix + "docker-registry.png";
        }
        if (iconRef.contains("elasticsearch")) {
            return prefix + "elasticsearch.png";
        }
        if (iconRef.contains("fluentd")) {
            return prefix + "fluentd.png";
        }
        if (iconRef.contains("forge")) {
            return prefix + "forge.svg";
        }
        if (iconRef.contains("funktion")) {
            return prefix + "funktion.png";
        }
        if (iconRef.contains("gerrit")) {
            return prefix + "gerrit.png";
        }
        if (iconRef.contains("gitlab")) {
            return prefix + "gitlab.svg";
        }
        if (iconRef.contains("gogs")) {
            return prefix + "gogs.png";
        }
        if (iconRef.contains("grafana")) {
            return prefix + "grafana.png";
        }
        if (iconRef.contains("hubot-irc")) {
            return prefix + "hubot-irc.png";
        }
        if (iconRef.contains("hubot-letschat")) {
            return prefix + "hubot-letschat.png";
        }
        if (iconRef.contains("hubot-notifier")) {
            return prefix + "hubot-notifier.png";
        }
        if (iconRef.contains("hubot-slack")) {
            return prefix + "hubot-slack.png";
        }
        if (iconRef.contains("image-linker")) {
            return prefix + "image-linker.svg";
        }
        if (iconRef.contains("javascript")) {
            return prefix + "javascript.png";
        }
        if (iconRef.contains("java")) {
            return prefix + "java.svg";
        }
        if (iconRef.contains("jenkins")) {
            return prefix + "jenkins.svg";
        }
        if (iconRef.contains("jetty")) {
            return prefix + "jetty.svg";
        }
        if (iconRef.contains("karaf")) {
            return prefix + "karaf.svg";
        }
        if (iconRef.contains("keycloak")) {
            return prefix + "keycloak.svg";
        }
        if (iconRef.contains("kibana")) {
            return prefix + "kibana.svg";
        }
        if (iconRef.contains("kiwiirc")) {
            return prefix + "kiwiirc.png";
        }
        if (iconRef.contains("letschat")) {
            return prefix + "letschat.png";
        }
        if (iconRef.contains("mule")) {
            return prefix + "mule.svg";
        }
        if (iconRef.contains("nexus")) {
            return prefix + "nexus.png";
        }
        if (iconRef.contains("node")) {
            return prefix + "node.svg";
        }
        if (iconRef.contains("orion")) {
            return prefix + "orion.png";
        }
        if (iconRef.contains("prometheus")) {
            return prefix + "prometheus.png";
        }
        if (iconRef.contains("django") || iconRef.contains("python")) {
            return prefix + "python.png";
        }
        if (iconRef.contains("spring-boot")) {
            return prefix + "spring-boot.svg";
        }
        if (iconRef.contains("taiga")) {
            return prefix + "taiga.png";
        }
        if (iconRef.contains("tomcat")) {
            return prefix + "tomcat.svg";
        }
        if (iconRef.contains("tomee")) {
            return prefix + "tomee.svg";
        }
        if (iconRef.contains("vertx")) {
            return prefix + "vertx.svg";
        }
        if (iconRef.contains("wildfly")) {
            return prefix + "wildfly.svg";
        }
        if (iconRef.contains("wildfly-swarm")) {
            return prefix + "wildfly-swarm.png";
        }
        if (iconRef.contains("weld")) {
            return prefix + "weld.svg";
        }
        if (iconRef.contains("zipkin")) {
            return prefix + "zipkin.png";
        }
        return null;
    }

    private static enum Config implements Configs.Key
    {
        templateTempDir,
        sourceDir,
        ref,
        maximumDataUrlSizeK{
            {
                this.d = "2";
            }
        }
        ,
        urlPrefix,
        branch{
            {
                this.d = "master";
            }
        }
        ,
        url;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

