/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.AbstractHealthCheckEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import org.apache.maven.project.MavenProject;

public class WildFlySwarmHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public WildFlySwarmHealthCheckEnricher(EnricherContext buildContext) {
        super(buildContext, "wildfly-swarm-health-check");
    }

    protected Probe getReadinessProbe() {
        Probe probe = this.discoverWildFlySwarmHealthCheck(10);
        return probe;
    }

    protected Probe getLivenessProbe() {
        Probe probe = this.discoverWildFlySwarmHealthCheck(180);
        return probe;
    }

    private Probe discoverWildFlySwarmHealthCheck(int initialDelay) {
        if (MavenUtil.hasDependency((MavenProject)this.getProject(), (String)"org.wildfly.swarm", (String)"monitor")) {
            Integer port = this.getPort();
            String scheme = this.getScheme().toUpperCase();
            String path = this.getPath();
            return ((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(port)).withPath(path)).withScheme(scheme)).endHttpGet()).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
        }
        return null;
    }

    protected String getScheme() {
        return Configs.asString((String)this.getConfig(Config.scheme));
    }

    protected int getPort() {
        return Configs.asInt((String)this.getConfig(Config.port));
    }

    protected String getPath() {
        return Configs.asString((String)this.getConfig(Config.path));
    }

    private static enum Config implements Configs.Key
    {
        scheme{
            {
                this.d = "HTTP";
            }
        }
        ,
        port{
            {
                this.d = "8080";
            }
        }
        ,
        path{
            {
                this.d = "/health";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

