/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.SpringBootConfigurationHelper;
import io.fabric8.maven.core.util.SpringBootUtil;
import io.fabric8.maven.enricher.api.AbstractHealthCheckEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import java.util.Properties;
import org.apache.maven.project.MavenProject;

public class SpringBootHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public static final String ENRICHER_NAME = "spring-boot-health-check";
    private static final String[] REQUIRED_CLASSES = new String[]{"org.springframework.boot.actuate.health.HealthIndicator", "org.springframework.web.context.support.GenericWebApplicationContext"};
    private static final int DEFAULT_SERVER_PORT = 8080;
    private static final String SCHEME_HTTPS = "HTTPS";
    private static final String SCHEME_HTTP = "HTTP";

    public SpringBootHealthCheckEnricher(EnricherContext buildContext) {
        super(buildContext, ENRICHER_NAME);
    }

    protected Probe getReadinessProbe() {
        Integer initialDelay = Configs.asInteger((String)this.getConfig(Config.readinessProbeInitialDelaySeconds));
        Integer period = Configs.asInteger((String)this.getConfig(Config.readinessProbePeriodSeconds));
        return this.discoverSpringBootHealthCheck(initialDelay, period);
    }

    protected Probe getLivenessProbe() {
        Integer initialDelay = Configs.asInteger((String)this.getConfig(Config.livenessProbeInitialDelaySeconds));
        Integer period = Configs.asInteger((String)this.getConfig(Config.livenessProbePeriodSeconds));
        return this.discoverSpringBootHealthCheck(initialDelay, period);
    }

    protected Probe discoverSpringBootHealthCheck(Integer initialDelay, Integer period) {
        try {
            if (MavenUtil.hasAllClasses((MavenProject)this.getProject(), (String[])REQUIRED_CLASSES)) {
                Properties properties = SpringBootUtil.getSpringBootApplicationProperties((MavenProject)this.getProject());
                return this.buildProbe(properties, initialDelay, period);
            }
        }
        catch (Exception ex) {
            this.log.error("Error while reading the spring-boot configuration", new Object[]{ex});
        }
        return null;
    }

    protected Probe buildProbe(Properties springBootProperties, Integer initialDelay, Integer period) {
        String prefix;
        String scheme;
        SpringBootConfigurationHelper propertyHelper = new SpringBootConfigurationHelper(SpringBootUtil.getSpringBootVersion((MavenProject)this.getContext().getProject()));
        Integer managementPort = PropertiesHelper.getInteger((Properties)springBootProperties, (String)propertyHelper.getManagementPortPropertyKey());
        boolean usingManagementPort = managementPort != null;
        Integer port = managementPort;
        if (port == null) {
            port = PropertiesHelper.getInteger((Properties)springBootProperties, (String)propertyHelper.getServerPortPropertyKey(), (Integer)8080);
        }
        if (usingManagementPort) {
            scheme = Strings.isNotBlank((String)springBootProperties.getProperty(propertyHelper.getManagementKeystorePropertyKey())) ? SCHEME_HTTPS : SCHEME_HTTP;
            prefix = springBootProperties.getProperty(propertyHelper.getManagementContextPathPropertyKey(), "");
        } else {
            scheme = Strings.isNotBlank((String)springBootProperties.getProperty(propertyHelper.getServerKeystorePropertyKey())) ? SCHEME_HTTPS : SCHEME_HTTP;
            prefix = springBootProperties.getProperty(propertyHelper.getServerContextPathPropertyKey(), "");
            prefix = prefix + springBootProperties.getProperty(propertyHelper.getServletPathPropertyKey(), "");
            prefix = prefix + springBootProperties.getProperty(propertyHelper.getManagementContextPathPropertyKey(), "");
        }
        String actuatorBasePathKey = propertyHelper.getActuatorBasePathPropertyKey();
        String actuatorBasePath = propertyHelper.getActuatorDefaultBasePath();
        if (actuatorBasePathKey != null) {
            actuatorBasePath = springBootProperties.getProperty(actuatorBasePathKey, actuatorBasePath);
        }
        ProbeBuilder probeBuilder = (ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(port)).withPath(prefix + actuatorBasePath + "/health")).withScheme(scheme)).endHttpGet();
        if (initialDelay != null) {
            probeBuilder = (ProbeBuilder)probeBuilder.withInitialDelaySeconds(initialDelay);
        }
        if (period != null) {
            probeBuilder = (ProbeBuilder)probeBuilder.withPeriodSeconds(period);
        }
        return probeBuilder.build();
    }

    private static enum Config implements Configs.Key
    {
        readinessProbeInitialDelaySeconds{
            {
                this.d = "10";
            }
        }
        ,
        readinessProbePeriodSeconds,
        livenessProbeInitialDelaySeconds{
            {
                this.d = "180";
            }
        }
        ,
        livenessProbePeriodSeconds;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

