/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServiceDiscoveryEnricher
extends BaseEnricher {
    static final String ENRICHER_NAME = "f8-service-discovery";
    static final String PREFIX = "discovery.3scale.net";
    static final String DISCOVERY_VERSION = "discovery-version";
    static final String SCHEME = "scheme";
    static final String PATH = "path";
    static final String PORT = "port";
    static final String DESCRIPTION_PATH = "description-path";
    static final String DISCOVERABLE = "discoverable";
    private File springConfigDir;
    private String path = null;
    private String port = "80";
    private String scheme = "http";
    private String descriptionPath = null;
    private String discoverable = null;
    private String discoveryVersion = "v1";

    public ServiceDiscoveryEnricher(EnricherContext buildContext) {
        super(buildContext, ENRICHER_NAME);
        String baseDir = this.getProject().getBasedir().getAbsolutePath();
        this.springConfigDir = new File(this.getConfig(Config.springDir, baseDir + "/src/main/resources/spring"));
        this.discoverable = this.getConfig(Config.discoverable, null);
    }

    public void addMissingResources(KubernetesListBuilder listBuilder) {
        listBuilder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder serviceBuilder) {
                ServiceDiscoveryEnricher.this.addAnnotations(serviceBuilder);
            }
        });
    }

    protected void addAnnotations(ServiceBuilder serviceBuilder) {
        if (serviceBuilder.buildSpec() != null) {
            List ports = serviceBuilder.buildSpec().getPorts();
            if (!ports.isEmpty()) {
                ServicePort firstServicePort = (ServicePort)ports.iterator().next();
                this.port = firstServicePort.getPort().toString();
                this.log.info("Using first mentioned service port '%s' ", new Object[]{this.port});
            } else {
                this.log.warn("No service port was found", new Object[0]);
            }
        }
        this.tryCamelDSLProject();
        if (this.discoverable != null) {
            String labelName = PREFIX;
            String labelValue = this.getConfig(Config.discoverable, this.discoverable);
            ((ServiceBuilder)((ServiceFluent.MetadataNested)serviceBuilder.editOrNewMetadata().addToLabels(labelName, labelValue)).and()).buildMetadata();
            this.log.info("Add %s label: \"%s\" : \"%s\"", new Object[]{PREFIX, labelName, labelValue});
            HashMap<String, String> annotations = new HashMap<String, String>();
            annotations.put("discovery.3scale.net/discovery-version", this.getConfig(Config.discoveryVersion, this.discoveryVersion));
            annotations.put("discovery.3scale.net/scheme", this.getConfig(Config.scheme, this.scheme));
            String resolvedPath = this.getConfig(Config.path, this.path);
            if (resolvedPath != null) {
                if (!resolvedPath.startsWith("/")) {
                    resolvedPath = "/" + resolvedPath;
                }
                annotations.put("discovery.3scale.net/path", resolvedPath);
            }
            annotations.put("discovery.3scale.net/port", this.getConfig(Config.port, this.port));
            String resolvedDescriptionPath = this.getConfig(Config.descriptionPath, this.descriptionPath);
            if (resolvedDescriptionPath != null) {
                if (!resolvedDescriptionPath.toLowerCase().startsWith("http") && !resolvedDescriptionPath.startsWith("/")) {
                    resolvedDescriptionPath = "/" + resolvedDescriptionPath;
                }
                annotations.put("discovery.3scale.net/description-path", resolvedDescriptionPath);
            }
            for (String annotationName : annotations.keySet()) {
                this.log.info("Add %s annotation: \"%s\" : \"%s\"", new Object[]{PREFIX, annotationName, annotations.get(annotationName)});
            }
            ((ServiceBuilder)((ServiceFluent.MetadataNested)serviceBuilder.editMetadata().addToAnnotations(annotations)).and()).buildMetadata();
        }
    }

    public void tryCamelDSLProject() {
        File camelContextXmlFile = new File(this.springConfigDir.getAbsoluteFile() + "/camel-context.xml");
        if (camelContextXmlFile.exists()) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(camelContextXmlFile);
                XPath xPath = XPathFactory.newInstance().newXPath();
                Node nl = (Node)xPath.evaluate("/beans/camelContext/restConfiguration", doc, XPathConstants.NODE);
                if (nl != null) {
                    this.discoverable = "true";
                    if (nl.getAttributes().getNamedItem(SCHEME) != null) {
                        this.scheme = nl.getAttributes().getNamedItem(SCHEME).getNodeValue();
                        this.log.verbose("Obtained scheme '%s' from camel-context.xml ", new Object[]{this.scheme});
                    }
                    if (nl.getAttributes().getNamedItem("contextPath") != null) {
                        this.path = nl.getAttributes().getNamedItem("contextPath").getNodeValue();
                        this.log.verbose("Obtained path '%s' from camel-context.xml ", new Object[]{this.path});
                    }
                    if (nl.getAttributes().getNamedItem("apiContextPath") != null) {
                        this.descriptionPath = nl.getAttributes().getNamedItem("apiContextPath").getNodeValue();
                        this.log.verbose("Obtained descriptionPath '%s' from camel-context.xml ", new Object[]{this.descriptionPath});
                    }
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to load camel context file: %s", new Object[]{e});
            }
        }
    }

    private static enum Config implements Configs.Key
    {
        descriptionPath,
        discoverable,
        discoveryVersion,
        path,
        port,
        scheme,
        springDir;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

