/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import io.fabric8.kubernetes.api.model.HTTPHeader;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.AbstractHealthCheckEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class VertxHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    private static final String VERTX_MAVEN_PLUGIN_GA = "io.fabric8:vertx-maven-plugin";
    private static final String VERTX_GROUPID = "io.vertx";
    private static final int DEFAULT_MANAGEMENT_PORT = 8080;
    private static final String SCHEME_HTTP = "HTTP";
    private static final String VERTX_HEALTH = "vertx.health.";
    private static final Function<? super String, String> TRIM = new Function<String, String>(){

        @Nullable
        public String apply(@Nullable String input) {
            return input == null ? null : input.trim();
        }
    };

    public VertxHealthCheckEnricher(EnricherContext buildContext) {
        super(buildContext, "vertx-health-check");
    }

    protected Probe getReadinessProbe() {
        return this.discoverVertxHealthCheck(true);
    }

    protected Probe getLivenessProbe() {
        return this.discoverVertxHealthCheck(false);
    }

    private boolean isApplicable() {
        return MavenUtil.hasPlugin((MavenProject)this.getProject(), (String)VERTX_MAVEN_PLUGIN_GA) || MavenUtil.hasDependencyOnAnyArtifactOfGroup((MavenProject)this.getProject(), (String)VERTX_GROUPID);
    }

    private String getSpecificPropertyName(boolean readiness, String attribute) {
        if (readiness) {
            return "vertx.health.readiness." + attribute;
        }
        return "vertx.health.liveness." + attribute;
    }

    private Probe discoverVertxHealthCheck(boolean readiness) {
        if (!this.isApplicable()) {
            return null;
        }
        String type = ((String)this.getStringValue("type", readiness).or((Object)"http")).toUpperCase();
        Optional port = this.getIntegerValue("port", readiness);
        Optional<String> portName = this.getStringValue("port-name", readiness);
        String path = (String)this.getStringValue("path", readiness).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.isEmpty() || input.startsWith("/")) {
                    return input;
                }
                return "/" + input;
            }
        }).orNull();
        String scheme = ((String)this.getStringValue("scheme", readiness).or((Object)SCHEME_HTTP)).toUpperCase();
        Optional<Integer> initialDelay = this.getIntegerValue("initial-delay", readiness);
        Optional<Integer> period = this.getIntegerValue("period", readiness);
        Optional<Integer> timeout = this.getIntegerValue("timeout", readiness);
        Optional<Integer> successThreshold = this.getIntegerValue("success-threshold", readiness);
        Optional<Integer> failureThreshold = this.getIntegerValue("failure-threshold", readiness);
        List command = (List)this.getListValue("command", readiness).or(Collections.emptyList());
        Map headers = (Map)this.getMapValue("headers", readiness).or(Collections.emptyMap());
        if (port.isPresent() && portName.isPresent()) {
            this.log.error("Invalid health check configuration - both 'port' and 'port-name' are set, only one of them can be used", new Object[0]);
            throw new IllegalArgumentException("Invalid health check configuration - both 'port' and 'port-name' are set, only one of them can be used");
        }
        if (type.equalsIgnoreCase("TCP")) {
            if (!port.isPresent() && !portName.isPresent()) {
                this.log.info("TCP health check disabled (port not set)", new Object[0]);
                return null;
            }
            if (port.isPresent() && (Integer)port.get() <= 0) {
                this.log.info("TCP health check disabled (port set to a negative number)", new Object[0]);
                return null;
            }
        } else if (type.equalsIgnoreCase("EXEC")) {
            if (command.isEmpty()) {
                this.log.info("TCP health check disabled (command not set)", new Object[0]);
                return null;
            }
        } else if (type.equalsIgnoreCase(SCHEME_HTTP)) {
            if (port.isPresent() && (Integer)port.get() <= 0) {
                this.log.info("HTTP health check disabled (port set to " + port.get(), new Object[0]);
                return null;
            }
            if (path == null) {
                this.log.info("HTTP health check disabled (path not set)", new Object[0]);
                return null;
            }
            if (path.isEmpty()) {
                this.log.info("HTTP health check disabled (the path is empty)", new Object[0]);
                return null;
            }
            if (!port.isPresent() && !portName.isPresent()) {
                this.log.info("Using default management port (8080) for HTTP health check probe", new Object[0]);
                port = Optional.of((Object)8080);
            }
        } else {
            this.log.error("Invalid health check configuration - Unknown probe type, only 'exec', 'tcp' and 'http' (default) are supported", new Object[0]);
            throw new IllegalArgumentException("Invalid health check configuration - Unknown probe type, only 'exec', 'tcp' and 'http' (default) are supported");
        }
        ProbeBuilder builder = new ProbeBuilder();
        if (initialDelay.isPresent()) {
            builder.withInitialDelaySeconds((Integer)initialDelay.get());
        }
        if (period.isPresent()) {
            builder.withPeriodSeconds((Integer)period.get());
        }
        if (timeout.isPresent()) {
            builder.withTimeoutSeconds((Integer)timeout.get());
        }
        if (successThreshold.isPresent()) {
            builder.withSuccessThreshold((Integer)successThreshold.get());
        }
        if (failureThreshold.isPresent()) {
            builder.withFailureThreshold((Integer)failureThreshold.get());
        }
        switch (type) {
            case "HTTP": {
                ProbeFluent.HttpGetNested http = (ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)builder.withNewHttpGet().withScheme(scheme)).withPath(path);
                if (port.isPresent()) {
                    http.withNewPort((Integer)port.get());
                }
                if (portName.isPresent()) {
                    http.withNewPort((String)portName.get());
                }
                if (!headers.isEmpty()) {
                    ArrayList<HTTPHeader> list = new ArrayList<HTTPHeader>();
                    for (Map.Entry entry : headers.entrySet()) {
                        list.add(new HTTPHeader((String)entry.getKey(), (String)entry.getValue()));
                    }
                    http.withHttpHeaders(list);
                }
                http.endHttpGet();
                break;
            }
            case "TCP": {
                ProbeFluent.TcpSocketNested tcp = builder.withNewTcpSocket();
                if (port.isPresent()) {
                    tcp.withNewPort((Integer)port.get());
                }
                if (portName.isPresent()) {
                    tcp.withNewPort((String)portName.get());
                }
                tcp.endTcpSocket();
                break;
            }
            case "EXEC": {
                ((ProbeFluent.ExecNested)builder.withNewExec().withCommand(command)).endExec();
            }
        }
        return builder.build();
    }

    private Optional<String> getStringValue(String attribute, boolean readiness) {
        String specific = this.getSpecificPropertyName(readiness, attribute);
        String generic = VERTX_HEALTH + attribute;
        String property = this.getContext().getProject().getProperties().getProperty(specific);
        if (property != null) {
            return Optional.of((Object)property).transform(TRIM);
        }
        property = this.getContext().getProject().getProperties().getProperty(generic);
        if (property != null) {
            return Optional.of((Object)property).transform(TRIM);
        }
        String[] specificPath = new String[]{readiness ? "readiness" : "liveness", attribute};
        Optional config = this.getValueFromConfig(specificPath).transform(TRIM);
        if (!config.isPresent()) {
            return this.getValueFromConfig(attribute).transform(TRIM);
        }
        return config;
    }

    private Optional<List<String>> getListValue(String attribute, boolean readiness) {
        String[] path = new String[]{readiness ? "readiness" : "liveness", attribute};
        Optional<Xpp3Dom> element = this.getElement(path);
        if (!element.isPresent()) {
            element = this.getElement(attribute);
        }
        return element.transform((Function)new Function<Xpp3Dom, List<String>>(){

            public List<String> apply(Xpp3Dom input) {
                Xpp3Dom[] children = input.getChildren();
                ArrayList<String> list = new ArrayList<String>();
                for (Xpp3Dom child : children) {
                    list.add(child.getValue());
                }
                return list;
            }
        });
    }

    private Optional<Map<String, String>> getMapValue(String attribute, boolean readiness) {
        String[] path = new String[]{readiness ? "readiness" : "liveness", attribute};
        Optional<Xpp3Dom> element = this.getElement(path);
        if (!element.isPresent()) {
            element = this.getElement(attribute);
        }
        return element.transform((Function)new Function<Xpp3Dom, Map<String, String>>(){

            public Map<String, String> apply(Xpp3Dom input) {
                Xpp3Dom[] children = input.getChildren();
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (Xpp3Dom child : children) {
                    map.put(child.getName(), child.getValue());
                }
                return map;
            }
        });
    }

    private Optional<Integer> getIntegerValue(String attribute, boolean readiness) {
        return this.getStringValue(attribute, readiness).transform((Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return Integer.valueOf(input);
            }
        });
    }

    private Optional<String> getValueFromConfig(String ... keys) {
        return this.getElement(keys).transform((Function)new Function<Xpp3Dom, String>(){

            @Nullable
            public String apply(Xpp3Dom input) {
                return input.getValue();
            }
        });
    }

    private Optional<Xpp3Dom> getElement(String ... path) {
        Plugin plugin = this.getContext().getProject().getPlugin("io.fabric8:fabric8-maven-plugin");
        if (plugin == null) {
            this.getLog().warn("Unable to find the fabric8-maven-plugin in the project, weird...", new Object[0]);
            return Optional.absent();
        }
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        if (configuration == null) {
            return Optional.absent();
        }
        String[] roots = new String[]{"enricher", "config", "vertx-health-check"};
        ArrayList<String> absolute = new ArrayList<String>();
        absolute.addAll(Arrays.asList(roots));
        absolute.addAll(Arrays.asList(path));
        Xpp3Dom root = configuration;
        for (String key : absolute) {
            if ((root = root.getChild(key)) != null) continue;
            return Optional.absent();
        }
        return Optional.of((Object)root);
    }
}

