/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Lists;
import java.util.List;
import java.util.Map;

public class RemoveBuildAnnotationsEnricher
extends BaseEnricher {
    public RemoveBuildAnnotationsEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-remove-build-annotations");
    }

    public void adapt(KubernetesListBuilder builder) {
        List items = Lists.notNullList((List)builder.getItems());
        for (HasMetadata item : items) {
            this.removeBuildAnnotations(item);
        }
    }

    private void removeBuildAnnotations(HasMetadata item) {
        Map annotations;
        ObjectMeta metadata;
        if (item != null && (metadata = item.getMetadata()) != null && (annotations = metadata.getAnnotations()) != null) {
            annotations.remove("maven.fabric8.io/source-url");
        }
    }
}

