/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.ianaservicehelper.Helper;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;

public class DefaultServiceEnricher
extends BaseEnricher {
    private static final Pattern PORT_PROTOCOL_PATTERN = Pattern.compile("^(\\d+)(?:/(tcp|udp))?$", 2);
    private static final Pattern PORT_MAPPING_PATTERN = Pattern.compile("^\\s*(?<port>\\d+)(\\s*:\\s*(?<targetPort>\\d+))?(\\s*/\\s*(?<protocol>(tcp|udp)))?\\s*$", 2);

    public DefaultServiceEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-service");
    }

    public void addMissingResources(KubernetesListBuilder builder) {
        Service defaultService = this.getDefaultService();
        if (this.hasServices(builder)) {
            this.mergeInDefaultServiceParameters(builder, defaultService);
        } else {
            this.addDefaultService(builder, defaultService);
        }
    }

    private Service getDefaultService() {
        if (!this.hasImageConfiguration()) {
            return null;
        }
        List<ServicePort> ports = this.extractPorts(this.getImages());
        ServiceBuilder builder = (ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(this.getConfig(Config.name, MavenUtil.createDefaultResourceName((MavenProject)this.getProject(), (String[])new String[0])))).withLabels(this.extractLabels())).endMetadata();
        ServiceFluent.SpecNested specBuilder = builder.withNewSpec();
        if (!ports.isEmpty()) {
            specBuilder.withPorts(ports);
        } else if (Configs.asBoolean((String)this.getConfig(Config.headless))) {
            specBuilder.withClusterIP("None");
        } else {
            return null;
        }
        if (this.hasConfig(Config.type)) {
            specBuilder.withType(this.getConfig(Config.type));
        }
        specBuilder.endSpec();
        return builder.build();
    }

    private boolean hasServices(KubernetesListBuilder builder) {
        final AtomicBoolean hasService = new AtomicBoolean(false);
        builder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder element) {
                hasService.set(true);
            }
        });
        return hasService.get();
    }

    private void mergeInDefaultServiceParameters(KubernetesListBuilder builder, final Service defaultService) {
        builder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder service) {
                String defaultServiceName = DefaultServiceEnricher.this.getDefaultServiceName(defaultService);
                ObjectMeta serviceMetadata = DefaultServiceEnricher.this.ensureServiceMetadata(service, defaultService);
                String serviceName = DefaultServiceEnricher.this.ensureServiceName(serviceMetadata, service, defaultServiceName);
                if (defaultService != null && defaultServiceName.equals(serviceName)) {
                    DefaultServiceEnricher.this.addMissingServiceParts(service, defaultService);
                }
            }
        });
    }

    private void addDefaultService(KubernetesListBuilder builder, Service defaultService) {
        if (defaultService == null) {
            return;
        }
        ServiceSpec spec = defaultService.getSpec();
        List ports = spec.getPorts();
        if (ports.size() > 0) {
            this.log.info("Adding a default service '%s' with ports [%s]", new Object[]{defaultService.getMetadata().getName(), this.formatPortsAsList(ports)});
        } else {
            this.log.info("Adding headless default service '%s'", new Object[]{defaultService.getMetadata().getName()});
        }
        builder.addToServiceItems(new Service[]{defaultService});
    }

    private Map<String, String> extractLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (Configs.asBoolean((String)this.getConfig(Config.expose))) {
            labels.put("expose", "true");
        }
        return labels;
    }

    private List<ServicePort> extractPorts(List<ImageConfiguration> images) {
        ArrayList<ServicePort> ret = new ArrayList<ServicePort>();
        boolean isMultiPort = Boolean.parseBoolean(this.getConfig(Config.multiPort));
        List<ServicePort> configuredPorts = this.extractPortsFromConfig();
        for (ImageConfiguration image : images) {
            List<String> podPorts = this.getPortsFromBuildConfiguration(image);
            if (podPorts.isEmpty()) continue;
            this.addPortIfNotNull(ret, this.extractPortsFromImageSpec(image.getName(), podPorts.remove(0), this.shiftOrNull(configuredPorts)));
            if (!isMultiPort) continue;
            for (String port : podPorts) {
                this.addPortIfNotNull(ret, this.extractPortsFromImageSpec(image.getName(), port, this.shiftOrNull(configuredPorts)));
            }
        }
        if (isMultiPort) {
            ret.addAll(this.mirrorMissingTargetPorts(configuredPorts));
        } else if (ret.isEmpty() && !configuredPorts.isEmpty()) {
            ret.addAll(this.mirrorMissingTargetPorts(Collections.singletonList(configuredPorts.get(0))));
        }
        return ret;
    }

    private List<ServicePort> mirrorMissingTargetPorts(List<ServicePort> ports) {
        ArrayList<ServicePort> ret = new ArrayList<ServicePort>();
        for (ServicePort port : ports) {
            ret.add(this.updateMissingTargetPort(port, port.getPort()));
        }
        return ret;
    }

    private List<String> getPortsFromBuildConfiguration(ImageConfiguration image) {
        BuildImageConfiguration buildConfig = image.getBuildConfiguration();
        if (buildConfig == null) {
            return Collections.emptyList();
        }
        return buildConfig.getPorts() != null ? new LinkedList(buildConfig.getPorts()) : Collections.emptyList();
    }

    private List<ServicePort> extractPortsFromConfig() {
        LinkedList<ServicePort> ret = new LinkedList<ServicePort>();
        String ports = this.getConfig(Config.port);
        if (ports != null) {
            for (String port : StringUtils.split((String)ports, (String)",")) {
                ret.add(this.parsePortMapping(port));
            }
        }
        return ret;
    }

    private ServicePort parsePortMapping(String port) {
        Matcher matcher = PORT_MAPPING_PATTERN.matcher(port);
        if (!matcher.matches()) {
            this.log.error("Invalid 'port' configuration '%s'. Must match <port>(:<targetPort>)?,<port2>?,...", new Object[]{port});
            throw new IllegalArgumentException("Invalid port mapping specification " + port);
        }
        int servicePort = Integer.parseInt(matcher.group("port"));
        String optionalTargetPort = matcher.group("targetPort");
        String protocol = this.getProtocol(matcher.group("protocol"));
        ServicePortBuilder builder = (ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(servicePort))).withProtocol(protocol)).withName(this.getDefaultPortName(servicePort, protocol));
        if (optionalTargetPort != null) {
            builder.withNewTargetPort(Integer.valueOf(Integer.parseInt(optionalTargetPort)));
        }
        return builder.build();
    }

    private void addPortIfNotNull(List<ServicePort> ret, ServicePort port) {
        if (port != null) {
            ret.add(port);
        }
    }

    private ServicePort extractPortsFromImageSpec(String imageName, String portSpec, ServicePort portOverride) {
        Matcher portMatcher = PORT_PROTOCOL_PATTERN.matcher(portSpec);
        if (!portMatcher.matches()) {
            this.log.warn("Invalid port specification '%s' for image %s. Must match \\d+(/(tcp|udp))?. Ignoring for now for service generation", new Object[]{portSpec, imageName});
            return null;
        }
        Integer targetPort = Integer.parseInt(portMatcher.group(1));
        String protocol = this.getProtocol(portMatcher.group(2));
        Integer port = this.checkForLegacyMapping(targetPort);
        if (portOverride != null) {
            return this.updateMissingTargetPort(portOverride, targetPort);
        }
        return ((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(port)).withNewTargetPort(targetPort)).withProtocol(protocol)).withName(this.getDefaultPortName(port, protocol))).build();
    }

    private ServicePort updateMissingTargetPort(ServicePort port, Integer targetPort) {
        if (port.getTargetPort() == null) {
            return ((ServicePortBuilder)new ServicePortBuilder(port).withNewTargetPort(targetPort)).build();
        }
        return port;
    }

    private int checkForLegacyMapping(int port) {
        if (Configs.asBoolean((String)this.getConfig(Config.legacyPortMapping)) && (port == 8080 || port == 9090)) {
            return 80;
        }
        return port;
    }

    private String getProtocol(String imageProtocol) {
        String protocol;
        String string = protocol = imageProtocol != null ? imageProtocol : this.getConfig(Config.protocol);
        if ("tcp".equalsIgnoreCase(protocol) || "udp".equalsIgnoreCase(protocol)) {
            return protocol.toUpperCase();
        }
        throw new IllegalArgumentException(String.format("Invalid service protocol %s specified for enricher '%s'. Must be 'tcp' or 'udp'", protocol, this.getName()));
    }

    private String formatPortsAsList(List<ServicePort> ports) {
        ArrayList<String> p = new ArrayList<String>();
        for (ServicePort port : ports) {
            String targetPort = this.getPortValue(port.getTargetPort());
            String servicePort = port.getPort() != null ? Integer.toString(port.getPort()) : targetPort;
            p.add(targetPort.equals(servicePort) ? targetPort : servicePort + ":" + targetPort);
        }
        return StringUtils.join(p.iterator(), (String)",");
    }

    private String getPortValue(IntOrString port) {
        String val = port.getStrVal();
        if (val == null) {
            val = Integer.toString(port.getIntVal());
        }
        return val;
    }

    private String getDefaultPortName(int port, String serviceProtocol) {
        if ("TCP".equals(serviceProtocol)) {
            switch (port) {
                case 80: 
                case 8080: 
                case 9090: {
                    return "http";
                }
                case 443: 
                case 8443: {
                    return "https";
                }
                case 8778: {
                    return "jolokia";
                }
                case 9779: {
                    return "prometheus";
                }
            }
        }
        try {
            Set serviceNames = Helper.serviceNames((int)port, (String)serviceProtocol.toLowerCase());
            if (serviceNames != null && !serviceNames.isEmpty()) {
                return (String)serviceNames.iterator().next();
            }
            return null;
        }
        catch (IOException e) {
            this.log.warn("Cannot lookup port %d/%s in IANA database: %s", new Object[]{port, serviceProtocol.toLowerCase(), e.getMessage()});
            return null;
        }
    }

    private ServicePort shiftOrNull(List<ServicePort> ports) {
        if (!ports.isEmpty()) {
            return ports.remove(0);
        }
        return null;
    }

    private String getDefaultServiceName(Service defaultService) {
        String defaultServiceName = KubernetesHelper.getName((HasMetadata)defaultService);
        if (Strings.isNullOrBlank((String)defaultServiceName)) {
            defaultServiceName = this.getProject().getArtifactId();
        }
        return defaultServiceName;
    }

    private void addMissingServiceParts(ServiceBuilder service, Service defaultService) {
        if (!service.hasSpec().booleanValue()) {
            service.withNewSpecLike(defaultService.getSpec()).endSpec();
            return;
        }
        List ports = service.buildSpec().getPorts();
        if (ports == null || ports.isEmpty()) {
            ((ServiceFluent.SpecNested)service.editSpec().withPorts(defaultService.getSpec().getPorts())).endSpec();
            return;
        }
        ((ServiceFluent.SpecNested)service.editSpec().withPorts(this.addMissingDefaultPorts(ports, defaultService))).endSpec();
    }

    private String ensureServiceName(ObjectMeta serviceMetadata, ServiceBuilder service, String defaultServiceName) {
        String serviceName = KubernetesHelper.getName((ObjectMeta)serviceMetadata);
        if (Strings.isNullOrBlank((String)serviceName)) {
            service.buildMetadata().setName(defaultServiceName);
            serviceName = KubernetesHelper.getName((ObjectMeta)service.buildMetadata());
        }
        return serviceName;
    }

    private ObjectMeta ensureServiceMetadata(ServiceBuilder service, Service defaultService) {
        if (!service.hasMetadata().booleanValue() && defaultService != null) {
            service.withNewMetadataLike(defaultService.getMetadata()).endMetadata();
        }
        return service.buildMetadata();
    }

    private List<ServicePort> addMissingDefaultPorts(List<ServicePort> ports, Service defaultService) {
        this.ensurePortProtocolAndName(ports);
        return this.tryToFindAtLeastOnePort(ports, defaultService);
    }

    private void ensurePortProtocolAndName(List<ServicePort> ports) {
        for (ServicePort port : ports) {
            String protocol = this.ensureProtocol(port);
            this.ensurePortName(port, protocol);
        }
    }

    private List<ServicePort> tryToFindAtLeastOnePort(List<ServicePort> ports, Service defaultService) {
        List defaultPorts = defaultService.getSpec().getPorts();
        if (!ports.isEmpty() || defaultPorts == null || defaultPorts.isEmpty()) {
            return ports;
        }
        return Collections.singletonList(defaultPorts.get(0));
    }

    private void ensurePortName(ServicePort port, String protocol) {
        if (Strings.isNullOrBlank((String)port.getName())) {
            port.setName(this.getDefaultPortName(port.getPort(), this.getProtocol(protocol)));
        }
    }

    private String ensureProtocol(ServicePort port) {
        String protocol = port.getProtocol();
        if (Strings.isNullOrBlank((String)protocol)) {
            port.setProtocol("TCP");
            return "TCP";
        }
        return protocol;
    }

    private static enum Config implements Configs.Key
    {
        name,
        headless{
            {
                this.d = "false";
            }
        }
        ,
        expose{
            {
                this.d = "false";
            }
        }
        ,
        type,
        port,
        legacyPortMapping{
            {
                this.d = "false";
            }
        }
        ,
        multiPort{
            {
                this.d = "false";
            }
        }
        ,
        protocol{
            {
                this.d = "tcp";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

