/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetSpecFluent;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public class ImageEnricher
extends BaseEnricher {
    public ImageEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-image");
    }

    public void addMissingResources(KubernetesListBuilder builder) {
        if (!this.hasImageConfiguration()) {
            this.log.verbose("No images resolved. Skipping ...", new Object[0]);
            return;
        }
        this.ensureTemplateSpecs(builder);
        this.updateContainers(builder);
    }

    private void ensureTemplateSpecs(KubernetesListBuilder builder) {
        this.ensureTemplateSpecsInReplicationControllers(builder);
        this.ensureTemplateSpecsInRelicaSet(builder);
        this.ensureTemplateSpecsInDeployments(builder);
        this.ensureTemplateSpecsInDaemonSet(builder);
        this.ensureTemplateSpecsInStatefulSet(builder);
        this.ensureTemplateSpecsInDeploymentConfig(builder);
    }

    private void ensureTemplateSpecsInReplicationControllers(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder item) {
                ReplicationControllerFluent.SpecNested spec = item.getSpec() == null ? item.withNewSpec() : item.editSpec();
                ReplicationControllerSpecFluent.TemplateNested template = spec.getTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((ReplicationControllerFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void ensureTemplateSpecsInRelicaSet(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder item) {
                ReplicaSetFluent.SpecNested spec = item.getSpec() == null ? item.withNewSpec() : item.editSpec();
                ReplicaSetSpecFluent.TemplateNested template = spec.getTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((ReplicaSetFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void ensureTemplateSpecsInDeployments(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder item) {
                DeploymentFluent.SpecNested spec = item.getSpec() == null ? item.withNewSpec() : item.editSpec();
                DeploymentSpecFluent.TemplateNested template = spec.getTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((DeploymentFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void ensureTemplateSpecsInDaemonSet(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<DaemonSetBuilder>(){

            public void visit(DaemonSetBuilder item) {
                DaemonSetFluent.SpecNested spec = item.getSpec() == null ? item.withNewSpec() : item.editSpec();
                DaemonSetSpecFluent.TemplateNested template = spec.getTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((DaemonSetFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void ensureTemplateSpecsInStatefulSet(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder item) {
                StatefulSetFluent.SpecNested spec = item.getSpec() == null ? item.withNewSpec() : item.editSpec();
                StatefulSetSpecFluent.TemplateNested template = spec.getTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((StatefulSetFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void ensureTemplateSpecsInDeploymentConfig(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder item) {
                DeploymentConfigFluent.SpecNested spec = item.getSpec() == null ? item.withNewSpec() : item.editSpec();
                DeploymentConfigSpecFluent.TemplateNested template = spec.getTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((DeploymentConfigFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void updateContainers(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<PodTemplateSpecBuilder>(){

            public void visit(PodTemplateSpecBuilder templateBuilder) {
                PodTemplateSpecFluent.SpecNested podSpec = templateBuilder.getSpec() == null ? templateBuilder.withNewSpec() : templateBuilder.editSpec();
                ArrayList containers = podSpec.getContainers();
                if (containers == null) {
                    containers = new ArrayList();
                }
                ImageEnricher.this.mergeImageConfigurationWithContainerSpec(containers);
                ((PodTemplateSpecFluent.SpecNested)podSpec.withContainers(containers)).endSpec();
            }
        });
    }

    private void mergeImageConfigurationWithContainerSpec(List<Container> containers) {
        List images = this.getImages();
        int idx = 0;
        for (ImageConfiguration imageConfiguration : images) {
            Container container = this.getContainer(idx, containers);
            this.mergeImagePullPolicy(imageConfiguration, container);
            this.mergeImage(imageConfiguration, container);
            this.mergeContainerName(imageConfiguration, container);
            this.mergeEnvVariables(container);
            ++idx;
        }
    }

    private Container getContainer(int idx, List<Container> containers) {
        Container container;
        if (idx < containers.size()) {
            container = containers.get(idx);
        } else {
            container = new Container();
            containers.add(container);
        }
        return container;
    }

    private void mergeContainerName(ImageConfiguration imageConfiguration, Container container) {
        if (Strings.isNullOrBlank((String)container.getName())) {
            String containerName = KubernetesResourceUtil.extractContainerName((MavenProject)this.getProject(), (ImageConfiguration)imageConfiguration);
            this.log.verbose("Setting container name %s", new Object[]{containerName});
            container.setName(containerName);
        }
    }

    private void mergeImage(ImageConfiguration imageConfiguration, Container container) {
        if (Strings.isNullOrBlank((String)container.getImage())) {
            String prefix = "";
            if (Strings.isNotBlank((String)imageConfiguration.getRegistry())) {
                this.log.verbose("Using registry %s for the image", new Object[]{imageConfiguration.getRegistry()});
                prefix = imageConfiguration.getRegistry() + "/";
            }
            String imageFullName = prefix + imageConfiguration.getName();
            this.log.verbose("Setting image %s", new Object[]{imageFullName});
            container.setImage(imageFullName);
        }
    }

    private void mergeImagePullPolicy(ImageConfiguration imageConfiguration, Container container) {
        if (Strings.isNullOrBlank((String)container.getImagePullPolicy())) {
            String policy = this.getConfig(Config.pullPolicy);
            if (policy == null) {
                policy = "IfNotPresent";
                String imageName = imageConfiguration.getName();
                if (Strings.isNotBlank((String)imageName) && imageName.endsWith(":latest")) {
                    policy = "Always";
                }
            }
            container.setImagePullPolicy(policy);
        }
    }

    private void mergeEnvVariables(Container container) {
        ResourceConfig resource;
        Map userEnv;
        LinkedList env = container.getEnv();
        if (env == null) {
            env = new LinkedList();
            container.setEnv(env);
        }
        Map map = userEnv = (resource = this.getContext().getResources()) != null ? resource.getEnv() : null;
        if (userEnv != null) {
            for (Map.Entry entry : userEnv.entrySet()) {
                EnvVar existingVariable = KubernetesResourceUtil.setEnvVarNoOverride(env, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
                if (existingVariable == null) continue;
                String actualValue = existingVariable.getValue();
                if (actualValue == null) {
                    actualValue = "retrieved using the downward API";
                }
                this.log.warn("Environment variable %s will not be overridden: trying to set the value %s, but its actual value will be %s", new Object[]{entry.getKey(), entry.getValue(), actualValue});
            }
        }
    }

    private static enum Config implements Configs.Key
    {
        pullPolicy;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

