/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.maven.core.util.MapUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import java.util.List;
import java.util.Map;

public class PodAnnotationEnricher
extends BaseEnricher {
    public PodAnnotationEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-pod-annotations");
    }

    public void adapt(KubernetesListBuilder builder) {
        super.adapt(builder);
        List items = builder.getItems();
        for (HasMetadata item : items) {
            PodTemplateSpec template;
            if (!(item instanceof Deployment)) continue;
            Deployment deployment = (Deployment)item;
            ObjectMeta metadata = deployment.getMetadata();
            DeploymentSpec spec = deployment.getSpec();
            if (metadata == null || spec == null || (template = spec.getTemplate()) == null) continue;
            ObjectMeta templateMetadata = template.getMetadata();
            if (templateMetadata == null) {
                templateMetadata = new ObjectMeta();
                template.setMetadata(templateMetadata);
            }
            templateMetadata.setAnnotations(MapUtil.mergeMaps((Map)templateMetadata.getAnnotations(), (Map)metadata.getAnnotations()));
        }
        builder.withItems(items);
    }
}

