/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.maven.core.util.Base64Util;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import java.util.Map;

public abstract class SecretEnricher
extends BaseEnricher {
    public SecretEnricher(EnricherContext buildContext, String name) {
        super(buildContext, name);
    }

    protected String encode(String raw) {
        return Base64Util.encodeToString((String)raw);
    }

    public void addMissingResources(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<SecretBuilder>(){

            public void visit(SecretBuilder secretBuilder) {
                Map annotation = secretBuilder.buildMetadata().getAnnotations();
                if (!annotation.containsKey(SecretEnricher.this.getAnnotationKey())) {
                    return;
                }
                String dockerId = (String)annotation.get(SecretEnricher.this.getAnnotationKey());
                Map<String, String> data = SecretEnricher.this.generateData(dockerId);
                if (data == null) {
                    return;
                }
                annotation.remove(SecretEnricher.this.getAnnotationKey());
                secretBuilder.addToData(data);
            }
        });
    }

    protected abstract String getAnnotationKey();

    protected abstract Map<String, String> generateData(String var1);
}

