/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSet;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetBuilder;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.JSONUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.openshift.api.model.ImageChangeTrigger;
import io.fabric8.openshift.api.model.ImageChangeTriggerBuilder;
import io.fabric8.openshift.api.model.ImageChangeTriggerFluent;
import java.util.ArrayList;
import java.util.HashSet;

public class TriggersAnnotationEnricher
extends BaseEnricher {
    private static final String TRIGGERS_ANNOTATION = "image.openshift.io/triggers";

    public TriggersAnnotationEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-triggers-annotation");
    }

    public void adapt(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder o) {
                StatefulSet s = o.build();
                if (TriggersAnnotationEnricher.this.canWriteTriggers((HasMetadata)s)) {
                    o.withMetadata(TriggersAnnotationEnricher.this.getMetaEnrichedWithTriggers(s.getMetadata(), (VisitableBuilder<?, ?>)o));
                }
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder o) {
                ReplicaSet s = o.build();
                if (TriggersAnnotationEnricher.this.canWriteTriggers((HasMetadata)s)) {
                    o.withMetadata(TriggersAnnotationEnricher.this.getMetaEnrichedWithTriggers(s.getMetadata(), (VisitableBuilder<?, ?>)o));
                }
            }
        });
        builder.accept((Visitor)new TypedVisitor<DaemonSetBuilder>(){

            public void visit(DaemonSetBuilder o) {
                DaemonSet s = o.build();
                if (TriggersAnnotationEnricher.this.canWriteTriggers((HasMetadata)s)) {
                    o.withMetadata(TriggersAnnotationEnricher.this.getMetaEnrichedWithTriggers(s.getMetadata(), (VisitableBuilder<?, ?>)o));
                }
            }
        });
    }

    protected ObjectMeta getMetaEnrichedWithTriggers(ObjectMeta meta, VisitableBuilder<?, ?> o) {
        ObjectMetaBuilder metaBuilder = meta != null ? new ObjectMetaBuilder(meta) : new ObjectMetaBuilder();
        return ((ObjectMetaBuilder)metaBuilder.addToAnnotations(TRIGGERS_ANNOTATION, this.createAnnotation((Visitable<?>)o))).build();
    }

    protected boolean canWriteTriggers(HasMetadata res) {
        return res.getMetadata() == null || res.getMetadata().getAnnotations() == null || !res.getMetadata().getAnnotations().containsKey(TRIGGERS_ANNOTATION);
    }

    protected String createAnnotation(Visitable<?> builder) {
        final ArrayList triggerList = new ArrayList();
        builder.accept((Visitor)new TypedVisitor<ContainerBuilder>(){

            public void visit(ContainerBuilder cb) {
                Container container = cb.build();
                String containerName = container.getName();
                String containerImage = container.getImage();
                ImageName image = new ImageName(containerImage);
                if (TriggersAnnotationEnricher.this.isContainerAllowed(containerName) && image.getRegistry() == null && image.getUser() == null) {
                    String tag = image.getTag() != null ? image.getTag() : "latest";
                    ImageChangeTrigger trigger = ((ImageChangeTriggerBuilder)((ImageChangeTriggerFluent.FromNested)((ImageChangeTriggerFluent.FromNested)new ImageChangeTriggerBuilder().withNewFrom().withKind("ImageStreamTag")).withName(image.getSimpleName() + ":" + tag)).endFrom()).build();
                    trigger.setAdditionalProperty("fieldPath", (Object)("spec.template.spec.containers[?(@.name==\"" + containerName + "\")].image"));
                    triggerList.add(trigger);
                }
            }
        });
        try {
            return JSONUtil.mapper().writeValueAsString(triggerList);
        }
        catch (JsonProcessingException e) {
            this.getLog().error("Error while creating ImageStreamTag triggers for Kubernetes resources: %s", new Object[]{e});
            return "[]";
        }
    }

    protected boolean isContainerAllowed(String containerName) {
        String namesStr = this.getConfig(Config.containers);
        HashSet<String> allowedNames = new HashSet<String>();
        if (namesStr != null) {
            for (String name : namesStr.split(",")) {
                allowedNames.add(name.trim());
            }
        }
        return allowedNames.isEmpty() || allowedNames.contains(containerName);
    }

    private static enum Config implements Configs.Key
    {
        containers;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

