/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api;

import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.GoalFinder;
import io.fabric8.maven.docker.util.Logger;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class GeneratorContext {
    private MavenProject project;
    private MavenSession session;
    private GoalFinder goalFinder;
    private ProcessorConfig config;
    private String goalName;
    private Logger logger;
    private PlatformMode mode;
    private OpenShiftBuildStrategy strategy;
    private boolean useProjectClasspath;
    private boolean prePackagePhase;

    private GeneratorContext() {
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public GoalFinder getGoalFinder() {
        return this.goalFinder;
    }

    public ProcessorConfig getConfig() {
        return this.config;
    }

    public String getGoalName() {
        return this.goalName;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public PlatformMode getMode() {
        return this.mode;
    }

    public OpenShiftBuildStrategy getStrategy() {
        return this.strategy;
    }

    public boolean isWatchMode() throws MojoExecutionException {
        return this.runningWithGoal("fabric8:watch-spring-boot", "fabric8:watch");
    }

    public boolean runningWithGoal(String ... goals) throws MojoExecutionException {
        for (String goal : goals) {
            if (!this.goalFinder.runningWithGoal(this.project, this.session, goal)) continue;
            return true;
        }
        return false;
    }

    public boolean isUseProjectClasspath() {
        return this.useProjectClasspath;
    }

    public boolean isPrePackagePhase() {
        return this.prePackagePhase;
    }

    public static class Builder {
        private GeneratorContext ctx = new GeneratorContext();

        public Builder config(ProcessorConfig config) {
            this.ctx.config = config;
            return this;
        }

        public Builder project(MavenProject project) {
            this.ctx.project = project;
            return this;
        }

        public Builder session(MavenSession session) {
            this.ctx.session = session;
            return this;
        }

        public Builder goalFinder(GoalFinder goalFinder) {
            this.ctx.goalFinder = goalFinder;
            return this;
        }

        public Builder goalName(String goalName) {
            this.ctx.goalName = goalName;
            return this;
        }

        public Builder logger(Logger logger) {
            this.ctx.logger = logger;
            return this;
        }

        public Builder mode(PlatformMode mode) {
            this.ctx.mode = mode;
            return this;
        }

        public Builder strategy(OpenShiftBuildStrategy strategy) {
            this.ctx.strategy = strategy;
            return this;
        }

        public Builder useProjectClasspath(boolean useProjectClasspath) {
            this.ctx.useProjectClasspath = useProjectClasspath;
            return this;
        }

        public Builder prePackagePhase(boolean prePackagePhase) {
            this.ctx.prePackagePhase = prePackagePhase;
            return this;
        }

        public GeneratorContext build() {
            return this.ctx;
        }
    }
}

