/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.javaexec;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.FromSelector;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.generator.api.support.BaseGenerator;
import io.fabric8.maven.generator.javaexec.FatJarDetector;
import io.fabric8.maven.generator.javaexec.MainClassDetector;
import io.fabric8.utils.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class JavaExecGenerator
extends BaseGenerator {
    static final String JAVA_MAIN_CLASS_ENV_VAR = "JAVA_MAIN_CLASS";
    private static final String JAVA_OPTIONS = "JAVA_OPTIONS";
    private static final String[] JAVA_EXEC_MAVEN_PLUGINS = new String[]{"org.codehaus.mojo:exec-maven-plugin", "org.apache.maven.plugins:maven-shade-plugin"};
    private final FatJarDetector fatJarDetector = new FatJarDetector(this.getProject().getBuild().getDirectory());
    private final MainClassDetector mainClassDetector;

    public JavaExecGenerator(GeneratorContext context) {
        this(context, "java-exec");
    }

    protected JavaExecGenerator(GeneratorContext context, String name) {
        super(context, name, (FromSelector)new FromSelector.Default(context, "java"));
        this.mainClassDetector = new MainClassDetector(this.getConfig(Config.mainClass), new File(this.getProject().getBuild().getOutputDirectory()), context.getLogger());
    }

    public boolean isApplicable(List<ImageConfiguration> configs) throws MojoExecutionException {
        if (this.shouldAddImageConfiguration(configs)) {
            if (this.getConfig(Config.mainClass) != null) {
                return true;
            }
            for (String plugin : JAVA_EXEC_MAVEN_PLUGINS) {
                if (!MavenUtil.hasPlugin((MavenProject)this.getProject(), (String)plugin)) continue;
                return true;
            }
        }
        return false;
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean prePackagePhase) throws MojoExecutionException {
        ImageConfiguration.Builder imageBuilder = new ImageConfiguration.Builder();
        BuildImageConfiguration.Builder buildBuilder = null;
        buildBuilder = new BuildImageConfiguration.Builder().ports(this.extractPorts());
        this.addFrom(buildBuilder);
        if (!prePackagePhase) {
            buildBuilder.assembly(this.createAssembly());
        }
        Map<String, String> envMap = this.getEnv(prePackagePhase);
        envMap.put("JAVA_APP_DIR", this.getConfig(Config.targetDir));
        buildBuilder.env(envMap);
        this.addLatestTagIfSnapshot(buildBuilder);
        imageBuilder.name(this.getImageName()).registry(this.getRegistry()).alias(this.getAlias()).buildConfig(buildBuilder.build());
        configs.add(imageBuilder.build());
        return configs;
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) throws MojoExecutionException {
        List<String> javaOptions;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (!this.isFatJar()) {
            String mainClass = this.getConfig(Config.mainClass);
            if (mainClass == null && (mainClass = this.mainClassDetector.getMainClass()) == null && !prePackagePhase) {
                throw new MojoExecutionException("Cannot extract main class to startup");
            }
            if (mainClass != null) {
                this.log.verbose("Detected main class %s", new Object[]{mainClass});
                ret.put(JAVA_MAIN_CLASS_ENV_VAR, mainClass);
            }
        }
        if ((javaOptions = this.getExtraJavaOptions()).size() > 0) {
            ret.put(JAVA_OPTIONS, StringUtils.join(javaOptions.iterator(), (String)" "));
        }
        return ret;
    }

    protected List<String> getExtraJavaOptions() {
        return new ArrayList<String>();
    }

    protected AssemblyConfiguration createAssembly() throws MojoExecutionException {
        AssemblyConfiguration.Builder builder = new AssemblyConfiguration.Builder().targetDir(this.getConfig(Config.targetDir));
        this.addAssembly(builder);
        return builder.build();
    }

    protected void addAssembly(AssemblyConfiguration.Builder builder) throws MojoExecutionException {
        String assemblyRef = this.getConfig(Config.assemblyRef);
        if (assemblyRef != null) {
            builder.descriptorRef(assemblyRef);
        } else if (this.isFatJar()) {
            FatJarDetector.Result fatJar = this.detectFatJar();
            Assembly assembly = new Assembly();
            MavenProject project = this.getProject();
            if (fatJar == null) {
                DependencySet dependencySet = new DependencySet();
                dependencySet.addInclude(project.getGroupId() + ":" + project.getArtifactId());
                assembly.addDependencySet(dependencySet);
            } else {
                FileSet fileSet = new FileSet();
                File buildDir = new File(project.getBuild().getDirectory());
                fileSet.setDirectory(this.toRelativePath(buildDir, project.getBasedir()));
                fileSet.addInclude(this.toRelativePath(fatJar.getArchiveFile(), buildDir));
                fileSet.setOutputDirectory(".");
                fileSet.setFileMode("0640");
                assembly.addFileSet(fileSet);
            }
            assembly.addFileSet(this.createFileSet("src/main/fabric8-includes/bin", "bin", "0755", "0755"));
            assembly.addFileSet(this.createFileSet("src/main/fabric8-includes", ".", "0644", "0755"));
            builder.assemblyDef(assembly);
        } else {
            builder.descriptorRef("artifact-with-dependencies");
        }
    }

    private String toRelativePath(File archiveFile, File basedir) {
        String basedirPath;
        String absolutePath = archiveFile.getAbsolutePath();
        return (absolutePath = absolutePath.replace('\\', '/')).startsWith(basedirPath = basedir.getAbsolutePath().replace('\\', '/')) ? absolutePath.substring(basedirPath.length() + 1) : absolutePath;
    }

    private FileSet createFileSet(String sourceDir, String outputDir, String fileMode, String directoryMode) {
        FileSet fileSet = new FileSet();
        fileSet.setDirectory(sourceDir);
        fileSet.setOutputDirectory(outputDir);
        fileSet.setFileMode(fileMode);
        fileSet.setDirectoryMode(directoryMode);
        return fileSet;
    }

    protected boolean isFatJar() throws MojoExecutionException {
        return !this.hasMainClass() && this.detectFatJar() != null;
    }

    protected boolean hasMainClass() {
        return this.getConfig(Config.mainClass) != null;
    }

    public FatJarDetector.Result detectFatJar() throws MojoExecutionException {
        return this.fatJarDetector.scan();
    }

    protected List<String> extractPorts() {
        ArrayList<String> answer = new ArrayList<String>();
        this.addPortIfValid(answer, this.getConfig(Config.webPort));
        this.addPortIfValid(answer, this.getConfig(Config.jolokiaPort));
        this.addPortIfValid(answer, this.getConfig(Config.prometheusPort));
        return answer;
    }

    protected void addPortIfValid(List<String> list, String port) {
        if (Strings.isNotBlank((String)port) && Integer.parseInt(port) > 0) {
            list.add(port);
        }
    }

    public static enum Config implements Configs.Key
    {
        webPort{
            {
                this.d = "8080";
            }
        }
        ,
        jolokiaPort{
            {
                this.d = "8778";
            }
        }
        ,
        prometheusPort{
            {
                this.d = "9779";
            }
        }
        ,
        targetDir{
            {
                this.d = "/deployments";
            }
        }
        ,
        mainClass,
        assemblyRef;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

