/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.webapp;

import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.generator.api.support.BaseGenerator;
import io.fabric8.maven.generator.webapp.AppServerDetector;
import io.fabric8.maven.generator.webapp.AppServerHandler;
import io.fabric8.maven.generator.webapp.handler.CustomAppServerHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public class WebAppGenerator
extends BaseGenerator {
    public WebAppGenerator(GeneratorContext context) {
        super(context, "webapp");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddImageConfiguration(configs) && MavenUtil.hasPlugin((MavenProject)this.getProject(), (String)"org.apache.maven.plugins:maven-war-plugin");
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean prePackagePhase) {
        if (this.getContext().getMode() == PlatformMode.openshift && this.getContext().getStrategy() == OpenShiftBuildStrategy.s2i) {
            throw new IllegalArgumentException("S2I not yet supported for the webapp-generator. Use -Dfabric8.mode=kubernetes or -Dfabric8.buildStrategy=docker for OpenShift mode. Please refer to the reference manual at https://maven.fabric8.io for details about build modes.");
        }
        AppServerHandler handler = this.getAppServerHandler(this.getContext());
        this.log.info("Using %s as base image for webapp", new Object[]{handler.getFrom()});
        ImageConfiguration.Builder imageBuilder = new ImageConfiguration.Builder();
        BuildImageConfiguration.Builder buildBuilder = new BuildImageConfiguration.Builder().from(this.getFrom(handler)).ports(handler.exposedPorts()).cmd(this.getDockerRunCommand(handler)).env(this.getEnv(handler));
        if (!prePackagePhase) {
            buildBuilder.assembly(this.createAssembly(handler));
        }
        this.addLatestTagIfSnapshot(buildBuilder);
        imageBuilder.name(this.getImageName()).alias(this.getAlias()).buildConfig(buildBuilder.build());
        configs.add(imageBuilder.build());
        return configs;
    }

    private AppServerHandler getAppServerHandler(GeneratorContext context) {
        String from = super.getFrom();
        if (from != null) {
            return this.createCustomAppServerHandler(from);
        }
        return new AppServerDetector(context.getProject()).detect(this.getConfig(Config.server));
    }

    private AppServerHandler createCustomAppServerHandler(String from) {
        String user = this.getConfig(Config.user);
        String deploymentDir = this.getConfig(Config.targetDir, "/deployments");
        String command = this.getConfig(Config.cmd);
        List<String> ports = Arrays.asList(this.getConfig(Config.ports, "8080").split("\\s*,\\s*"));
        return new CustomAppServerHandler(from, deploymentDir, command, user, ports);
    }

    protected Map<String, String> getEnv(AppServerHandler handler) {
        HashMap<String, String> defaultEnv = new HashMap<String, String>();
        defaultEnv.put("DEPLOY_DIR", this.getDeploymentDir(handler));
        return defaultEnv;
    }

    private AssemblyConfiguration createAssembly(AppServerHandler handler) {
        AssemblyConfiguration.Builder builder = new AssemblyConfiguration.Builder().targetDir(this.getDeploymentDir(handler)).descriptorRef("webapp");
        String user = this.getUser(handler);
        if (user != null) {
            builder.user(user);
        }
        return builder.build();
    }

    protected String getFrom(AppServerHandler handler) {
        String from = super.getFrom();
        return from != null ? from : handler.getFrom();
    }

    private String getDockerRunCommand(AppServerHandler handler) {
        String cmd = this.getConfig(Config.cmd);
        return cmd != null ? cmd : handler.getCommand();
    }

    private String getDeploymentDir(AppServerHandler handler) {
        String deploymentDir = this.getConfig(Config.targetDir);
        return deploymentDir != null ? deploymentDir : handler.getDeploymentDir();
    }

    private String getUser(AppServerHandler handler) {
        String user = this.getConfig(Config.user);
        return user != null ? user : handler.getUser();
    }

    private static enum Config implements Configs.Key
    {
        server,
        targetDir,
        user,
        cmd,
        ports;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

