/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecBuilder;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.PodTemplateHandler;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import java.util.List;

public class DeploymentHandler {
    private final PodTemplateHandler podTemplateHandler;

    DeploymentHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public Deployment getDeployment(ResourceConfig config, List<ImageConfiguration> images) {
        Deployment deployment = ((DeploymentBuilder)((DeploymentBuilder)new DeploymentBuilder().withMetadata(this.createDeploymentMetaData(config))).withSpec(this.createDeploymentSpec(config, images))).build();
        return deployment;
    }

    private ObjectMeta createDeploymentMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId(config.getControllerName(), "controller name"))).build();
    }

    private DeploymentSpec createDeploymentSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((DeploymentSpecBuilder)((DeploymentSpecBuilder)new DeploymentSpecBuilder().withReplicas(Integer.valueOf(config.getReplicas()))).withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

