/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecBuilder;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.PodTemplateHandler;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import java.util.List;

public class ReplicaSetHandler {
    private final PodTemplateHandler podTemplateHandler;

    ReplicaSetHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public ReplicaSet getReplicaSet(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicaSetBuilder)((ReplicaSetBuilder)new ReplicaSetBuilder().withMetadata(this.createRsMetaData(config))).withSpec(this.createRsSpec(config, images))).build();
    }

    private ObjectMeta createRsMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId(config.getControllerName(), "controller name"))).build();
    }

    private ReplicaSetSpec createRsSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicaSetSpecBuilder)((ReplicaSetSpecBuilder)new ReplicaSetSpecBuilder().withReplicas(Integer.valueOf(config.getReplicas()))).withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

