/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service.kubernetes;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.ImageFormat;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.RegistryException;
import io.fabric8.maven.core.service.BuildService;
import io.fabric8.maven.core.util.JibBuildServiceUtil;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.DeepCopy;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.ExecutionException;

public class JibBuildService
implements BuildService {
    private BuildService.BuildServiceConfig config;
    private Logger log;

    private JibBuildService() {
    }

    public JibBuildService(BuildService.BuildServiceConfig config, Logger log) {
        Objects.requireNonNull(config, "config");
        this.config = config;
        this.log = log;
    }

    @Override
    public void build(ImageConfiguration imageConfiguration) {
        try {
            this.doJibBuild(JibBuildServiceUtil.getJibBuildConfiguration(this.config, imageConfiguration, this.log));
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    @Override
    public void postProcess(BuildService.BuildServiceConfig config) {
    }

    public JibContainer doJibBuild(JibBuildConfiguration jibBuildConfiguration) throws InvalidImageReferenceException, RegistryException, ExecutionException {
        return JibBuildServiceUtil.buildImage(jibBuildConfiguration, this.log);
    }

    public JibContainer doJibBuild(JibBuildConfiguration jibBuildConfiguration, boolean isOfflineMode) throws InvalidImageReferenceException, RegistryException, ExecutionException {
        return JibBuildServiceUtil.buildImage(jibBuildConfiguration, this.log, isOfflineMode);
    }

    public static class JibBuildConfiguration {
        private ImageConfiguration imageConfiguration;
        private ImageFormat imageFormat;
        private Credential credential;
        private Path fatJarPath;
        private String targetDir;
        private String outputDir;
        private MojoParameters mojoParameters;

        private JibBuildConfiguration() {
        }

        public ImageConfiguration getImageConfiguration() {
            return this.imageConfiguration;
        }

        public String getTargetDir() {
            return this.targetDir;
        }

        public String getOutputDir() {
            return this.outputDir;
        }

        public Credential getCredential() {
            return this.credential;
        }

        public Path getFatJar() {
            return this.fatJarPath;
        }

        public ImageFormat getImageFormat() {
            return this.imageFormat;
        }

        public MojoParameters getMojoParameters() {
            return this.mojoParameters;
        }

        public static class Builder {
            private final JibBuildConfiguration configutil;
            private final Logger logger;

            public Builder(Logger logger) {
                this(null, logger);
            }

            public Builder(JibBuildConfiguration that, Logger logger) {
                this.logger = logger;
                this.configutil = that == null ? new JibBuildConfiguration() : (JibBuildConfiguration)DeepCopy.copy((Object)that);
            }

            public Builder mojoParameters(MojoParameters mojoParameters) {
                this.configutil.mojoParameters = mojoParameters;
                return this;
            }

            public Builder imageConfiguration(ImageConfiguration imageConfiguration) {
                this.configutil.imageConfiguration = imageConfiguration;
                return this;
            }

            public Builder imageFormat(ImageFormat imageFormat) {
                this.configutil.imageFormat = imageFormat;
                return this;
            }

            public Builder credential(Credential credential) {
                this.configutil.credential = credential;
                return this;
            }

            public Builder buildDirectory(String buildDir) {
                this.configutil.fatJarPath = JibBuildServiceUtil.getFatJar(buildDir, this.logger);
                return this;
            }

            public Builder targetDir(String targetDir) {
                this.configutil.targetDir = targetDir;
                return this;
            }

            public Builder outputDir(String outputDir) {
                this.configutil.outputDir = outputDir;
                return this;
            }

            public JibBuildConfiguration build() {
                return this.configutil;
            }
        }
    }
}

