/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service.openshift;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.fabric8.kubernetes.api.model.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.service.BuildService;
import io.fabric8.maven.core.service.Fabric8ServiceException;
import io.fabric8.maven.core.service.openshift.ImageStreamService;
import io.fabric8.maven.core.util.IoUtil;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.core.util.kubernetes.KubernetesClientUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.core.util.kubernetes.OpenshiftHelper;
import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.assembly.ArchiverCustomizer;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.RegistryService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.AuthConfigFactory;
import io.fabric8.maven.docker.util.DockerFileUtil;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.DockerBuildStrategyFluent;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;

public class OpenshiftBuildService
implements BuildService {
    private final OpenShiftClient client;
    private final Logger log;
    private ServiceHub dockerServiceHub;
    private BuildService.BuildServiceConfig config;
    private RegistryService.RegistryConfig registryConfig;
    private AuthConfigFactory authConfigFactory;

    public OpenshiftBuildService(OpenShiftClient client, Logger log, ServiceHub dockerServiceHub, BuildService.BuildServiceConfig config) {
        Objects.requireNonNull(client, "client");
        Objects.requireNonNull(log, "log");
        Objects.requireNonNull(dockerServiceHub, "dockerServiceHub");
        Objects.requireNonNull(config, "config");
        this.client = client;
        this.log = log;
        this.dockerServiceHub = dockerServiceHub;
        this.config = config;
    }

    @Override
    public void build(ImageConfiguration imageConfig) throws Fabric8ServiceException {
        String buildName = null;
        try {
            ImageName imageName = new ImageName(imageConfig.getName());
            File dockerTar = this.createBuildArchive(imageConfig);
            KubernetesListBuilder builder = new KubernetesListBuilder();
            String openshiftPullSecret = this.config.getOpenshiftPullSecret();
            Boolean usePullSecret = this.checkOrCreatePullSecret(this.config, this.client, builder, openshiftPullSecret, imageConfig);
            buildName = usePullSecret != false ? this.updateOrCreateBuildConfig(this.config, this.client, builder, imageConfig, openshiftPullSecret) : this.updateOrCreateBuildConfig(this.config, this.client, builder, imageConfig, null);
            this.checkOrCreateImageStream(this.config, this.client, builder, this.getImageStreamName(imageName));
            this.applyResourceObjects(this.config, this.client, builder);
            Build build = this.startBuild(this.client, dockerTar, buildName);
            this.waitForOpenShiftBuildToComplete(this.client, build);
            this.addImageStreamToFile(this.getImageStreamFile(this.config), imageName, this.client);
        }
        catch (Fabric8ServiceException e) {
            throw e;
        }
        catch (Exception ex) {
            if (ex != null && ex.getCause() instanceof IOException) {
                this.log.error("Build for %s failed: %s", new Object[]{buildName, ex.getCause().getMessage()});
                this.logBuildFailure(this.client, buildName);
            }
            throw new Fabric8ServiceException("Unable to build the image using the OpenShift build service", ex);
        }
    }

    protected File createBuildArchive(ImageConfiguration imageConfig) throws Fabric8ServiceException {
        ArchiverCustomizer customizer = this.getS2ICustomizer(imageConfig);
        try {
            File dockerTar = customizer != null ? this.dockerServiceHub.getArchiveService().createDockerBuildArchive(imageConfig, this.config.getDockerMojoParameters(), customizer) : this.dockerServiceHub.getArchiveService().createDockerBuildArchive(imageConfig, this.config.getDockerMojoParameters());
            return dockerTar;
        }
        catch (MojoExecutionException e) {
            throw new Fabric8ServiceException("Unable to create the build archive", e);
        }
    }

    private ArchiverCustomizer getS2ICustomizer(ImageConfiguration imageConfiguration) throws Fabric8ServiceException {
        try {
            if (imageConfiguration.getBuildConfiguration() != null && imageConfiguration.getBuildConfiguration().getEnv() != null) {
                String fileName = IoUtil.sanitizeFileName("s2i-env-" + imageConfiguration.getName());
                File environmentFile = new File(this.config.getBuildDirectory(), fileName);
                try (PrintWriter out = new PrintWriter(new FileWriter(environmentFile));){
                    for (Map.Entry e : imageConfiguration.getBuildConfiguration().getEnv().entrySet()) {
                        out.println((String)e.getKey() + "=" + (String)e.getValue());
                    }
                }
                return tarArchiver -> {
                    tarArchiver.addFile(environmentFile, ".s2i/environment");
                    return tarArchiver;
                };
            }
            return null;
        }
        catch (IOException e) {
            throw new Fabric8ServiceException("Unable to add environment variables to the S2I build archive", e);
        }
    }

    private File getImageStreamFile(BuildService.BuildServiceConfig config) {
        return ResourceFileType.yaml.addExtensionIfMissing(new File(config.getBuildDirectory(), String.format("%s-is", config.getArtifactId())));
    }

    @Override
    public void postProcess(BuildService.BuildServiceConfig config) {
        config.attachArtifact("is", this.getImageStreamFile(config));
    }

    private String updateOrCreateBuildConfig(BuildService.BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder, ImageConfiguration imageConfig, String openshiftPullSecret) {
        ImageName imageName = new ImageName(imageConfig.getName());
        String buildName = this.getS2IBuildName(config, imageName);
        String imageStreamName = this.getImageStreamName(imageName);
        String outputImageStreamTag = imageStreamName + ":" + (imageName.getTag() != null ? imageName.getTag() : "latest");
        BuildStrategy buildStrategyResource = this.createBuildStrategy(imageConfig, config.getOpenshiftBuildStrategy(), openshiftPullSecret);
        BuildOutput buildOutput = ((BuildOutputBuilder)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)new BuildOutputBuilder().withNewTo().withKind("ImageStreamTag")).withName(outputImageStreamTag)).endTo()).build();
        BuildConfig buildConfig = (BuildConfig)((BuildConfigResource)client.buildConfigs().withName(buildName)).get();
        if (buildConfig != null) {
            BuildConfigSpec spec = this.getBuildConfigSpec(buildConfig);
            this.validateSourceType(buildName, spec);
            if (config.getBuildRecreateMode().isBuildConfig()) {
                ((BuildConfigResource)client.buildConfigs().withName(buildName)).delete();
                return this.createBuildConfig(builder, buildName, buildStrategyResource, buildOutput);
            }
            return this.updateBuildConfig(client, buildName, buildStrategyResource, buildOutput, spec);
        }
        return this.createBuildConfig(builder, buildName, buildStrategyResource, buildOutput);
    }

    private void validateSourceType(String buildName, BuildConfigSpec spec) {
        String sourceType;
        BuildSource source = spec.getSource();
        if (source != null && !Objects.equals("Binary", sourceType = source.getType())) {
            this.log.warn("BuildServiceConfig %s is not of type: 'Binary' but is '%s' !", new Object[]{buildName, sourceType});
        }
    }

    private BuildConfigSpec getBuildConfigSpec(BuildConfig buildConfig) {
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec == null) {
            spec = new BuildConfigSpec();
            buildConfig.setSpec(spec);
        }
        return spec;
    }

    private String createBuildConfig(KubernetesListBuilder builder, String buildName, BuildStrategy buildStrategyResource, BuildOutput buildOutput) {
        this.log.info("Creating BuildServiceConfig %s for %s build", new Object[]{buildName, buildStrategyResource.getType()});
        ((BaseKubernetesListFluent.BuildConfigItemsNested)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BaseKubernetesListFluent.BuildConfigItemsNested)((BuildConfigFluent.MetadataNested)builder.addNewBuildConfigItem().withNewMetadata().withName(buildName)).endMetadata()).withNewSpec().withNewSource().withType("Binary")).endSource()).withStrategy(buildStrategyResource)).withOutput(buildOutput)).endSpec()).endBuildConfigItem();
        return buildName;
    }

    private String updateBuildConfig(OpenShiftClient client, String buildName, BuildStrategy buildStrategy, BuildOutput buildOutput, BuildConfigSpec spec) {
        if (!Objects.equals(buildStrategy, spec.getStrategy()) || !Objects.equals(buildOutput, spec.getOutput())) {
            ((DoneableBuildConfig)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)((DoneableBuildConfig)((BuildConfigResource)client.buildConfigs().withName(buildName)).edit()).editSpec().withStrategy(buildStrategy)).withOutput(buildOutput)).endSpec()).done();
            this.log.info("Updating BuildServiceConfig %s for %s strategy", new Object[]{buildName, buildStrategy.getType()});
        } else {
            this.log.info("Using BuildServiceConfig %s for %s strategy", new Object[]{buildName, buildStrategy.getType()});
        }
        return buildName;
    }

    private BuildStrategy createBuildStrategy(ImageConfiguration imageConfig, OpenShiftBuildStrategy osBuildStrategy, String openshiftPullSecret) {
        if (osBuildStrategy == OpenShiftBuildStrategy.docker) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            Map fromExt = buildConfig.getFromExt();
            String fromName = buildConfig.isDockerFileMode() ? this.extractBaseFromDockerfile(buildConfig, this.config.getDockerBuildContext()) : this.getMapValueWithDefault((Map<String, String>)fromExt, OpenShiftBuildStrategy.SourceStrategy.name, buildConfig.getFrom());
            String fromKind = this.getMapValueWithDefault((Map<String, String>)fromExt, OpenShiftBuildStrategy.SourceStrategy.kind, "DockerImage");
            String fromNamespace = this.getMapValueWithDefault((Map<String, String>)fromExt, OpenShiftBuildStrategy.SourceStrategy.namespace, "ImageStreamTag".equals(fromKind) ? "openshift" : null);
            BuildStrategy buildStrategy = ((BuildStrategyBuilder)((BuildStrategyFluent.DockerStrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildStrategyFluent.DockerStrategyNested)((DockerBuildStrategyFluent.FromNested)((DockerBuildStrategyFluent.FromNested)((DockerBuildStrategyFluent.FromNested)((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Docker")).withNewDockerStrategy().withNewFrom().withKind(fromKind)).withName(fromName)).withNamespace(StringUtils.isEmpty((CharSequence)fromNamespace) ? null : fromNamespace)).endFrom()).withNoCache(this.checkForNocache(imageConfig))).withEnv(this.checkForEnv(imageConfig))).endDockerStrategy()).build();
            if (openshiftPullSecret != null) {
                buildStrategy.getDockerStrategy().setPullSecret(((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(openshiftPullSecret)).build());
            }
            return buildStrategy;
        }
        if (osBuildStrategy == OpenShiftBuildStrategy.s2i) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            Map fromExt = buildConfig.getFromExt();
            String fromName = buildConfig.isDockerFileMode() ? this.extractBaseFromDockerfile(buildConfig, this.config.getDockerBuildContext()) : this.getMapValueWithDefault((Map<String, String>)fromExt, OpenShiftBuildStrategy.SourceStrategy.name, buildConfig.getFrom());
            String fromKind = this.getMapValueWithDefault((Map<String, String>)fromExt, OpenShiftBuildStrategy.SourceStrategy.kind, "DockerImage");
            String fromNamespace = this.getMapValueWithDefault((Map<String, String>)fromExt, OpenShiftBuildStrategy.SourceStrategy.namespace, "ImageStreamTag".equals(fromKind) ? "openshift" : null);
            BuildStrategy buildStrategy = ((BuildStrategyBuilder)((BuildStrategyFluent.SourceStrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Source")).withNewSourceStrategy().withNewFrom().withKind(fromKind)).withName(fromName)).withNamespace(StringUtils.isEmpty((CharSequence)fromNamespace) ? null : fromNamespace)).endFrom()).withForcePull(Boolean.valueOf(this.config.isForcePullEnabled()))).endSourceStrategy()).build();
            if (openshiftPullSecret != null) {
                buildStrategy.getSourceStrategy().setPullSecret(((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(openshiftPullSecret)).build());
            }
            return buildStrategy;
        }
        throw new IllegalArgumentException("Unsupported BuildStrategy " + (Object)((Object)osBuildStrategy));
    }

    private Boolean checkForNocache(ImageConfiguration imageConfig) {
        String nocache = System.getProperty("docker.nocache");
        if (nocache != null) {
            return nocache.length() == 0 || Boolean.valueOf(nocache) != false;
        }
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        return buildConfig.getNoCache();
    }

    private List<EnvVar> checkForEnv(ImageConfiguration imageConfiguration) {
        BuildImageConfiguration buildImageConfiguration = imageConfiguration.getBuildConfiguration();
        if (buildImageConfiguration.getArgs() != null) {
            return KubernetesResourceUtil.convertToEnvVarList(buildImageConfiguration.getArgs());
        }
        return Collections.emptyList();
    }

    private Boolean checkOrCreatePullSecret(BuildService.BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder, String pullSecretName, ImageConfiguration imageConfig) throws MojoExecutionException, UnsupportedEncodingException {
        BuildService.BuildContext dockerBuildContext = config.getDockerBuildContext();
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        String fromImage = buildConfig.isDockerFileMode() ? this.extractBaseFromDockerfile(buildConfig, dockerBuildContext) : this.extractBaseFromConfiguration(buildConfig);
        String pullRegistry = EnvUtil.firstRegistryOf((String[])new String[]{new ImageName(fromImage).getRegistry(), dockerBuildContext.getRegistryConfig().getRegistry(), dockerBuildContext.getRegistryConfig().getRegistry()});
        if (pullRegistry != null) {
            RegistryService.RegistryConfig registryConfig = dockerBuildContext.getRegistryConfig();
            AuthConfig authConfig = registryConfig.getAuthConfigFactory().createAuthConfig(false, registryConfig.isSkipExtendedAuth(), registryConfig.getAuthConfig(), registryConfig.getSettings(), null, pullRegistry);
            if (authConfig != null) {
                boolean hasPullSecret;
                JsonObject auths = new JsonObject();
                JsonObject auth = new JsonObject();
                JsonObject item = new JsonObject();
                String authString = authConfig.getUsername() + ":" + authConfig.getPassword();
                item.add("auth", (JsonElement)new JsonPrimitive(Base64.encodeBase64String((byte[])authString.getBytes("UTF-8"))));
                auth.add(pullRegistry, (JsonElement)item);
                auths.add("auths", (JsonElement)auth);
                String credentials = Base64.encodeBase64String((byte[])auths.toString().getBytes("UTF-8"));
                HashMap<String, String> data = new HashMap<String, String>();
                data.put(".dockerconfigjson", credentials);
                boolean bl = hasPullSecret = ((Resource)client.secrets().withName(pullSecretName)).get() != null;
                if (hasPullSecret) {
                    this.log.info("Adding to Secret %s", new Object[]{pullSecretName});
                    return this.updateSecret(client, pullSecretName, data);
                }
                this.log.info("Creating Secret %s", new Object[]{hasPullSecret});
                ((BaseKubernetesListFluent.SecretItemsNested)((BaseKubernetesListFluent.SecretItemsNested)((BaseKubernetesListFluent.SecretItemsNested)((SecretFluent.MetadataNested)builder.addNewSecretItem().withNewMetadata().withName(pullSecretName)).endMetadata()).withData(data)).withType("kubernetes.io/dockerconfigjson")).endSecretItem();
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean updateSecret(OpenShiftClient client, String pullSecretName, Map<String, String> data) {
        if (!Objects.equals(data, ((Secret)((Resource)client.secrets().withName(pullSecretName)).get()).getData())) {
            ((DoneableSecret)((DoneableSecret)((DoneableSecret)((SecretFluent.MetadataNested)((DoneableSecret)((Resource)client.secrets().withName(pullSecretName)).edit()).editMetadata().withName(pullSecretName)).endMetadata()).withData(data)).withType("kubernetes.io/dockerconfigjson")).done();
            this.log.info("Updating Secret %s", new Object[]{pullSecretName});
        } else {
            this.log.info("Using Secret %s", new Object[]{pullSecretName});
        }
        return true;
    }

    private String extractBaseFromConfiguration(BuildImageConfiguration buildConfig) {
        AssemblyConfiguration assemblyConfig;
        String fromImage = buildConfig.getFrom();
        if (fromImage == null && (assemblyConfig = buildConfig.getAssemblyConfiguration()) == null) {
            fromImage = "busybox:latest";
        }
        return fromImage;
    }

    private String extractBaseFromDockerfile(BuildImageConfiguration buildConfig, BuildService.BuildContext buildContext) {
        String fromImage;
        try {
            File fullDockerFilePath = buildConfig.getAbsoluteDockerFilePath(buildContext.getMojoParameters());
            fromImage = DockerFileUtil.extractBaseImages((File)fullDockerFilePath, (FixedStringSearchInterpolator)DockerFileUtil.createInterpolator((MojoParameters)buildContext.getMojoParameters(), (String)buildConfig.getFilter())).stream().findFirst().orElse(null);
        }
        catch (IOException e) {
            fromImage = null;
        }
        return fromImage;
    }

    private void checkOrCreateImageStream(BuildService.BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder, String imageStreamName) {
        boolean hasImageStream;
        boolean bl = hasImageStream = ((Resource)client.imageStreams().withName(imageStreamName)).get() != null;
        if (hasImageStream && config.getBuildRecreateMode().isImageStream()) {
            ((Resource)client.imageStreams().withName(imageStreamName)).delete();
            hasImageStream = false;
        }
        if (!hasImageStream) {
            this.log.info("Creating ImageStream %s", new Object[]{imageStreamName});
            ((BaseKubernetesListFluent.ImageStreamItemsNested)((ImageStreamFluent.SpecNested)((ImageStreamSpecFluent.LookupPolicyNested)((BaseKubernetesListFluent.ImageStreamItemsNested)((ImageStreamFluent.MetadataNested)builder.addNewImageStreamItem().withNewMetadata().withName(imageStreamName)).endMetadata()).withNewSpec().withNewLookupPolicy().withLocal(Boolean.valueOf(config.isS2iImageStreamLookupPolicyLocal()))).endLookupPolicy()).endSpec()).endImageStreamItem();
        } else {
            this.log.info("Adding to ImageStream %s", new Object[]{imageStreamName});
        }
    }

    private void applyResourceObjects(BuildService.BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder) throws Exception {
        if (config.getEnricherTask() != null) {
            config.getEnricherTask().execute((Object)builder);
        }
        if (builder.hasItems().booleanValue()) {
            KubernetesList k8sList = builder.build();
            client.lists().create((Object[])new KubernetesList[]{k8sList});
        }
    }

    private Build startBuild(OpenShiftClient client, File dockerTar, String buildName) {
        this.log.info("Starting Build %s", new Object[]{buildName});
        try {
            return (Build)((BuildConfigResource)client.buildConfigs().withName(buildName)).instantiateBinary().fromFile(dockerTar);
        }
        catch (KubernetesClientException exp) {
            Status status = exp.getStatus();
            if (status != null) {
                this.log.error("OpenShift Error: [%d %s] [%s] %s", new Object[]{status.getCode(), status.getStatus(), status.getReason(), status.getMessage()});
            }
            if (exp.getCause() instanceof IOException && exp.getCause().getMessage().contains("Stream Closed")) {
                this.log.error("Build for %s failed: %s", new Object[]{buildName, exp.getCause().getMessage()});
                this.logBuildFailedDetails(client, buildName);
            }
            throw exp;
        }
    }

    private void waitForOpenShiftBuildToComplete(OpenShiftClient client, Build build) throws MojoExecutionException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch logTerminateLatch = new CountDownLatch(1);
        String buildName = KubernetesHelper.getName((HasMetadata)build);
        AtomicReference<Build> buildHolder = new AtomicReference<Build>();
        this.waitUntilPodIsReady(buildName + "-build", 120, this.log);
        this.log.info("Waiting for build " + buildName + " to complete...", new Object[0]);
        try (LogWatch logWatch = (LogWatch)((PodResource)client.pods().withName(buildName + "-build")).watchLog();){
            KubernetesClientUtil.printLogsAsync(logWatch, "Failed to tail build log", logTerminateLatch, this.log);
            Watcher<Build> buildWatcher = this.getBuildWatcher(latch, buildName, buildHolder);
            try (Watch watcher = (Watch)((BuildResource)client.builds().withName(buildName)).watch(buildWatcher);){
                String status;
                Build lastBuild = (Build)((BuildResource)client.builds().withName(buildName)).get();
                if (OpenshiftHelper.isFinished(KubernetesResourceUtil.getBuildStatusPhase(lastBuild))) {
                    this.log.debug("Build %s is already finished", new Object[]{buildName});
                    buildHolder.set(lastBuild);
                    latch.countDown();
                }
                this.waitUntilBuildFinished(latch);
                logTerminateLatch.countDown();
                build = buildHolder.get();
                if (build == null) {
                    this.log.debug("Build watcher on %s was closed prematurely", new Object[]{buildName});
                    build = (Build)((BuildResource)client.builds().withName(buildName)).get();
                }
                if (OpenshiftHelper.isFailed(status = KubernetesResourceUtil.getBuildStatusPhase(build)) || OpenshiftHelper.isCancelled(status)) {
                    throw new MojoExecutionException("OpenShift Build " + buildName + " failed: " + KubernetesResourceUtil.getBuildStatusReason(build));
                }
                if (!OpenshiftHelper.isFinished(status)) {
                    this.log.warn("Could not wait for the completion of build %s. It may be  may be still running (status=%s)", new Object[]{buildName, status});
                } else {
                    this.log.info("Build %s in status %s", new Object[]{buildName, status});
                }
            }
        }
    }

    private void waitUntilPodIsReady(String podName, int nAwaitTimeout, Logger log) throws InterruptedException {
        final CountDownLatch readyLatch = new CountDownLatch(1);
        try (Watch watch = (Watch)((PodResource)this.client.pods().withName(podName)).watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod aPod) {
                if (KubernetesHelper.isPodReady(aPod)) {
                    readyLatch.countDown();
                }
            }

            public void onClose(KubernetesClientException e) {
            }
        });){
            readyLatch.await(nAwaitTimeout, TimeUnit.SECONDS);
        }
        catch (KubernetesClientException | InterruptedException e) {
            log.error("Could not watch pod", new Object[]{e});
        }
    }

    private void waitUntilBuildFinished(CountDownLatch latch) {
        while (latch.getCount() > 0L) {
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private Watcher<Build> getBuildWatcher(final CountDownLatch latch, final String buildName, final AtomicReference<Build> buildHolder) {
        return new Watcher<Build>(){
            String lastStatus = "";

            public void eventReceived(Watcher.Action action, Build build) {
                buildHolder.set(build);
                String status = KubernetesResourceUtil.getBuildStatusPhase(build);
                OpenshiftBuildService.this.log.verbose(Logger.LogVerboseCategory.BUILD, "BuildWatch: Received event %s , build status: %s", new Object[]{action, build.getStatus()});
                if (!this.lastStatus.equals(status)) {
                    this.lastStatus = status;
                    OpenshiftBuildService.this.log.verbose(Logger.LogVerboseCategory.BUILD, "Build %s status: %s", new Object[]{buildName, status});
                }
                if (OpenshiftHelper.isFinished(status)) {
                    latch.countDown();
                }
            }

            public void onClose(KubernetesClientException cause) {
                if (cause != null) {
                    OpenshiftBuildService.this.log.error("Error while watching for build to finish: %s [%d]", new Object[]{cause.getMessage(), cause.getCode()});
                    Status status = cause.getStatus();
                    if (status != null) {
                        OpenshiftBuildService.this.log.error("%s [%s]", new Object[]{status.getReason(), status.getStatus()});
                    }
                }
                latch.countDown();
            }
        };
    }

    private void logBuildFailedDetails(OpenShiftClient client, String buildName) {
        try {
            BuildConfig build = (BuildConfig)((BuildConfigResource)client.buildConfigs().withName(buildName)).get();
            ObjectReference ref = build.getSpec().getStrategy().getSourceStrategy().getFrom();
            String kind = ref.getKind();
            String name = ref.getName();
            if ("DockerImage".equals(kind)) {
                this.log.error("Please, ensure that the Docker image '%s' exists and is accessible by OpenShift", new Object[]{name});
            } else if ("ImageStreamTag".equals(kind)) {
                String namespace = ref.getNamespace();
                String namespaceInfo = "current";
                String namespaceParams = "";
                if (namespace != null && !namespace.isEmpty()) {
                    namespaceInfo = "'" + namespace + "'";
                    namespaceParams = " -n " + namespace;
                }
                this.log.error("Please, ensure that the ImageStream Tag '%s' exists in the %s namespace (with 'oc get is%s')", new Object[]{name, namespaceInfo, namespaceParams});
            }
        }
        catch (Exception ex) {
            this.log.error("Unable to get detailed information from the BuildServiceConfig: " + ex.getMessage(), new Object[0]);
        }
    }

    private void logBuildFailure(OpenShiftClient client, String buildName) throws Fabric8ServiceException {
        block3: {
            try {
                List builds = ((BuildList)((NonNamespaceOperation)client.builds().inNamespace(client.getNamespace())).list()).getItems();
                for (Build build : builds) {
                    if (!build.getMetadata().getName().contains(buildName)) continue;
                    this.log.error(build.getMetadata().getName() + "\t\t" + build.getStatus().getReason() + "\t" + build.getStatus().getMessage(), new Object[0]);
                    throw new Fabric8ServiceException("Unable to build the image using the OpenShift build service", new KubernetesClientException(build.getStatus().getReason() + " " + build.getStatus().getMessage()));
                }
                this.log.error("Also, check cluster events via `oc get events` to see what could have possibly gone wrong", new Object[0]);
            }
            catch (KubernetesClientException clientException) {
                Status status = clientException.getStatus();
                if (status == null) break block3;
                this.log.error("OpenShift Error: [%d] %s", new Object[]{status.getCode(), status.getMessage()});
            }
        }
    }

    private void addImageStreamToFile(File imageStreamFile, ImageName imageName, OpenShiftClient client) throws MojoExecutionException {
        ImageStreamService imageStreamHandler = new ImageStreamService(client, this.log);
        imageStreamHandler.appendImageStreamResource(imageName, imageStreamFile);
    }

    private String getS2IBuildName(BuildService.BuildServiceConfig config, ImageName imageName) {
        return imageName.getSimpleName() + config.getS2iBuildNameSuffix();
    }

    private String getImageStreamName(ImageName name) {
        return name.getSimpleName();
    }

    private String getMapValueWithDefault(Map<String, String> map, OpenShiftBuildStrategy.SourceStrategy strategy, String defaultValue) {
        return this.getMapValueWithDefault(map, strategy.key(), defaultValue);
    }

    private String getMapValueWithDefault(Map<String, String> map, String field, String defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        String value = map.get(field);
        return value != null ? value : defaultValue;
    }
}

