/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.maven.core.util.ClassUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class PluginServiceFactory<C> {
    private List<ClassLoader> additionalClassLoaders = new ArrayList<ClassLoader>();
    private C context;
    private static Pattern COMMENT_LINE_PATTERN = Pattern.compile("^(\\s*#.*|\\s*)$");

    public PluginServiceFactory(C context, ClassLoader ... loaders) {
        this.context = context;
        for (ClassLoader loader : loaders) {
            this.addAdditionalClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> createServiceObjects(String ... descriptorPaths) {
        try {
            ServiceEntry.initDefaultOrder();
            TreeMap serviceMap = new TreeMap();
            for (String descriptor : descriptorPaths) {
                this.readServiceDefinitions(serviceMap, descriptor);
            }
            ArrayList ret = new ArrayList();
            for (Object service : serviceMap.values()) {
                ret.add(service);
            }
            ArrayList arrayList = ret;
            return arrayList;
        }
        finally {
            ServiceEntry.removeDefaultOrder();
        }
    }

    private <T> void readServiceDefinitions(Map<ServiceEntry, T> extractorMap, String defPath) {
        try {
            for (String url : ClassUtil.getResources(defPath, this.additionalClassLoaders)) {
                this.readServiceDefinitionFromUrl(extractorMap, url);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load service from " + defPath + ": " + e, e);
        }
    }

    private <T> void readServiceDefinitionFromUrl(Map<ServiceEntry, T> extractorMap, String url) {
        String line = null;
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(new URL(url).openStream(), "UTF8"));){
            line = reader.readLine();
            while (line != null) {
                this.createOrRemoveService(extractorMap, line);
                line = reader.readLine();
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new IllegalStateException("Cannot load service " + line + " defined in " + url + " : " + e + ". Aborting", e);
        }
    }

    private synchronized <T> void createOrRemoveService(Map<ServiceEntry, T> serviceMap, String line) throws ReflectiveOperationException {
        if (line.length() > 0 && !COMMENT_LINE_PATTERN.matcher(line).matches()) {
            ServiceEntry entry = new ServiceEntry(line);
            if (entry.isRemove()) {
                HashSet<ServiceEntry> toRemove = new HashSet<ServiceEntry>();
                for (ServiceEntry key : serviceMap.keySet()) {
                    if (!key.getClassName().equals(entry.getClassName())) continue;
                    toRemove.add(key);
                }
                for (ServiceEntry key : toRemove) {
                    serviceMap.remove(key);
                }
            } else {
                Class clazz = ClassUtil.classForName(entry.getClassName(), this.additionalClassLoaders);
                if (clazz == null) {
                    throw new ClassNotFoundException("Class " + entry.getClassName() + " could not be found");
                }
                Constructor constructor = clazz.getConstructor(this.context.getClass());
                if (constructor == null) {
                    throw new IllegalArgumentException("Internal Error: " + clazz + " does not have constructor (" + this.context.getClass() + ")");
                }
                Object service = constructor.newInstance(this.context);
                serviceMap.put(entry, service);
            }
        }
    }

    public void addAdditionalClassLoader(ClassLoader classLoader) {
        this.additionalClassLoaders.add(classLoader);
    }

    static class ServiceEntry
    implements Comparable<ServiceEntry> {
        private String className;
        private boolean remove;
        private Integer order;
        private static ThreadLocal<Integer> defaultOrderHolder = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 100;
            }
        };

        public ServiceEntry(String line) {
            String[] parts = line.split(",");
            if (parts[0].startsWith("!")) {
                this.remove = true;
                this.className = parts[0].substring(1);
            } else {
                this.remove = false;
                this.className = parts[0];
            }
            if (parts.length > 1) {
                try {
                    this.order = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException exp) {
                    this.order = this.nextDefaultOrder();
                }
            } else {
                this.order = this.nextDefaultOrder();
            }
        }

        private Integer nextDefaultOrder() {
            Integer defaultOrder = defaultOrderHolder.get();
            defaultOrderHolder.set(defaultOrder + 1);
            return defaultOrder;
        }

        private static void initDefaultOrder() {
            defaultOrderHolder.set(100);
        }

        private static void removeDefaultOrder() {
            defaultOrderHolder.remove();
        }

        private String getClassName() {
            return this.className;
        }

        private boolean isRemove() {
            return this.remove;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceEntry that = (ServiceEntry)o;
            return this.className.equals(that.className);
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        @Override
        public int compareTo(ServiceEntry o) {
            int ret = this.order - o.order;
            return ret != 0 ? ret : this.className.compareTo(o.className);
        }
    }
}

