/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import org.apache.commons.lang3.StringUtils;

public class VersionUtil {
    public static int compareVersions(String v1, String v2) {
        int diff;
        String[] components1 = VersionUtil.split(v1);
        String[] components2 = VersionUtil.split(v2);
        int length = Math.min(components1.length, components2.length);
        for (int i = 0; i < length; ++i) {
            String s1 = components1[i];
            String s2 = components2[i];
            Integer i1 = VersionUtil.tryParseInteger(s1);
            Integer i2 = VersionUtil.tryParseInteger(s2);
            diff = i1 != null && i2 != null ? i1.compareTo(i2) : s1.compareTo(s2);
            if (diff == 0) continue;
            return diff;
        }
        diff = Integer.compare(components1.length, components2.length);
        if (diff == 0) {
            if (v1 == v2) {
                return 0;
            }
            return v1 != null ? v1.compareTo(v2) : -1;
        }
        return diff;
    }

    private static String[] split(String text) {
        if (text != null) {
            return text.split("[\\.-]");
        }
        return new String[0];
    }

    private static Integer tryParseInteger(String text) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

