/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static TransformerFactory transformerFactory;
    private static Transformer transformer;

    private XmlUtils() {
    }

    public static Document parseDoc(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        try (FileInputStream is = new FileInputStream(xmlFile);){
            BufferedInputStream in = new BufferedInputStream(is);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource source = new InputSource(in);
            Document document = builder.parse(source);
            return document;
        }
    }

    public static Element firstChild(Element element, String name) {
        NodeList nodes = element.getChildNodes();
        if (nodes != null) {
            int size = nodes.getLength();
            for (int i = 0; i < size; ++i) {
                Element childElement;
                Node item = nodes.item(i);
                if (!(item instanceof Element) || !name.equals((childElement = (Element)item).getTagName())) continue;
                return childElement;
            }
        }
        return null;
    }

    public static String firstChildTextContent(Element element, String name) {
        Element child = XmlUtils.firstChild(element, name);
        if (child != null) {
            return child.getTextContent();
        }
        return null;
    }

    public static void removeChildren(Element element) {
        Node child;
        while ((child = element.getFirstChild()) != null) {
            element.removeChild(child);
        }
        return;
    }

    public static Element addChildElement(Node parent, String elementName) {
        Document ownerDocument = parent.getOwnerDocument();
        Objects.requireNonNull(ownerDocument, "nodes ownerDocument " + parent);
        Element element = ownerDocument.createElement(elementName);
        parent.appendChild(element);
        return element;
    }

    public static Element addChildElement(Node parent, String elementName, String textContent) {
        Element element = XmlUtils.addChildElement(parent, elementName);
        element.setTextContent(textContent);
        return element;
    }

    public static void save(Document document, File file) throws FileNotFoundException, TransformerException {
        Transformer transformer = XmlUtils.getTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(new FileOutputStream(file)));
    }

    private static String getTextContent(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                return XmlUtils.mergeTextContent(node.getChildNodes());
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return node.getNodeValue();
            }
        }
        return null;
    }

    private static String mergeTextContent(NodeList nodes) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String text;
            Node n = nodes.item(i);
            switch (n.getNodeType()) {
                case 7: 
                case 8: {
                    text = null;
                    break;
                }
                default: {
                    text = XmlUtils.getTextContent(n);
                }
            }
            if (text == null) continue;
            buf.append(text);
        }
        return buf.toString();
    }

    private static Transformer getTransformer() throws TransformerConfigurationException {
        if (transformer == null) {
            transformer = XmlUtils.getTransformerFactory().newTransformer();
        }
        return transformer;
    }

    private static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }
}

