/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util.kubernetes;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.batch.JobSpec;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.internal.HasMetadataComparator;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.model.GroupArtifactVersion;
import io.fabric8.maven.core.util.FileUtil;
import io.fabric8.maven.core.util.MapUtil;
import io.fabric8.maven.core.util.ResourceUtil;
import io.fabric8.maven.core.util.ResourceVersioning;
import io.fabric8.maven.core.util.kubernetes.KindFilenameMapperUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.OpenshiftHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesResourceUtil {
    private static final transient Logger LOG = LoggerFactory.getLogger(KubernetesResourceUtil.class);
    public static final String API_VERSION = "v1";
    public static final String API_EXTENSIONS_VERSION = "extensions/v1beta1";
    public static final String API_APPS_VERSION = "apps/v1";
    public static final String JOB_VERSION = "batch/v1";
    public static final String OPENSHIFT_V1_VERSION = "apps.openshift.io/v1";
    public static final String CRONJOB_VERSION = "batch/v1beta1";
    public static final String RBAC_VERSION = "rbac.authorization.k8s.io/v1";
    public static final ResourceVersioning DEFAULT_RESOURCE_VERSIONING = new ResourceVersioning().withCoreVersion("v1").withExtensionsVersion("extensions/v1beta1").withAppsVersion("apps/v1").withOpenshiftV1Version("apps.openshift.io/v1").withJobVersion("batch/v1").withCronJobVersion("batch/v1beta1").withRbacVersion("rbac.authorization.k8s.io/v1");
    public static final HashSet<Class<?>> SIMPLE_FIELD_TYPES = new HashSet();
    public static final String CONTAINER_NAME_REGEX = "^[a-z0-9]([-a-z0-9]*[a-z0-9])?$";
    protected static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssX";
    protected static final Map<String, String> FILENAME_TO_KIND_MAPPER = new HashMap<String, String>();
    protected static final Map<String, String> KIND_TO_FILENAME_MAPPER = new HashMap<String, String>();
    private static final String FILENAME_PATTERN = "^(?<name>.*?)(-(?<type>[^-]+))?\\.(?<ext>yaml|yml|json)$";
    private static final String PROFILES_PATTERN = "^profiles?\\.ya?ml$";

    public static KubernetesListBuilder readResourceFragmentsFrom(PlatformMode platformMode, ResourceVersioning apiVersions, String defaultName, File[] resourceFiles) throws IOException {
        KubernetesListBuilder builder = new KubernetesListBuilder();
        if (resourceFiles != null) {
            for (File file : resourceFiles) {
                if (file.getName().endsWith("cr.yml") || file.getName().endsWith("cr.yaml")) continue;
                HasMetadata resource = KubernetesResourceUtil.getResource(platformMode, apiVersions, file, defaultName);
                builder.addToItems(new HasMetadata[]{resource});
            }
        }
        return builder;
    }

    public static HasMetadata getResource(PlatformMode platformMode, ResourceVersioning apiVersions, File file, String appName) throws IOException {
        Map<String, Object> fragment = KubernetesResourceUtil.readAndEnrichFragment(platformMode, apiVersions, file, appName);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (HasMetadata)mapper.convertValue(fragment, HasMetadata.class);
        }
        catch (ClassCastException exp) {
            throw new IllegalArgumentException(String.format("Resource fragment %s has an invalid syntax (%s)", file.getPath(), exp.getMessage()));
        }
    }

    public static File[] listResourceFragments(File localResourceDir, List<String> remotes, io.fabric8.maven.docker.util.Logger log) {
        Object[] remoteResourceFiles;
        Object[] resourceFiles = KubernetesResourceUtil.listResourceFragments(localResourceDir);
        if (remotes != null && (remoteResourceFiles = KubernetesResourceUtil.listRemoteResourceFragments(remotes, log)).length > 0) {
            resourceFiles = (File[])ArrayUtils.addAll((Object[])resourceFiles, (Object[])remoteResourceFiles);
        }
        return resourceFiles;
    }

    public static File[] listResourceFragments(File resourceDir) {
        Pattern filenamePattern = Pattern.compile(FILENAME_PATTERN);
        Pattern exludePattern = Pattern.compile(PROFILES_PATTERN);
        return resourceDir.listFiles((dir, name) -> filenamePattern.matcher(name).matches() && !exludePattern.matcher(name).matches());
    }

    public static File[] listRemoteResourceFragments(List<String> remotes, io.fabric8.maven.docker.util.Logger log) {
        if (remotes != null && !remotes.isEmpty()) {
            File remoteResources = FileUtil.createTempDirectory();
            FileUtil.downloadRemotes(remoteResources, remotes, log);
            if (remoteResources.isDirectory()) {
                return remoteResources.listFiles();
            }
        }
        return new File[0];
    }

    protected static final void initializeKindFilenameMapper() {
        Map<String, List<String>> mappings = KindFilenameMapperUtil.loadMappings();
        KubernetesResourceUtil.updateKindFilenameMapper(mappings);
    }

    protected static final void remove(String kind, String filename) {
        FILENAME_TO_KIND_MAPPER.remove(filename);
        KIND_TO_FILENAME_MAPPER.remove(kind);
    }

    public static final void updateKindFilenameMapper(Map<String, List<String>> mappings) {
        Set<Map.Entry<String, List<String>>> entries = mappings.entrySet();
        for (Map.Entry<String, List<String>> entry : entries) {
            List<String> filenameTypes = entry.getValue();
            String kind = entry.getKey();
            for (String filenameType : filenameTypes) {
                FILENAME_TO_KIND_MAPPER.put(filenameType, kind);
            }
            KIND_TO_FILENAME_MAPPER.put(kind, filenameTypes.get(filenameTypes.size() - 1));
        }
    }

    private static Map<String, Object> readAndEnrichFragment(PlatformMode platformMode, ResourceVersioning apiVersions, File file, String appName) throws IOException {
        String kind;
        Pattern pattern = Pattern.compile(FILENAME_PATTERN, 2);
        Matcher matcher = pattern.matcher(file.getName());
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Resource file name '%s' does not match pattern <name>-<type>.(yaml|yml|json)", file.getName()));
        }
        String name = matcher.group("name");
        String type = matcher.group("type");
        String ext = matcher.group("ext").toLowerCase();
        Map<String, Object> fragment = KubernetesResourceUtil.readFragment(file, ext);
        if (type != null) {
            kind = KubernetesResourceUtil.getAndValidateKindFromType(file, type);
        } else {
            kind = FILENAME_TO_KIND_MAPPER.get(name.toLowerCase());
            if (kind != null) {
                name = null;
            }
        }
        KubernetesResourceUtil.addKind(fragment, kind, file.getName());
        String apiVersion = apiVersions.getCoreVersion();
        switch ((String)fragment.get("kind")) {
            case "Ingress": {
                apiVersion = apiVersions.getExtensionsVersion();
                break;
            }
            case "StatefulSet": 
            case "Deployment": {
                apiVersion = apiVersions.getAppsVersion();
                break;
            }
            case "Job": {
                apiVersion = apiVersions.getJobVersion();
                break;
            }
            case "DeploymentConfig": {
                apiVersion = platformMode == PlatformMode.openshift ? apiVersions.getOpenshiftV1version() : apiVersion;
                break;
            }
            case "CronJob": {
                apiVersion = apiVersions.getCronJobVersion();
                break;
            }
            case "ClusterRole": 
            case "ClusterRoleBinding": 
            case "Role": 
            case "RoleBinding": {
                apiVersion = apiVersions.getRbacVersion();
            }
        }
        KubernetesResourceUtil.addIfNotExistent(fragment, "apiVersion", apiVersion);
        Map<String, Object> metaMap = KubernetesResourceUtil.getMetadata(fragment);
        KubernetesResourceUtil.addIfNotExistent(metaMap, "name", StringUtils.isNotBlank((CharSequence)name) ? name : appName);
        return fragment;
    }

    private static String getAndValidateKindFromType(File file, String type) {
        String kind = FILENAME_TO_KIND_MAPPER.get(type.toLowerCase());
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Unknown type '%s' for file %s. Must be one of : %s", type, file.getName(), StringUtils.join(FILENAME_TO_KIND_MAPPER.keySet().iterator(), (String)", ")));
        }
        return kind;
    }

    private static void addKind(Map<String, Object> fragment, String kind, String fileName) {
        if (kind == null && !fragment.containsKey("kind")) {
            throw new IllegalArgumentException("No type given as part of the file name (e.g. 'app-rc.yml') and no 'Kind' defined in resource descriptor " + fileName);
        }
        KubernetesResourceUtil.addIfNotExistent(fragment, "kind", kind);
    }

    public static void removeItemFromKubernetesBuilder(KubernetesListBuilder builder, HasMetadata item) {
        List items = builder.buildItems();
        ArrayList<HasMetadata> newListItems = new ArrayList<HasMetadata>();
        for (HasMetadata listItem : items) {
            if (listItem.equals(item)) continue;
            newListItems.add(listItem);
        }
        builder.withItems(newListItems);
    }

    private static Map<String, Object> getMetadata(Map<String, Object> fragment) {
        Object mo = fragment.get("metadata");
        if (mo == null) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            fragment.put("metadata", meta);
            return meta;
        }
        if (mo instanceof Map) {
            return (Map)mo;
        }
        throw new IllegalArgumentException("Metadata is expected to be a Map, not a " + mo.getClass());
    }

    private static void addIfNotExistent(Map<String, Object> fragment, String key, String value) {
        if (!fragment.containsKey(key)) {
            fragment.put(key, value);
        }
    }

    private static Map<String, Object> readFragment(File file, String ext) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)("json".equals(ext) ? new JsonFactory() : new YAMLFactory()));
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            Map ret = (Map)mapper.readValue(file, (TypeReference)typeRef);
            return ret != null ? ret : new HashMap();
        }
        catch (JsonProcessingException e) {
            throw new JsonProcessingException(String.format("[%s] %s", file, e.getMessage()), e.getLocation(), e){};
        }
    }

    public static String getNameWithSuffix(String name, String kind) {
        String suffix = KIND_TO_FILENAME_MAPPER.get(kind);
        return suffix != null ? name + "-" + suffix : name;
    }

    public static String extractContainerName(GroupArtifactVersion groupArtifactVersion, ImageConfiguration imageConfig) {
        String alias = imageConfig.getAlias();
        return alias != null ? alias : KubernetesResourceUtil.extractImageUser(imageConfig.getName(), groupArtifactVersion.getGroupId()) + "-" + groupArtifactVersion.getArtifactId();
    }

    private static String extractImageUser(String image, String groupId) {
        ImageName name = new ImageName(image);
        String imageUser = name.getUser();
        String projectGroupId = groupId;
        if (imageUser != null) {
            return imageUser;
        }
        if (projectGroupId == null || projectGroupId.matches(CONTAINER_NAME_REGEX)) {
            return projectGroupId;
        }
        return projectGroupId.replaceAll("[^a-zA-Z0-9-]", "").replaceFirst("^-*(.*?)-*$", "$1");
    }

    public static Map<String, String> removeVersionSelector(Map<String, String> selector) {
        HashMap<String, String> answer = new HashMap<String, String>(selector);
        answer.remove("version");
        return answer;
    }

    public static boolean checkForKind(KubernetesListBuilder builder, String ... kinds) {
        HashSet<String> kindSet = new HashSet<String>(Arrays.asList(kinds));
        for (HasMetadata item : builder.getItems()) {
            if (!kindSet.contains(item.getKind())) continue;
            return true;
        }
        return false;
    }

    public static boolean addPort(List<ContainerPort> ports, String portNumberText, String portName, io.fabric8.maven.docker.util.Logger log) {
        int portValue;
        if (StringUtils.isBlank((CharSequence)portNumberText)) {
            return false;
        }
        try {
            portValue = Integer.parseInt(portNumberText);
        }
        catch (NumberFormatException e) {
            log.warn("Could not parse remote debugging port %s as an integer: %s", new Object[]{portNumberText, e});
            return false;
        }
        for (ContainerPort port : ports) {
            String name = port.getName();
            Integer containerPort = port.getContainerPort();
            if (containerPort == null || containerPort != portValue) continue;
            return false;
        }
        ports.add(((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName(portName)).withContainerPort(Integer.valueOf(portValue))).build());
        return true;
    }

    public static boolean setEnvVar(List<EnvVar> envVarList, String name, String value) {
        for (EnvVar envVar : envVarList) {
            String envVarName = envVar.getName();
            if (!Objects.equals(name, envVarName)) continue;
            String oldValue = envVar.getValue();
            if (Objects.equals(value, oldValue)) {
                return false;
            }
            envVar.setValue(value);
            return true;
        }
        EnvVar env = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(name)).withValue(value)).build();
        envVarList.add(env);
        return true;
    }

    public static String getEnvVar(List<EnvVar> envVarList, String name, String defaultValue) {
        String answer = defaultValue;
        if (envVarList != null) {
            for (EnvVar envVar : envVarList) {
                String value;
                String envVarName = envVar.getName();
                if (!Objects.equals(name, envVarName) || !StringUtils.isNotBlank((CharSequence)(value = envVar.getValue()))) continue;
                return value;
            }
        }
        return answer;
    }

    public static boolean removeEnvVar(List<EnvVar> envVarList, String name) {
        boolean removed = false;
        Iterator<EnvVar> it = envVarList.iterator();
        while (it.hasNext()) {
            EnvVar envVar = it.next();
            String envVarName = envVar.getName();
            if (!name.equals(envVarName)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    public static List<EnvVar> convertToEnvVarList(Map<String, String> envVars) {
        LinkedList<EnvVar> envList = new LinkedList<EnvVar>();
        for (Map.Entry<String, String> entry : envVars.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (name == null) continue;
            EnvVar env = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(name)).withValue(value)).build();
            envList.add(env);
        }
        return envList;
    }

    public static void validateKubernetesMasterUrl(URL masterUrl) throws MojoExecutionException {
        if (masterUrl == null || StringUtils.isBlank((CharSequence)masterUrl.toString())) {
            throw new MojoExecutionException("Cannot find Kubernetes master URL. Have you started a cluster via `mvn fabric8:cluster-start` or connected to a remote cluster via `kubectl`?");
        }
    }

    public static void handleKubernetesClientException(KubernetesClientException e, io.fabric8.maven.docker.util.Logger logger) throws MojoExecutionException {
        Throwable cause = e.getCause();
        if (cause instanceof UnknownHostException) {
            logger.error("Could not connect to kubernetes cluster!", new Object[0]);
            logger.error("Have you started a local cluster via `mvn fabric8:cluster-start` or connected to a remote cluster via `kubectl`?", new Object[0]);
            logger.info("For more help see: http://fabric8.io/guide/getStarted/", new Object[0]);
            logger.error("Connection error: %s", new Object[]{cause});
            String message = "Could not connect to kubernetes cluster. Have you started a cluster via `mvn fabric8:cluster-start` or connected to a remote cluster via `kubectl`? Error: " + cause;
            throw new MojoExecutionException(message, (Exception)((Object)e));
        }
        throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
    }

    public static String getBuildStatusPhase(Build build) {
        if (build != null && build.getStatus() != null) {
            return build.getStatus().getPhase();
        }
        return null;
    }

    public static String getBuildStatusReason(Build build) {
        if (build != null && build.getStatus() != null) {
            String reason = build.getStatus().getReason();
            String phase = build.getStatus().getPhase();
            if (StringUtils.isNotBlank((CharSequence)phase)) {
                if (StringUtils.isNotBlank((CharSequence)reason)) {
                    return phase + ": " + reason;
                }
                return phase;
            }
            return (String)StringUtils.defaultIfEmpty((CharSequence)reason, (CharSequence)"");
        }
        return "";
    }

    public static Pod getNewestPod(Collection<Pod> pods) {
        if (pods == null || pods.isEmpty()) {
            return null;
        }
        ArrayList<Pod> sortedPods = new ArrayList<Pod>(pods);
        Collections.sort(sortedPods, (p1, p2) -> {
            Date t1 = KubernetesResourceUtil.getCreationTimestamp((HasMetadata)p1);
            Date t2 = KubernetesResourceUtil.getCreationTimestamp((HasMetadata)p2);
            if (t1 != null) {
                if (t2 == null) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
            if (t2 == null) {
                return 0;
            }
            return -1;
        });
        return (Pod)sortedPods.get(sortedPods.size() - 1);
    }

    public static Date getCreationTimestamp(HasMetadata hasMetadata) {
        ObjectMeta metadata = hasMetadata.getMetadata();
        if (metadata != null) {
            return KubernetesResourceUtil.parseTimestamp(metadata.getCreationTimestamp());
        }
        return null;
    }

    private static Date parseTimestamp(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        return KubernetesResourceUtil.parseDate(text);
    }

    public static Date parseDate(String text) {
        try {
            return new SimpleDateFormat(DATE_TIME_FORMAT).parse(text);
        }
        catch (ParseException e) {
            LOG.warn("Unable to parse date: " + text, (Throwable)e);
            return null;
        }
    }

    public static boolean podHasContainerImage(Pod pod, String imageName) {
        List containers;
        PodSpec spec;
        if (pod != null && (spec = pod.getSpec()) != null && (containers = spec.getContainers()) != null) {
            for (Container container : containers) {
                if (!Objects.equals(imageName, container.getImage())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getDockerContainerID(Pod pod) {
        List containerStatuses;
        PodStatus status = pod.getStatus();
        if (status != null && (containerStatuses = status.getContainerStatuses()) != null) {
            for (ContainerStatus containerStatus : containerStatuses) {
                String containerID = containerStatus.getContainerID();
                if (!StringUtils.isNotBlank((CharSequence)containerID)) continue;
                String prefix = "://";
                int idx = containerID.indexOf(prefix);
                if (idx > 0) {
                    return containerID.substring(idx + prefix.length());
                }
                return containerID;
            }
        }
        return null;
    }

    public static boolean isNewerResource(HasMetadata newer, HasMetadata older) {
        Date t1 = KubernetesResourceUtil.getCreationTimestamp(newer);
        Date t2 = KubernetesResourceUtil.getCreationTimestamp(older);
        return t1 != null && (t2 == null || t1.compareTo(t2) > 0);
    }

    public static void mergeSimpleFields(Object targetValues, Object defaultValues) {
        Class<?> tc = targetValues.getClass();
        Class<?> sc = defaultValues.getClass();
        for (Method targetGetMethod : tc.getMethods()) {
            Class<?> fieldType;
            if (!targetGetMethod.getName().startsWith("get") || !SIMPLE_FIELD_TYPES.contains(fieldType = targetGetMethod.getReturnType())) continue;
            String fieldName = targetGetMethod.getName().substring(3);
            Method withMethod = null;
            try {
                withMethod = tc.getMethod("with" + fieldName, fieldType);
            }
            catch (NoSuchMethodException e) {
                try {
                    withMethod = tc.getMethod("set" + fieldName, fieldType);
                }
                catch (NoSuchMethodException e2) {
                    continue;
                }
            }
            Method sourceGetMethod = null;
            try {
                sourceGetMethod = sc.getMethod("get" + fieldName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            try {
                if (targetGetMethod.invoke(targetValues, new Object[0]) != null) continue;
                withMethod.invoke(targetValues, sourceGetMethod.invoke(defaultValues, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public static String mergePodSpec(PodSpecBuilder builder, PodSpec defaultPodSpec, String defaultName) {
        return KubernetesResourceUtil.mergePodSpec(builder, defaultPodSpec, defaultName, false);
    }

    public static String mergePodSpec(PodSpecBuilder builder, PodSpec defaultPodSpec, String defaultName, boolean sidecarEnabled) {
        String defaultApplicationContainerName = null;
        List containers = builder.buildContainers();
        List defaultContainers = defaultPodSpec.getContainers();
        int size = defaultContainers.size();
        if (size > 0) {
            if (containers == null || containers.isEmpty()) {
                builder.addToContainers(defaultContainers.toArray(new Container[size]));
            } else {
                int idx = 0;
                for (Container defaultContainer : defaultContainers) {
                    List defaultPorts;
                    Container container = null;
                    if (sidecarEnabled) {
                        for (Object fragmentContainer : containers) {
                            if (fragmentContainer.getName() != null && !fragmentContainer.getName().equals(defaultContainer.getName())) continue;
                            container = fragmentContainer;
                            defaultApplicationContainerName = defaultContainer.getName();
                            break;
                        }
                        if (container == null) {
                            container = new Container();
                            containers.add(container);
                        }
                    } else if (idx < containers.size()) {
                        container = (Container)containers.get(idx);
                    } else {
                        container = new Container();
                        containers.add(container);
                    }
                    KubernetesResourceUtil.mergeSimpleFields(container, defaultContainer);
                    List defaultEnv = defaultContainer.getEnv();
                    if (defaultEnv != null) {
                        Object fragmentContainer;
                        fragmentContainer = defaultEnv.iterator();
                        while (fragmentContainer.hasNext()) {
                            EnvVar envVar = (EnvVar)fragmentContainer.next();
                            KubernetesResourceUtil.ensureHasEnv(container, envVar);
                        }
                    }
                    if ((defaultPorts = defaultContainer.getPorts()) != null) {
                        for (ContainerPort port : defaultPorts) {
                            KubernetesResourceUtil.ensureHasPort(container, port);
                        }
                    }
                    if (container.getReadinessProbe() == null) {
                        container.setReadinessProbe(defaultContainer.getReadinessProbe());
                    }
                    if (container.getLivenessProbe() == null) {
                        container.setLivenessProbe(defaultContainer.getLivenessProbe());
                    }
                    if (container.getSecurityContext() == null) {
                        container.setSecurityContext(defaultContainer.getSecurityContext());
                    }
                    ++idx;
                }
                builder.withContainers(containers);
            }
        } else if (!containers.isEmpty()) {
            for (Container container : containers) {
                if (!StringUtils.isBlank((CharSequence)container.getName())) continue;
                container.setName(defaultName);
                break;
            }
            builder.withContainers(containers);
        }
        return defaultApplicationContainerName;
    }

    private static void ensureHasEnv(Container container, EnvVar envVar) {
        ArrayList<EnvVar> envVars = container.getEnv();
        if (envVars == null) {
            envVars = new ArrayList<EnvVar>();
            container.setEnv(envVars);
        }
        for (EnvVar var : envVars) {
            if (!Objects.equals(var.getName(), envVar.getName())) continue;
            envVars.remove(var);
            envVars.add(envVar);
            return;
        }
        envVars.add(envVar);
    }

    private static void ensureHasPort(Container container, ContainerPort port) {
        ArrayList<ContainerPort> ports = container.getPorts();
        if (ports == null) {
            ports = new ArrayList<ContainerPort>();
            container.setPorts(ports);
        }
        for (ContainerPort cp : ports) {
            String n1 = cp.getName();
            String n2 = port.getName();
            if (n1 != null && n2 != null && n1.equals(n2)) {
                return;
            }
            Integer p1 = cp.getContainerPort();
            Integer p2 = port.getContainerPort();
            if (p1 == null || p2 == null || p1.intValue() != p2.intValue()) continue;
            return;
        }
        ports.add(port);
    }

    public static String getSourceUrlAnnotation(HasMetadata item) {
        return KubernetesHelper.getOrCreateAnnotations(item).get("maven.fabric8.io/source-url");
    }

    public static void setSourceUrlAnnotationIfNotSet(HasMetadata item, String sourceUrl) {
        Map<String, String> annotations = KubernetesHelper.getOrCreateAnnotations(item);
        if (!annotations.containsKey("maven.fabric8.io/source-url")) {
            annotations.put("maven.fabric8.io/source-url", sourceUrl);
            item.getMetadata().setAnnotations(annotations);
        }
    }

    public static boolean isAppCatalogResource(HasMetadata templateOrConfigMap) {
        String catalogAnnotation = KubernetesHelper.getOrCreateAnnotations(templateOrConfigMap).get("maven.fabric8.io/app-catalog");
        return "true".equals(catalogAnnotation);
    }

    public static Set<HasMetadata> loadResources(File manifest) throws IOException {
        KubernetesResource dto = ResourceUtil.load(manifest, KubernetesResource.class);
        if (dto == null) {
            throw new IllegalStateException("Cannot load kubernetes manifest " + manifest);
        }
        if (dto instanceof Template) {
            Template template = (Template)dto;
            dto = OpenshiftHelper.processTemplatesLocally(template, false);
        }
        TreeSet<HasMetadata> entities = new TreeSet<HasMetadata>((Comparator<HasMetadata>)new HasMetadataComparator());
        entities.addAll(KubernetesHelper.toItemList(dto));
        return entities;
    }

    public static LabelSelector getPodLabelSelector(Set<HasMetadata> entities) {
        LabelSelector chosenSelector = null;
        for (HasMetadata entity : entities) {
            LabelSelector selector = KubernetesResourceUtil.getPodLabelSelector(entity);
            if (selector == null) continue;
            if (chosenSelector != null && !chosenSelector.equals((Object)selector)) {
                throw new IllegalArgumentException("Multiple selectors found for the given entities: " + chosenSelector + " - " + selector);
            }
            chosenSelector = selector;
        }
        return chosenSelector;
    }

    public static LabelSelector getPodLabelSelector(HasMetadata entity) {
        Job resource;
        JobSpec spec;
        LabelSelector selector = null;
        if (entity instanceof Deployment) {
            Deployment resource2 = (Deployment)entity;
            DeploymentSpec spec2 = resource2.getSpec();
            if (spec2 != null) {
                selector = spec2.getSelector();
            }
        } else if (entity instanceof ReplicaSet) {
            ReplicaSet resource3 = (ReplicaSet)entity;
            ReplicaSetSpec spec3 = resource3.getSpec();
            if (spec3 != null) {
                selector = spec3.getSelector();
            }
        } else if (entity instanceof DeploymentConfig) {
            DeploymentConfig resource4 = (DeploymentConfig)entity;
            DeploymentConfigSpec spec4 = resource4.getSpec();
            if (spec4 != null) {
                selector = KubernetesResourceUtil.toLabelSelector(spec4.getSelector());
            }
        } else if (entity instanceof ReplicationController) {
            ReplicationController resource5 = (ReplicationController)entity;
            ReplicationControllerSpec spec5 = resource5.getSpec();
            if (spec5 != null) {
                selector = KubernetesResourceUtil.toLabelSelector(spec5.getSelector());
            }
        } else if (entity instanceof DaemonSet) {
            DaemonSet resource6 = (DaemonSet)entity;
            DaemonSetSpec spec6 = resource6.getSpec();
            if (spec6 != null) {
                selector = spec6.getSelector();
            }
        } else if (entity instanceof StatefulSet) {
            StatefulSet resource7 = (StatefulSet)entity;
            StatefulSetSpec spec7 = resource7.getSpec();
            if (spec7 != null) {
                selector = spec7.getSelector();
            }
        } else if (entity instanceof Job && (spec = (resource = (Job)entity).getSpec()) != null) {
            selector = spec.getSelector();
        }
        return selector;
    }

    private static LabelSelector toLabelSelector(Map<String, String> matchLabels) {
        if (matchLabels != null && !matchLabels.isEmpty()) {
            return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(matchLabels)).build();
        }
        return null;
    }

    public static HasMetadata mergeResources(HasMetadata item1, HasMetadata item2, io.fabric8.maven.docker.util.Logger log, boolean switchOnLocalCustomisation) {
        if (item1 instanceof Deployment && item2 instanceof Deployment) {
            return KubernetesResourceUtil.mergeDeployments((Deployment)item1, (Deployment)item2, log, switchOnLocalCustomisation);
        }
        if (item1 instanceof ConfigMap && item2 instanceof ConfigMap) {
            ConfigMap cm1 = (ConfigMap)item1;
            ConfigMap cm2 = (ConfigMap)item2;
            return KubernetesResourceUtil.mergeConfigMaps(cm1, cm2, log, switchOnLocalCustomisation);
        }
        KubernetesResourceUtil.mergeMetadata(item1, item2);
        return item1;
    }

    protected static HasMetadata mergeConfigMaps(ConfigMap cm1, ConfigMap cm2, io.fabric8.maven.docker.util.Logger log, boolean switchOnLocalCustomisation) {
        ConfigMap cm1OrCopy = cm1;
        if (!switchOnLocalCustomisation) {
            cm1OrCopy = new ConfigMapBuilder(cm1OrCopy).build();
        }
        log.info("Merging 2 resources for " + KubernetesHelper.getKind((HasMetadata)cm1OrCopy) + " " + KubernetesHelper.getName((HasMetadata)cm1OrCopy) + " from " + KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)cm1OrCopy) + " and " + KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)cm2) + " and removing " + KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)cm1OrCopy), new Object[0]);
        cm1OrCopy.setData(KubernetesResourceUtil.mergeMapsAndRemoveEmptyStrings(cm2.getData(), cm1OrCopy.getData()));
        KubernetesResourceUtil.mergeMetadata((HasMetadata)cm1OrCopy, (HasMetadata)cm2);
        return cm1OrCopy;
    }

    protected static HasMetadata mergeDeployments(Deployment resource1, Deployment resource2, io.fabric8.maven.docker.util.Logger log, boolean switchOnLocalCustomisation) {
        Deployment resource1OrCopy = resource1;
        if (!switchOnLocalCustomisation) {
            resource1OrCopy = new DeploymentBuilder(resource1OrCopy).build();
        }
        Deployment answer = resource1OrCopy;
        DeploymentSpec spec1 = resource1OrCopy.getSpec();
        DeploymentSpec spec2 = resource2.getSpec();
        if (spec1 == null) {
            resource1OrCopy.setSpec(spec2);
        } else {
            PodTemplateSpec template1 = spec1.getTemplate();
            PodTemplateSpec template2 = null;
            if (spec2 != null) {
                template2 = spec2.getTemplate();
            }
            if (template1 != null && template2 != null) {
                KubernetesResourceUtil.mergeMetadata(template1, template2);
            }
            if (template1 == null) {
                spec1.setTemplate(template2);
            } else {
                PodSpec podSpec1 = template1.getSpec();
                PodSpec podSpec2 = null;
                if (template2 != null) {
                    podSpec2 = template2.getSpec();
                }
                if (podSpec1 == null) {
                    template1.setSpec(podSpec2);
                } else {
                    String defaultName = null;
                    PodTemplateSpec updateTemplate = template1;
                    if (switchOnLocalCustomisation) {
                        Deployment override = resource2;
                        if (KubernetesResourceUtil.isLocalCustomisation(podSpec1)) {
                            updateTemplate = template2;
                            PodSpec tmp = podSpec1;
                            podSpec1 = podSpec2;
                            podSpec2 = tmp;
                        } else {
                            answer = resource2;
                            override = resource1OrCopy;
                        }
                        KubernetesResourceUtil.mergeMetadata((HasMetadata)answer, (HasMetadata)override);
                    } else {
                        KubernetesResourceUtil.mergeMetadata((HasMetadata)resource1OrCopy, (HasMetadata)resource2);
                    }
                    if (updateTemplate != null) {
                        if (podSpec2 == null) {
                            updateTemplate.setSpec(podSpec1);
                        } else {
                            PodSpecBuilder podSpecBuilder = new PodSpecBuilder(podSpec1);
                            KubernetesResourceUtil.mergePodSpec(podSpecBuilder, podSpec2, defaultName);
                            updateTemplate.setSpec(podSpecBuilder.build());
                        }
                    }
                    return answer;
                }
            }
        }
        log.info("Merging 2 resources for " + KubernetesHelper.getKind((HasMetadata)resource1OrCopy) + " " + KubernetesHelper.getName((HasMetadata)resource1OrCopy) + " from " + KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)resource1OrCopy) + " and " + KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)resource2) + " and removing " + KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)resource1OrCopy), new Object[0]);
        return resource1OrCopy;
    }

    private static void mergeMetadata(PodTemplateSpec item1, PodTemplateSpec item2) {
        if (item1 != null && item2 != null) {
            ObjectMeta metadata1 = item1.getMetadata();
            ObjectMeta metadata2 = item2.getMetadata();
            if (metadata1 == null) {
                item1.setMetadata(metadata2);
            } else if (metadata2 != null) {
                metadata1.setAnnotations(KubernetesResourceUtil.mergeMapsAndRemoveEmptyStrings(metadata2.getAnnotations(), metadata1.getAnnotations()));
                metadata1.setLabels(KubernetesResourceUtil.mergeMapsAndRemoveEmptyStrings(metadata2.getLabels(), metadata1.getLabels()));
            }
        }
    }

    protected static void mergeMetadata(HasMetadata item1, HasMetadata item2) {
        if (item1 != null && item2 != null) {
            ObjectMeta metadata1 = item1.getMetadata();
            ObjectMeta metadata2 = item2.getMetadata();
            if (metadata1 == null) {
                item1.setMetadata(metadata2);
            } else if (metadata2 != null) {
                metadata1.setAnnotations(KubernetesResourceUtil.mergeMapsAndRemoveEmptyStrings(metadata2.getAnnotations(), metadata1.getAnnotations()));
                metadata1.setLabels(KubernetesResourceUtil.mergeMapsAndRemoveEmptyStrings(metadata2.getLabels(), metadata1.getLabels()));
            }
        }
    }

    private static Map<String, String> mergeMapsAndRemoveEmptyStrings(Map<String, String> overrideMap, Map<String, String> originalMap) {
        Map<String, String> answer = MapUtil.mergeMaps(overrideMap, originalMap);
        Set<Map.Entry<String, String>> entries = overrideMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String value = entry.getValue();
            if (value != null && !value.isEmpty()) continue;
            String key = entry.getKey();
            answer.remove(key);
        }
        return answer;
    }

    private static boolean isLocalCustomisation(PodSpec podSpec) {
        List containers = podSpec.getContainers() != null ? podSpec.getContainers() : Collections.emptyList();
        for (Container container : containers) {
            if (!StringUtils.isNotBlank((CharSequence)container.getImage())) continue;
            return false;
        }
        return true;
    }

    static {
        KubernetesResourceUtil.initializeKindFilenameMapper();
    }
}

