/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util.kubernetes;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.maven.core.util.ResourceUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftNotAvailableException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class OpenshiftHelper {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String DEFAULT_API_VERSION = "v1";

    public static OpenShiftClient asOpenShiftClient(KubernetesClient client) {
        if (client instanceof OpenShiftClient) {
            return (OpenShiftClient)client;
        }
        try {
            return (OpenShiftClient)client.adapt(OpenShiftClient.class);
        }
        catch (KubernetesClientException | OpenShiftNotAvailableException e) {
            return null;
        }
    }

    public static boolean isOpenShift(KubernetesClient client) {
        return client.isAdaptable(OpenShiftClient.class);
    }

    public static KubernetesList processTemplatesLocally(Template entity, boolean failOnMissingParameterValue) throws IOException {
        List parameters;
        List objects = null;
        if (entity != null && ((objects = entity.getObjects()) == null || objects.isEmpty())) {
            return null;
        }
        List list = parameters = entity != null ? entity.getParameters() : null;
        if (parameters != null && !parameters.isEmpty()) {
            String json = "{\"kind\": \"List\", \"apiVersion\": \"v1\",\n  \"items\": " + ResourceUtil.toJson(objects) + " }";
            for (int i = 0; i < 5; ++i) {
                for (Parameter parameter : parameters) {
                    String name = parameter.getName();
                    String from = "${" + name + "}";
                    String value = parameter.getValue();
                    if (StringUtils.isBlank((CharSequence)value)) {
                        if (failOnMissingParameterValue) {
                            throw new IllegalArgumentException("No value available for parameter name: " + name);
                        }
                        value = "";
                    }
                    json = json.replace(from, value);
                }
            }
            return (KubernetesList)OBJECT_MAPPER.readerFor(KubernetesList.class).readValue(json);
        }
        KubernetesList answer = new KubernetesList();
        answer.setItems(objects);
        return answer;
    }

    public static boolean isCancelled(String status) {
        return "Cancelled".equals(status);
    }

    public static boolean isFailed(String status) {
        return status != null && (status.startsWith("Fail") || status.startsWith("Error"));
    }

    public static boolean isCompleted(String status) {
        return "Complete".equals(status);
    }

    public static boolean isFinished(String status) {
        return OpenshiftHelper.isCompleted(status) || OpenshiftHelper.isFailed(status) || OpenshiftHelper.isCancelled(status);
    }

    public static Template combineTemplates(Template firstTemplate, Template template) {
        ArrayList<Parameter> parameters;
        List objects = template.getObjects();
        if (objects != null) {
            for (HasMetadata object : objects) {
                OpenshiftHelper.addTemplateObject(firstTemplate, object);
            }
        }
        if ((parameters = firstTemplate.getParameters()) == null) {
            parameters = new ArrayList<Parameter>();
            firstTemplate.setParameters(parameters);
        }
        OpenshiftHelper.combineParameters(parameters, template.getParameters());
        String name = KubernetesHelper.getName((HasMetadata)template);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            Map<String, String> annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)firstTemplate);
            Map<String, String> otherAnnotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)template);
            Set<Map.Entry<String, String>> entries = otherAnnotations.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (annotations.containsKey(key)) continue;
                annotations.put(key, value);
            }
        }
        return firstTemplate;
    }

    private static void combineParameters(List<Parameter> parameters, List<Parameter> otherParameters) {
        if (otherParameters != null && otherParameters.size() > 0) {
            HashMap<String, Parameter> map = new HashMap<String, Parameter>();
            for (Parameter parameter : parameters) {
                map.put(parameter.getName(), parameter);
            }
            for (Parameter otherParameter : otherParameters) {
                String name = otherParameter.getName();
                Parameter original = (Parameter)map.get(name);
                if (original == null) {
                    parameters.add(otherParameter);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)original.getValue())) continue;
                original.setValue(otherParameter.getValue());
            }
        }
    }

    private static void addTemplateObject(Template template, HasMetadata object) {
        List objects = template.getObjects();
        objects.add(object);
        template.setObjects(objects);
    }

    public static boolean isOpenShiftClient(KubernetesClient kubernetes) {
        return OpenshiftHelper.asOpenShiftClient(kubernetes) != null;
    }
}

