/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api.visitor;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.maven.core.config.MetaDataConfig;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;

public abstract class MetadataVisitor<T>
extends TypedVisitor<T> {
    private static ThreadLocal<ProcessorConfig> configHolder = new ThreadLocal();
    private final Map<String, String> labelsFromConfig;
    private final Map<String, String> annotationFromConfig;

    private MetadataVisitor(ResourceConfig resourceConfig) {
        if (resourceConfig != null) {
            this.labelsFromConfig = this.getMapFromConfiguration(resourceConfig.getLabels(), this.getKind());
            this.annotationFromConfig = this.getMapFromConfiguration(resourceConfig.getAnnotations(), this.getKind());
        } else {
            this.labelsFromConfig = new HashMap<String, String>();
            this.annotationFromConfig = new HashMap<String, String>();
        }
    }

    public static void setProcessorConfig(ProcessorConfig config) {
        configHolder.set(config);
    }

    public static void clearProcessorConfig() {
        configHolder.set(null);
    }

    private ProcessorConfig getProcessorConfig() {
        ProcessorConfig config = configHolder.get();
        if (config == null) {
            throw new IllegalArgumentException("No ProcessorConfig set");
        }
        return config;
    }

    public void visit(T item) {
        ProcessorConfig config = this.getProcessorConfig();
        ObjectMeta metadata = this.getOrCreateMetadata(item);
        this.updateLabels(metadata);
        this.updateAnnotations(metadata);
    }

    private void updateLabels(ObjectMeta metadata) {
        this.overlayMap(metadata.getLabels(), this.labelsFromConfig);
    }

    private void updateAnnotations(ObjectMeta metadata) {
        this.overlayMap(metadata.getAnnotations(), this.annotationFromConfig);
    }

    private Map<String, String> getMapFromConfiguration(MetaDataConfig config, Kind kind) {
        if (config == null) {
            return new HashMap<String, String>();
        }
        Map<String, String> ret = kind == Kind.SERVICE ? this.propertiesToMap(config.getService()) : (kind == Kind.DEPLOYMENT || kind == Kind.DEPLOYMENT_CONFIG ? this.propertiesToMap(config.getDeployment()) : (kind == Kind.REPLICATION_CONTROLLER || kind == Kind.REPLICA_SET ? this.propertiesToMap(config.getReplicaSet()) : (kind == Kind.POD_SPEC ? this.propertiesToMap(config.getPod()) : (kind == Kind.INGRESS ? this.propertiesToMap(config.getIngress()) : new HashMap<String, String>()))));
        if (config.getAll() != null) {
            ret.putAll(this.propertiesToMap(config.getAll()));
        }
        return ret;
    }

    private Map<String, String> propertiesToMap(Properties properties) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                propertyMap.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return propertyMap;
    }

    private void overlayMap(Map<String, String> targetMap, Map<String, String> enrichMap) {
        targetMap = this.ensureMap(targetMap);
        enrichMap = this.ensureMap(enrichMap);
        for (Map.Entry<String, String> entry : enrichMap.entrySet()) {
            if (targetMap.containsKey(entry.getKey())) continue;
            targetMap.put(entry.getKey(), entry.getValue());
        }
    }

    protected abstract Kind getKind();

    protected abstract ObjectMeta getOrCreateMetadata(T var1);

    private Map<String, String> ensureMap(Map<String, String> labels) {
        return labels != null ? labels : new HashMap();
    }

    private static <T extends ObjectMetaFluent<?>> T addEmptyLabelsAndAnnotations(Supplier<Boolean> hasMetadata, Supplier<T> withNewMetadata, Supplier<T> editMetadata, Supplier<ObjectMeta> buildMetadata) {
        ObjectMetaFluent ret;
        if (Boolean.TRUE.equals(hasMetadata.get())) {
            ret = (ObjectMetaFluent)editMetadata.get();
            if (buildMetadata.get().getLabels() == null) {
                ret.withLabels(Collections.emptyMap());
            }
            if (buildMetadata.get().getAnnotations() == null) {
                ret.withAnnotations(Collections.emptyMap());
            }
        } else {
            ret = (ObjectMetaFluent)withNewMetadata.get();
            ret.withLabels(Collections.emptyMap()).withAnnotations(Collections.emptyMap());
        }
        return (T)ret;
    }

    public static class IngressBuilderVisitor
    extends MetadataVisitor<IngressBuilder> {
        public IngressBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.INGRESS;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(IngressBuilder item) {
            return ((IngressBuilder)((IngressFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((IngressBuilder)item).hasMetadata(), () -> ((IngressBuilder)item).withNewMetadata(), () -> ((IngressBuilder)item).editMetadata(), () -> ((IngressBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }

    public static class BuildBuilderVisitor
    extends MetadataVisitor<BuildBuilder> {
        public BuildBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.BUILD;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(BuildBuilder item) {
            return ((BuildBuilder)((BuildFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((BuildBuilder)item).hasMetadata(), () -> ((BuildBuilder)item).withNewMetadata(), () -> ((BuildBuilder)item).editMetadata(), () -> ((BuildBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }

    public static class BuildConfigBuilderVisitor
    extends MetadataVisitor<BuildConfigBuilder> {
        public BuildConfigBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.BUILD_CONFIG;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(BuildConfigBuilder item) {
            return ((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((BuildConfigBuilder)item).hasMetadata(), () -> ((BuildConfigBuilder)item).withNewMetadata(), () -> ((BuildConfigBuilder)item).editMetadata(), () -> ((BuildConfigBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }

    public static class ImageStreamBuilderVisitor
    extends MetadataVisitor<ImageStreamBuilder> {
        public ImageStreamBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.IMAGESTREAM;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ImageStreamBuilder item) {
            return ((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((ImageStreamBuilder)item).hasMetadata(), () -> ((ImageStreamBuilder)item).withNewMetadata(), () -> ((ImageStreamBuilder)item).editMetadata(), () -> ((ImageStreamBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }

    public static class JobBuilderVisitor
    extends MetadataVisitor<JobBuilder> {
        public JobBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.JOB;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(JobBuilder item) {
            return ((JobBuilder)((JobFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((JobBuilder)item).hasMetadata(), () -> ((JobBuilder)item).withNewMetadata(), () -> ((JobBuilder)item).editMetadata(), () -> ((JobBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }

    public static class StatefulSetBuilderVisitor
    extends MetadataVisitor<StatefulSetBuilder> {
        public StatefulSetBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.STATEFUL_SET;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(StatefulSetBuilder item) {
            return ((StatefulSetBuilder)((StatefulSetFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((StatefulSetBuilder)item).hasMetadata(), () -> ((StatefulSetBuilder)item).withNewMetadata(), () -> ((StatefulSetBuilder)item).editMetadata(), () -> ((StatefulSetBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }

    public static class DaemonSetBuilderVisitor
    extends MetadataVisitor<DaemonSetBuilder> {
        public DaemonSetBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.DAEMON_SET;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(DaemonSetBuilder item) {
            return ((DaemonSetBuilder)((DaemonSetFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((DaemonSetBuilder)item).hasMetadata(), () -> ((DaemonSetBuilder)item).withNewMetadata(), () -> ((DaemonSetBuilder)item).editMetadata(), () -> ((DaemonSetBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }

    public static class DeploymentConfigBuilderVisitor
    extends MetadataVisitor<DeploymentConfigBuilder> {
        public DeploymentConfigBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.DEPLOYMENT;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(DeploymentConfigBuilder item) {
            return ((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((DeploymentConfigBuilder)item).hasMetadata(), () -> ((DeploymentConfigBuilder)item).withNewMetadata(), () -> ((DeploymentConfigBuilder)item).editMetadata(), () -> ((DeploymentConfigBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }

    public static class DeploymentBuilderVisitor
    extends MetadataVisitor<DeploymentBuilder> {
        public DeploymentBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.DEPLOYMENT;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(DeploymentBuilder item) {
            return ((DeploymentBuilder)((DeploymentFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((DeploymentBuilder)item).hasMetadata(), () -> ((DeploymentBuilder)item).withNewMetadata(), () -> ((DeploymentBuilder)item).editMetadata(), () -> ((DeploymentBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }

    public static class ReplicationControllerBuilderVisitor
    extends MetadataVisitor<ReplicationControllerBuilder> {
        public ReplicationControllerBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.REPLICATION_CONTROLLER;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ReplicationControllerBuilder item) {
            return ((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((ReplicationControllerBuilder)item).hasMetadata(), () -> ((ReplicationControllerBuilder)item).withNewMetadata(), () -> ((ReplicationControllerBuilder)item).editMetadata(), () -> ((ReplicationControllerBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }

    public static class ReplicaSet
    extends MetadataVisitor<ReplicaSetBuilder> {
        public ReplicaSet(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.REPLICA_SET;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ReplicaSetBuilder item) {
            return ((ReplicaSetBuilder)((ReplicaSetFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((ReplicaSetBuilder)item).hasMetadata(), () -> ((ReplicaSetBuilder)item).withNewMetadata(), () -> ((ReplicaSetBuilder)item).editMetadata(), () -> ((ReplicaSetBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }

    public static class ServiceBuilderVisitor
    extends MetadataVisitor<ServiceBuilder> {
        public ServiceBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.SERVICE;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ServiceBuilder item) {
            return ((ServiceBuilder)((ServiceFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((ServiceBuilder)item).hasMetadata(), () -> ((ServiceBuilder)item).withNewMetadata(), () -> ((ServiceBuilder)item).editMetadata(), () -> ((ServiceBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }

    public static class PodTemplateSpecBuilderVisitor
    extends MetadataVisitor<PodTemplateSpecBuilder> {
        public PodTemplateSpecBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.POD_SPEC;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(PodTemplateSpecBuilder item) {
            return ((PodTemplateSpecBuilder)((PodTemplateSpecFluent.MetadataNested)MetadataVisitor.addEmptyLabelsAndAnnotations(() -> ((PodTemplateSpecBuilder)item).hasMetadata(), () -> ((PodTemplateSpecBuilder)item).withNewMetadata(), () -> ((PodTemplateSpecBuilder)item).editMetadata(), () -> ((PodTemplateSpecBuilder)item).buildMetadata())).endMetadata()).buildMetadata();
        }
    }
}

