/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MapUtil;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PrometheusEnricher
extends BaseEnricher {
    static final String ANNOTATION_PROMETHEUS_PORT = "prometheus.io/port";
    static final String ANNOTATION_PROMETHEUS_SCRAPE = "prometheus.io/scrape";
    static final String ANNOTATION_PROMETHEUS_PATH = "prometheus.io/path";
    static final String ENRICHER_NAME = "f8-prometheus";
    static final String PROMETHEUS_PORT = "9779";

    public PrometheusEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, ENRICHER_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder serviceBuilder) {
                String prometheusPort = PrometheusEnricher.this.findPrometheusPort();
                if (StringUtils.isNotBlank((CharSequence)prometheusPort)) {
                    HashMap annotations = new HashMap();
                    MapUtil.putIfAbsent(annotations, (String)PrometheusEnricher.ANNOTATION_PROMETHEUS_PORT, (String)prometheusPort);
                    MapUtil.putIfAbsent(annotations, (String)PrometheusEnricher.ANNOTATION_PROMETHEUS_SCRAPE, (String)"true");
                    String prometheusPath = PrometheusEnricher.this.getConfig(Config.prometheusPath);
                    if (StringUtils.isNotBlank((CharSequence)prometheusPath)) {
                        MapUtil.putIfAbsent(annotations, (String)PrometheusEnricher.ANNOTATION_PROMETHEUS_PATH, (String)prometheusPath);
                    }
                    PrometheusEnricher.this.log.verbose(Logger.LogVerboseCategory.BUILD, "Adding prometheus.io annotations: %s", new Object[]{annotations.entrySet().stream().map(Object::toString).collect(Collectors.joining(", "))});
                    ((ServiceFluent.MetadataNested)serviceBuilder.editMetadata().addToAnnotations(annotations)).endMetadata();
                }
            }
        });
    }

    private String findPrometheusPort() {
        String prometheusPort = this.getConfig(Config.prometheusPort);
        if (StringUtils.isBlank((CharSequence)prometheusPort)) {
            for (ImageConfiguration configuration : this.getImages().orElse(Collections.emptyList())) {
                List ports;
                BuildImageConfiguration buildImageConfiguration = configuration.getBuildConfiguration();
                if (buildImageConfiguration == null || (ports = buildImageConfiguration.getPorts()) == null || !ports.contains(PROMETHEUS_PORT)) continue;
                prometheusPort = PROMETHEUS_PORT;
                break;
            }
        }
        return prometheusPort;
    }

    private static enum Config implements Configs.Key
    {
        prometheusPort,
        prometheusPath;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

