/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.config.ConfigMapEntry;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConfigMapEnricher
extends BaseEnricher {
    protected static final String PREFIX_ANNOTATION = "maven.fabric8.io/cm/";

    public ConfigMapEnricher(MavenEnricherContext enricherContext) {
        super((EnricherContext)enricherContext, "fmp-configmap-file");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        this.addAnnotations(builder);
        this.addConfigMapFromXmlConfigurations(builder);
    }

    private void addAnnotations(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ConfigMapBuilder>(){

            public void visit(ConfigMapBuilder element) {
                Map annotations = element.buildMetadata().getAnnotations();
                try {
                    Map configMapAnnotations = ConfigMapEnricher.this.createConfigMapFromAnnotations(annotations);
                    element.addToData(configMapAnnotations);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }

    private Map<String, String> createConfigMapFromAnnotations(Map<String, String> annotations) throws IOException {
        Set<Map.Entry<String, String>> entries = annotations.entrySet();
        HashMap<String, String> configMapFileLocations = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(PREFIX_ANNOTATION)) continue;
            configMapFileLocations.put(this.getOutput(key), this.readContent(entry.getValue()));
            it.remove();
        }
        return configMapFileLocations;
    }

    private String readContent(String location) throws IOException {
        return new String(Files.readAllBytes(Paths.get(location, new String[0])));
    }

    private String getOutput(String key) {
        return key.substring(PREFIX_ANNOTATION.length());
    }

    private void addConfigMapFromXmlConfigurations(KubernetesListBuilder builder) {
        io.fabric8.maven.core.config.ConfigMap configMap = this.getConfigMapFromXmlConfiguration();
        try {
            Map<String, String> configMapFromConfiguration = this.createConfigMapFromConfiguration(configMap);
            String configMapName = configMap == null || configMap.getName() == null || configMap.getName().trim().isEmpty() ? "xmlconfig" : configMap.getName().trim();
            this.log.debug("configMapName :: ".concat(configMapName), new Object[0]);
            if (!configMapFromConfiguration.isEmpty() && !this.checkIfItemExists(builder, configMapName)) {
                ConfigMapBuilder element = new ConfigMapBuilder();
                ((ConfigMapFluent.MetadataNested)element.withNewMetadata().withName(configMapName)).endMetadata();
                element.addToData(configMapFromConfiguration);
                builder.addToConfigMapItems(new ConfigMap[]{element.build()});
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean checkIfItemExists(KubernetesListBuilder builder, String name) {
        return builder.buildItems().stream().filter(item -> item.getKind().equals("ConfigMap")).anyMatch(item -> item.getMetadata().getName().equals(name));
    }

    private io.fabric8.maven.core.config.ConfigMap getConfigMapFromXmlConfiguration() {
        ResourceConfig resourceConfig = this.getConfiguration().getResource().orElse(null);
        if (resourceConfig != null && resourceConfig.getConfigMap() != null) {
            return resourceConfig.getConfigMap();
        }
        return null;
    }

    private Map<String, String> createConfigMapFromConfiguration(io.fabric8.maven.core.config.ConfigMap configMap) throws IOException {
        HashMap<String, String> configMapData = new HashMap<String, String>();
        if (configMap != null) {
            for (ConfigMapEntry configMapEntry : configMap.getEntries()) {
                String name = configMapEntry.getName();
                String value = configMapEntry.getValue();
                if (name != null && value != null) {
                    configMapData.put(name, value);
                    continue;
                }
                String file = configMapEntry.getFile();
                if (file == null) continue;
                if (name == null) {
                    name = Paths.get(file, new String[0]).getFileName().toString();
                }
                configMapData.put(name, this.readContent(file));
            }
        }
        return configMapData;
    }
}

