/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.GitUtil;
import io.fabric8.maven.core.util.kubernetes.Fabric8Annotations;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

public class GitEnricher
extends BaseEnricher {
    private String GIT_REMOTE = "fabric8.remoteName";

    public GitEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "fmp-git");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getAnnotations() {
        HashMap<String, String> annotations = new HashMap<String, String>();
        if (GitUtil.findGitFolder((File)this.getContext().getProjectDirectory()) != null) {
            Repository repository = null;
            try {
                Object branch;
                repository = GitUtil.getGitRepository((File)this.getContext().getProjectDirectory());
                if (repository != null) {
                    String gitRemote;
                    String id;
                    branch = repository.getBranch();
                    if (branch != null) {
                        annotations.put(Fabric8Annotations.GIT_BRANCH.value(), (String)branch);
                    }
                    if ((id = GitUtil.getGitCommitId((Repository)repository)) != null) {
                        annotations.put(Fabric8Annotations.GIT_COMMIT.value(), id);
                    }
                    gitRemote = (gitRemote = this.getContext().getConfiguration().getProperties().getProperty(this.GIT_REMOTE)) == null ? "origin" : gitRemote;
                    String gitRemoteUrl = repository.getConfig().getString("remote", gitRemote, "url");
                    if (gitRemoteUrl != null) {
                        annotations.put(Fabric8Annotations.GIT_URL.value(), gitRemoteUrl);
                    } else {
                        this.log.warn("Could not detect any git remote", new Object[0]);
                    }
                }
                branch = annotations;
                return branch;
            }
            catch (IOException | GitAPIException e) {
                this.log.error("Cannot extract Git information for adding to annotations: " + e, new Object[]{e});
                Map<String, String> map = null;
                return map;
            }
            finally {
                if (repository != null) {
                    try {
                        repository.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return annotations;
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder serviceBuilder) {
                ((ServiceFluent.MetadataNested)serviceBuilder.editMetadata().addToAnnotations(GitEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder builder) {
                ((DeploymentFluent.MetadataNested)builder.editMetadata().addToAnnotations(GitEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder builder) {
                ((DeploymentConfigFluent.MetadataNested)builder.editMetadata().addToAnnotations(GitEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder builder) {
                ((ReplicaSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(GitEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder builder) {
                ((ReplicationControllerFluent.MetadataNested)builder.editMetadata().addToAnnotations(GitEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DaemonSetBuilder>(){

            public void visit(DaemonSetBuilder builder) {
                ((DaemonSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(GitEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder builder) {
                ((StatefulSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(GitEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<JobBuilder>(){

            public void visit(JobBuilder builder) {
                ((JobFluent.MetadataNested)builder.editMetadata().addToAnnotations(GitEnricher.this.getAnnotations())).endMetadata();
            }
        });
    }
}

