/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.util.FileUtil;
import io.fabric8.maven.core.util.kubernetes.Fabric8Annotations;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class IngressEnricher
extends BaseEnricher {
    private String routeDomainPostfix;

    public IngressEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "fmp-ingress");
    }

    public void create(PlatformMode platformMode, final KubernetesListBuilder listBuilder) {
        ResourceConfig resourceConfig = this.getConfiguration().getResource().orElse(null);
        if (resourceConfig != null && resourceConfig.getRouteDomain() != null) {
            this.routeDomainPostfix = resourceConfig.getRouteDomain();
        }
        if (platformMode == PlatformMode.kubernetes) {
            listBuilder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

                public void visit(ServiceBuilder serviceBuilder) {
                    IngressEnricher.this.addIngress(listBuilder, serviceBuilder);
                }
            });
        }
    }

    private void addIngress(KubernetesListBuilder listBuilder, ServiceBuilder serviceBuilder) {
        Integer servicePort;
        String serviceName;
        ObjectMeta serviceMetadata = serviceBuilder.getMetadata();
        if (serviceMetadata != null && this.isExposedService(serviceMetadata) && this.shouldCreateExternalURLForService(serviceBuilder) && !this.hasIngress(listBuilder, serviceName = serviceMetadata.getName()) && (servicePort = this.getServicePort(serviceBuilder)) != null) {
            IngressBuilder ingressBuilder = (IngressBuilder)((IngressBuilder)new IngressBuilder().withMetadata(serviceMetadata)).withNewSpec().endSpec();
            ingressBuilder.withNewMetadataLike(this.removeExposeLabel(ingressBuilder.getMetadata()));
            if (StringUtils.isNotBlank((CharSequence)this.routeDomainPostfix)) {
                this.routeDomainPostfix = serviceName + "." + FileUtil.stripPrefix((String)this.routeDomainPostfix, (String)".");
                ingressBuilder = (IngressBuilder)ingressBuilder.withSpec(((IngressSpecBuilder)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((IngressSpecFluent.RulesNested)new IngressSpecBuilder().addNewRule().withHost(this.routeDomainPostfix)).withNewHttp().withPaths(new HTTPIngressPath[]{((HTTPIngressPathBuilder)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)new HTTPIngressPathBuilder().withNewBackend().withServiceName(serviceName)).withServicePort(KubernetesHelper.createIntOrString((int)this.getServicePort(serviceBuilder)))).endBackend()).build()})).endHttp()).endRule()).build());
            } else {
                ingressBuilder.withSpec(((IngressSpecBuilder)new IngressSpecBuilder().withBackend(((IngressBackendBuilder)((IngressBackendBuilder)new IngressBackendBuilder().withNewServiceName(serviceName)).withNewServicePort(this.getServicePort(serviceBuilder))).build())).build());
            }
            listBuilder.addToIngressItems(new Ingress[]{ingressBuilder.build()});
        }
    }

    private Integer getServicePort(ServiceBuilder serviceBuilder) {
        List ports;
        ServiceSpec spec = serviceBuilder.getSpec();
        if (spec != null && (ports = spec.getPorts()) != null && ports.size() > 0) {
            for (ServicePort port : ports) {
                if (!port.getName().equals("http") && !port.getProtocol().equals("http")) continue;
                return port.getPort();
            }
            ServicePort servicePort = (ServicePort)ports.get(0);
            if (servicePort != null) {
                return servicePort.getPort();
            }
        }
        return null;
    }

    private boolean hasIngress(KubernetesListBuilder listBuilder, final String name) {
        final AtomicBoolean answer = new AtomicBoolean(false);
        listBuilder.accept((Visitor)new TypedVisitor<IngressBuilder>(){

            public void visit(IngressBuilder builder) {
                ObjectMeta metadata = builder.getMetadata();
                if (metadata != null && name.equals(metadata.getName())) {
                    answer.set(true);
                }
            }
        });
        return answer.get();
    }

    private ObjectMeta removeExposeLabel(ObjectMeta metadata) {
        Map labels = null;
        if (metadata != null && (labels = metadata.getLabels()) != null) {
            if ("true".equals(labels.get("expose"))) {
                labels.remove("expose");
            }
            if ("true".equals(labels.get(Fabric8Annotations.SERVICE_EXPOSE_URL.value()))) {
                labels.remove(Fabric8Annotations.SERVICE_EXPOSE_URL.value());
            }
        }
        return metadata;
    }

    private boolean isExposedService(ObjectMeta metadata) {
        if (metadata != null) {
            Map labels = metadata.getLabels();
            if (labels != null && ("true".equals(labels.get("expose")) || "true".equals(labels.get(Fabric8Annotations.SERVICE_EXPOSE_URL.value())))) {
                return true;
            }
        } else {
            this.log.info("No Metadata for service! " + metadata.getName(), new Object[0]);
        }
        return false;
    }

    private boolean shouldCreateExternalURLForService(ServiceBuilder service) {
        String serviceName = service.getMetadata().getName();
        if ("kubernetes".equals(serviceName) || "kubernetes-ro".equals(serviceName)) {
            return false;
        }
        ServiceSpec spec = service.getSpec();
        List ports = spec.getPorts();
        this.log.debug("Service " + serviceName + " has ports: " + ports, new Object[0]);
        if (ports.size() == 1) {
            String type = null;
            if (spec != null && Objects.equals(type = spec.getType(), "LoadBalancer")) {
                return true;
            }
            this.log.info("Not generating Ingress for service " + serviceName + " type is not LoadBalancer: " + type, new Object[0]);
            return false;
        }
        this.log.info("Not generating Ingress for service " + serviceName + " as only single port services are supported. Has ports: " + ports, new Object[0]);
        return false;
    }
}

