/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.config.SecretConfig;
import io.fabric8.maven.core.util.Base64Util;
import io.fabric8.maven.core.util.SecretConstants;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class SecretEnricher
extends BaseEnricher {
    public SecretEnricher(MavenEnricherContext buildContext, String name) {
        super((EnricherContext)buildContext, name);
    }

    protected String encode(String raw) {
        return Base64Util.encodeToString((String)raw);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<SecretBuilder>(){

            public void visit(SecretBuilder secretBuilder) {
                Map annotation = secretBuilder.buildMetadata().getAnnotations();
                if (annotation != null) {
                    if (!annotation.containsKey(SecretEnricher.this.getAnnotationKey())) {
                        return;
                    }
                    String dockerId = (String)annotation.get(SecretEnricher.this.getAnnotationKey());
                    Map<String, String> data = SecretEnricher.this.generateData(dockerId);
                    if (data == null) {
                        return;
                    }
                    annotation.remove(SecretEnricher.this.getAnnotationKey());
                    secretBuilder.addToData(data);
                }
            }
        });
        this.addSecretsFromXmlConfiguration(builder);
    }

    private void addSecretsFromXmlConfiguration(KubernetesListBuilder builder) {
        this.log.verbose(Logger.LogVerboseCategory.BUILD, "Adding secrets resources from plugin configuration", new Object[0]);
        List<SecretConfig> secrets = this.getSecretsFromXmlConfig();
        HashMap<String, Integer> secretToIndexMap = new HashMap<String, Integer>();
        if (secrets == null || secrets.isEmpty()) {
            return;
        }
        Integer index = 0;
        while (index < builder.buildItems().size()) {
            if (builder.buildItems().get(index) instanceof Secret) {
                secretToIndexMap.put(((HasMetadata)builder.buildItems().get(index)).getMetadata().getName(), index);
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        for (int i = 0; i < secrets.size(); ++i) {
            SecretConfig secretConfig = secrets.get(i);
            if (StringUtils.isBlank((CharSequence)secretConfig.getName())) {
                this.log.warn("Secret name is empty. You should provide a proper name for the secret", new Object[0]);
                continue;
            }
            HashMap<String, String> data = new HashMap<String, String>();
            String type = "";
            ObjectMeta metadata = ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withNamespace(secretConfig.getNamespace())).withName(secretConfig.getName())).build();
            if (secretConfig.getDockerServerId() != null) {
                MavenEnricherContext mavenContext = (MavenEnricherContext)this.getContext();
                String dockerSecret = mavenContext.getDockerJsonConfigString(mavenContext.getSettings(), secretConfig.getDockerServerId());
                if (StringUtils.isBlank((CharSequence)dockerSecret)) {
                    this.log.warn("Docker secret with id " + secretConfig.getDockerServerId() + " cannot be found in maven settings", new Object[0]);
                    continue;
                }
                data.put(SecretConstants.DOCKER_DATA_KEY, Base64Util.encodeToString((String)dockerSecret));
                type = SecretConstants.DOCKER_CONFIG_TYPE;
            }
            if (StringUtils.isBlank((CharSequence)type) || data.isEmpty()) {
                this.log.warn("No data can be found for docker secret with id " + secretConfig.getDockerServerId(), new Object[0]);
                continue;
            }
            Secret secret = ((SecretBuilder)((SecretBuilder)((SecretBuilder)new SecretBuilder().withData(data)).withMetadata(metadata)).withType(type)).build();
            if (secretToIndexMap.containsKey(secretConfig.getName())) continue;
            builder.addToSecretItems(i, secret);
        }
    }

    private List<SecretConfig> getSecretsFromXmlConfig() {
        ResourceConfig resourceConfig = this.getConfiguration().getResource().orElse(null);
        if (resourceConfig != null && resourceConfig.getSecrets() != null) {
            return resourceConfig.getSecrets();
        }
        return null;
    }

    protected abstract String getAnnotationKey();

    protected abstract Map<String, String> generateData(String var1);
}

