/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard.openshift;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.util.FileUtil;
import io.fabric8.maven.core.util.kubernetes.Fabric8Annotations;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RoutePort;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class RouteEnricher
extends BaseEnricher {
    private Boolean generateRoute = this.getValueFromConfig("fabric8.openshift.generateRoute", true);
    private String routeDomainPostfix;

    public RouteEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "fmp-openshift-route");
    }

    public void create(PlatformMode platformMode, final KubernetesListBuilder listBuilder) {
        ResourceConfig resourceConfig = this.getConfiguration().getResource().orElse(null);
        if (resourceConfig != null && resourceConfig.getRouteDomain() != null) {
            this.routeDomainPostfix = resourceConfig.getRouteDomain();
        }
        if (platformMode == PlatformMode.openshift && this.generateRoute.equals(Boolean.TRUE)) {
            final ArrayList routes = new ArrayList();
            listBuilder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

                public void visit(ServiceBuilder serviceBuilder) {
                    RouteEnricher.this.addRoute(listBuilder, serviceBuilder, routes);
                }
            });
            if (!routes.isEmpty()) {
                Route[] routeArray = new Route[routes.size()];
                routes.toArray(routeArray);
                listBuilder.addToRouteItems(routeArray);
            }
        }
    }

    private RoutePort createRoutePort(ServiceBuilder serviceBuilder) {
        IntOrString targetPort;
        ServicePort servicePort;
        List ports;
        RoutePort routePort = null;
        ServiceSpec spec = serviceBuilder.getSpec();
        if (spec != null && (ports = spec.getPorts()) != null && ports.size() > 0 && (servicePort = (ServicePort)ports.get(0)) != null && (targetPort = servicePort.getTargetPort()) != null) {
            routePort = new RoutePort();
            routePort.setTargetPort(targetPort);
        }
        return routePort;
    }

    private String prepareHostForRoute(String routeDomainPostfix, String name) {
        String ret = FileUtil.stripPostfix((String)name, (String)"-service");
        ret = FileUtil.stripPostfix((String)ret, (String)".");
        ret = ret + ".";
        ret = ret + FileUtil.stripPrefix((String)routeDomainPostfix, (String)".");
        return ret;
    }

    private Set<Integer> getPorts(ServiceBuilder service) {
        HashSet<Integer> answer = new HashSet<Integer>();
        if (service != null) {
            ServiceSpec spec = RouteEnricher.getOrCreateSpec(service);
            for (ServicePort port : spec.getPorts()) {
                answer.add(port.getPort());
            }
        }
        return answer;
    }

    public static ServiceSpec getOrCreateSpec(ServiceBuilder entity) {
        ServiceSpec spec = entity.getSpec();
        if (spec == null) {
            spec = new ServiceSpec();
            entity.editOrNewSpec().endSpec();
        }
        return spec;
    }

    private boolean hasExactlyOneServicePort(ServiceBuilder service, String id) {
        Set<Integer> ports = this.getPorts(service);
        if (ports.size() != 1) {
            this.log.info("Not generating route for service " + id + " as only single port services are supported. Has ports: " + ports, new Object[0]);
            return false;
        }
        return true;
    }

    private void addRoute(KubernetesListBuilder listBuilder, ServiceBuilder serviceBuilder, List<Route> routes) {
        String name;
        ObjectMeta serviceMetadata = serviceBuilder.getMetadata();
        if (serviceMetadata != null && StringUtils.isNotBlank((CharSequence)serviceMetadata.getName()) && this.hasExactlyOneServicePort(serviceBuilder, serviceMetadata.getName()) && this.isExposedService(serviceMetadata) && !this.hasRoute(listBuilder, name = serviceMetadata.getName())) {
            this.routeDomainPostfix = StringUtils.isNotBlank((CharSequence)this.routeDomainPostfix) ? this.prepareHostForRoute(this.routeDomainPostfix, name) : "";
            RoutePort routePort = this.createRoutePort(serviceBuilder);
            if (routePort != null) {
                RouteBuilder routeBuilder = (RouteBuilder)((RouteFluent.SpecNested)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteFluent.SpecNested)((RouteBuilder)new RouteBuilder().withMetadata(serviceMetadata)).withNewSpec().withPort(routePort)).withNewTo().withKind("Service")).withName(name)).endTo()).withHost(this.routeDomainPostfix.isEmpty() ? null : this.routeDomainPostfix)).endSpec();
                routeBuilder.withNewMetadataLike(this.removeExposeLabel(routeBuilder.getMetadata()));
                routes.add(routeBuilder.build());
            }
        }
    }

    private boolean hasRoute(KubernetesListBuilder listBuilder, final String name) {
        final AtomicBoolean answer = new AtomicBoolean(false);
        listBuilder.accept((Visitor)new TypedVisitor<RouteBuilder>(){

            public void visit(RouteBuilder builder) {
                ObjectMeta metadata = builder.getMetadata();
                if (metadata != null && name.equals(metadata.getName())) {
                    answer.set(true);
                }
            }
        });
        return answer.get();
    }

    private ObjectMeta removeExposeLabel(ObjectMeta metadata) {
        Map labels = null;
        if (metadata != null && (labels = metadata.getLabels()) != null) {
            if ("true".equals(labels.get("expose"))) {
                labels.remove("expose");
            }
            if ("true".equals(labels.get(Fabric8Annotations.SERVICE_EXPOSE_URL.value()))) {
                labels.remove(Fabric8Annotations.SERVICE_EXPOSE_URL.value());
            }
        }
        return metadata;
    }

    private boolean isExposedService(ObjectMeta metadata) {
        if (metadata != null) {
            Map labels = metadata.getLabels();
            if (labels != null && ("true".equals(labels.get("expose")) || "true".equals(labels.get(Fabric8Annotations.SERVICE_EXPOSE_URL.value())))) {
                return true;
            }
        } else {
            this.log.info("No Metadata for service! " + metadata.getName(), new Object[0]);
        }
        return false;
    }
}

