/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api;

import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.RuntimeMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.generator.api.DefaultImageLookup;
import io.fabric8.maven.generator.api.GeneratorContext;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class FromSelector {
    private final GeneratorContext context;
    private final Pattern REDHAT_VERSION_PATTERN = Pattern.compile("^.*\\.(redhat|fuse)-.*$");
    private Plugin plugin;
    private Plugin compilerPlugin;

    public FromSelector(GeneratorContext context) {
        this.context = context;
    }

    public String getFrom() {
        RuntimeMode mode = this.context.getRuntimeMode();
        OpenShiftBuildStrategy strategy = this.context.getStrategy();
        if (mode == RuntimeMode.openshift && strategy == OpenShiftBuildStrategy.s2i) {
            return this.getS2iBuildFrom();
        }
        return this.getDockerBuildFrom();
    }

    public Map<String, String> getImageStreamTagFromExt() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(OpenShiftBuildStrategy.SourceStrategy.kind.key(), "ImageStreamTag");
        ret.put(OpenShiftBuildStrategy.SourceStrategy.namespace.key(), "openshift");
        ret.put(OpenShiftBuildStrategy.SourceStrategy.name.key(), this.getIstagFrom());
        return ret;
    }

    protected abstract String getDockerBuildFrom();

    protected abstract String getS2iBuildFrom();

    protected abstract String getIstagFrom();

    public boolean isRedHat() {
        MavenProject project = this.context.getProject();
        this.plugin = MavenUtil.getPlugin((MavenProject)project, (String)"io.fabric8", (String)"fabric8-maven-plugin");
        if (this.plugin == null) {
            this.plugin = project.getPlugin("org.jboss.redhat-fuse:fabric8-maven-plugin");
        }
        if (this.plugin == null) {
            return false;
        }
        String version = this.plugin.getVersion();
        return this.REDHAT_VERSION_PATTERN.matcher(version).matches();
    }

    public boolean isJava11() {
        MavenProject project = this.context.getProject();
        this.compilerPlugin = MavenUtil.getPlugin((MavenProject)project, (String)"org.apache.maven.plugins", (String)"maven-compiler-plugin");
        if (this.compilerPlugin == null) {
            return false;
        }
        Xpp3Dom dom = (Xpp3Dom)this.compilerPlugin.getConfiguration();
        String releaseVersion = "8";
        if (dom != null && dom.getChild("release") != null) {
            releaseVersion = dom.getChild("release").getValue();
        }
        Properties properties = project.getProperties();
        if (this.isEleven(releaseVersion)) {
            return true;
        }
        try {
            releaseVersion = (String)properties.entrySet().stream().filter(entry -> entry.getKey().equals("maven.compiler.release")).findFirst().get().getValue();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return this.isEleven(releaseVersion);
    }

    private boolean isEleven(String s) {
        return Configs.asInt((String)s) == 11;
    }

    public static class Default
    extends FromSelector {
        private final String upstreamDocker;
        private final String upstreamS2i;
        private final String redhatDocker;
        private final String redhatS2i;
        private final String redhatIstag;
        private final String upstreamIstag;

        public Default(GeneratorContext context, String prefix) {
            super(context);
            DefaultImageLookup lookup = new DefaultImageLookup(Default.class);
            this.upstreamDocker = prefix.equals("java") || prefix.equals("test") ? (this.isJava11() ? lookup.getImageName(prefix + ".11.upstream.docker") : lookup.getImageName(prefix + ".8.upstream.docker")) : lookup.getImageName(prefix + ".upstream.docker");
            this.upstreamS2i = lookup.getImageName(prefix + ".upstream.s2i");
            this.upstreamIstag = lookup.getImageName(prefix + ".upstream.istag");
            this.redhatDocker = lookup.getImageName(prefix + ".redhat.docker");
            this.redhatS2i = lookup.getImageName(prefix + ".redhat.s2i");
            this.redhatIstag = lookup.getImageName(prefix + ".redhat.istag");
        }

        @Override
        protected String getDockerBuildFrom() {
            return this.isRedHat() ? this.redhatDocker : this.upstreamDocker;
        }

        @Override
        protected String getS2iBuildFrom() {
            return this.isRedHat() ? this.redhatS2i : this.upstreamS2i;
        }

        @Override
        protected String getIstagFrom() {
            return this.isRedHat() ? this.redhatIstag : this.upstreamIstag;
        }
    }
}

