/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api.support;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.PrefixedLogger;
import io.fabric8.maven.generator.api.PortsExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;

public abstract class AbstractPortsExtractor
implements PortsExtractor {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String DOT = ".";
    private static final String JSON_EXTENSION = ".json";
    private static final String YAML_EXTENSION = ".yaml";
    private static final String YML_EXTENSION = ".yml";
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String NUMBER_REGEX = "\\d+";
    private static final String PORT_REGEX = "([a-zA-Z0-9_]+)(([\\.-_]+p)|([P]))ort";
    private static final Pattern PORT_PATTERN = Pattern.compile("([a-zA-Z0-9_]+)(([\\.-_]+p)|([P]))ort");
    private final PrefixedLogger log;

    public AbstractPortsExtractor(PrefixedLogger log) {
        this.log = log;
    }

    public abstract String getConfigPathPropertyName();

    public abstract String getConfigPathFromProject(MavenProject var1);

    public File getConfigLocation(MavenProject project) {
        String propertyName = this.getConfigPathPropertyName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return null;
        }
        String configPath = Configs.getSystemPropertyWithMavenPropertyAsFallback((Properties)project.getProperties(), (String)this.getConfigPathPropertyName());
        if (configPath == null) {
            configPath = this.getConfigPathFromProject(project);
        }
        if (StringUtils.isBlank((CharSequence)configPath)) {
            return null;
        }
        return Paths.get(configPath, new String[0]).toFile();
    }

    @Override
    public Map<String, Integer> extract(MavenProject project) {
        HashMap<String, Integer> answer = new HashMap<String, Integer>();
        File configFile = this.getConfigLocation(project);
        if (configFile == null) {
            return answer;
        }
        if (!configFile.exists()) {
            this.log.warn("Could not find config: %s. Ignoring.", new Object[]{configFile.getAbsolutePath()});
            return answer;
        }
        try {
            Map<String, String> configMap = this.readConfig(configFile);
            for (Map.Entry<String, String> entry : configMap.entrySet()) {
                String key = entry.getKey();
                if (!this.isValidPortPropertyKey(key)) continue;
                this.addPortIfValid(answer, key, entry.getValue());
            }
            return answer;
        }
        catch (IOException e) {
            this.log.warn("Error reading config: [%s], due to: [%s]. Ignoring.", new Object[]{configFile.getAbsolutePath(), e.getMessage()});
            return answer;
        }
    }

    private Map<String, String> readConfig(File f) throws IOException {
        Map<String, String> map;
        if (f.getName().endsWith(JSON_EXTENSION)) {
            map = this.flatten((Map)JSON_MAPPER.readValue(f, Map.class));
        } else if (f.getName().endsWith(YAML_EXTENSION) || f.getName().endsWith(YML_EXTENSION)) {
            map = this.flatten((Map)YAML_MAPPER.readValue(f, Map.class));
        } else if (f.getName().endsWith(PROPERTIES_EXTENSION)) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(f));
            map = this.propertiesToMap(properties);
        } else {
            throw new IllegalArgumentException("Can't read configuration from: [" + f.getName() + "]. Unknown file extension.");
        }
        return map;
    }

    private Map<String, String> flatten(Map map) {
        HashMap<String, String> flat = new HashMap<String, String>();
        for (Object key : map.keySet()) {
            String stringKey = String.valueOf(key);
            Object value = map.get(key);
            if (value instanceof String) {
                flat.put(stringKey, (String)value);
                continue;
            }
            if (value instanceof Map) {
                for (Map.Entry<String, String> entry : this.flatten((Map)value).entrySet()) {
                    flat.put(stringKey + DOT + entry.getKey(), entry.getValue());
                }
                continue;
            }
            flat.put(stringKey, String.valueOf(value));
        }
        return flat;
    }

    private Map<String, String> propertiesToMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return map;
    }

    private boolean isValidPortPropertyKey(String candidate) {
        return PORT_PATTERN.matcher(candidate).matches();
    }

    private void addPortIfValid(Map<String, Integer> map, String key, String port) {
        String t;
        if (StringUtils.isNotBlank((CharSequence)port) && (t = port.trim()).matches(NUMBER_REGEX)) {
            map.put(key, Integer.parseInt(t));
        }
    }
}

